/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.proxy;

import com.google.common.base.MoreObjects;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.tellme.TellMe;
import fi.dy.masa.tellme.command.ClientCommandTellme;
import fi.dy.masa.tellme.config.Configs;
import fi.dy.masa.tellme.datadump.DataDump;
import fi.dy.masa.tellme.datadump.ItemDump;
import fi.dy.masa.tellme.proxy.CommonProxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.apache.commons.lang3.tuple.Pair;

public class ClientProxy
extends CommonProxy {
    @Override
    @Nullable
    public Iterable<Advancement> getAdvacements(ICommandSender sender) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.func_71356_B() && mc.field_71439_g != null) {
            WorldServer world = DimensionManager.getWorld((int)mc.field_71439_g.func_130014_f_().field_73011_w.getDimension());
            if (world instanceof WorldServer) {
                return world.func_191952_z().func_192780_b();
            }
        } else {
            INetHandler nh = FMLClientHandler.instance().getClientPlayHandler();
            if (nh instanceof NetHandlerPlayClient) {
                return ((NetHandlerPlayClient)nh).func_191982_f().func_194229_a().func_192089_c();
            }
        }
        return null;
    }

    @Override
    public String getBiomeName(Biome biome) {
        return biome.func_185359_l();
    }

    @Override
    public ICommandManager getCommandHandler() {
        if (!Minecraft.func_71410_x().func_71356_B()) {
            return ClientCommandHandler.instance;
        }
        return super.getCommandHandler();
    }

    @Override
    public void getCurrentBiomeInfoClientSide(EntityPlayer player, Biome biome) {
        BlockPos pos = player.func_180425_c();
        String pre = TextFormatting.GREEN.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.WHITE.toString();
        int color = biome.func_180627_b(pos);
        player.func_145747_a((ITextComponent)new TextComponentString(String.format("Grass color: %s0x%08X%s (%s%d%s)", pre, color, rst, pre, color, rst)));
        color = biome.func_180625_c(pos);
        player.func_145747_a((ITextComponent)new TextComponentString(String.format("Foliage color: %s0x%08X%s (%s%d%s)", pre, color, rst, pre, color, rst)));
    }

    @Override
    public Pair<Integer, Integer> getBiomeGrassAndFoliageColors(Biome biome) {
        return Pair.of((Object)this.getGrassColor(biome), (Object)this.getFoliageColor(biome));
    }

    private int getGrassColor(Biome biome) {
        double temperature = MathHelper.func_76131_a((float)biome.func_185353_n(), (float)0.0f, (float)1.0f);
        double humidity = MathHelper.func_76131_a((float)biome.func_76727_i(), (float)0.0f, (float)1.0f);
        return biome.getModdedBiomeGrassColor(ColorizerGrass.func_77480_a((double)temperature, (double)humidity));
    }

    private int getFoliageColor(Biome biome) {
        double temperature = MathHelper.func_76131_a((float)biome.func_185353_n(), (float)0.0f, (float)1.0f);
        double humidity = MathHelper.func_76131_a((float)biome.func_76727_i(), (float)0.0f, (float)1.0f);
        return biome.getModdedBiomeFoliageColor(ColorizerFoliage.func_77470_a((double)temperature, (double)humidity));
    }

    @Override
    public void addCreativeTabData(DataDump dump) {
        for (int i = 0; i < CreativeTabs.field_78032_a.length; ++i) {
            CreativeTabs tab = CreativeTabs.field_78032_a[i];
            if (tab == null) continue;
            String index = String.valueOf(i);
            String name = tab.func_78013_b();
            String key = tab.func_78024_c();
            ItemStack stack = tab.func_78016_d();
            if (key == null) {
                TellMe.logger.warn("null translation key for tab at index {} (name: '{}')", (Object)tab.func_78021_a(), (Object)name);
                continue;
            }
            if (name == null) {
                TellMe.logger.warn("null name for tab at index {} (translation key: '{}')", (Object)tab.func_78021_a(), (Object)key);
                continue;
            }
            if (stack == null) {
                TellMe.logger.warn("null icon item for tab at index {} (name: '{}', translation key: '{}')", (Object)tab.func_78021_a(), (Object)name, (Object)key);
                continue;
            }
            String translatedName = I18n.func_135052_a((String)key, (Object[])new Object[0]);
            String iconItem = ItemDump.getStackInfoBasic(stack);
            dump.addData(index, name, translatedName, iconItem);
        }
    }

    @Override
    public void addCreativeTabNames(JsonObject obj, Item item) {
        CreativeTabs[] tabs = item.getCreativeTabs();
        CharSequence[] ctNames = new String[tabs.length];
        int i = 0;
        int count = 0;
        for (CreativeTabs tab : tabs) {
            if (tab == null) continue;
            ctNames[i++] = I18n.func_135052_a((String)tab.func_78024_c(), (Object[])new Object[0]);
            ++count;
        }
        ctNames = Arrays.copyOf(ctNames, count);
        obj.add("CreativeTabs", (JsonElement)new JsonPrimitive(String.join((CharSequence)",", ctNames)));
    }

    @Override
    public void addMusicTypeData(DataDump dump) {
        for (MusicTicker.MusicType music : MusicTicker.MusicType.values()) {
            SoundEvent sound = music.func_188768_a();
            String minDelay = String.valueOf(music.func_148634_b());
            String maxDelay = String.valueOf(music.func_148633_c());
            ResourceLocation regName = (ResourceLocation)SoundEvent.field_187505_a.func_177774_c((Object)sound);
            dump.addData(music.name().toLowerCase(), regName != null ? regName.toString() : "<null>", minDelay, maxDelay);
        }
    }

    @Override
    public void getExtendedBlockStateInfo(World world, IBlockState state, BlockPos pos, List<String> lines) {
        IExtendedBlockState extendedState;
        try {
            state = state.func_177230_c().getExtendedState(state, (IBlockAccess)world, pos);
        }
        catch (Exception e) {
            TellMe.logger.error("getFullBlockInfo(): Exception while calling getExtendedState() on the block");
        }
        if (state instanceof IExtendedBlockState && (extendedState = (IExtendedBlockState)state).getUnlistedProperties().size() > 0) {
            lines.add("IExtendedBlockState properties:");
            for (Map.Entry entry : extendedState.getUnlistedProperties().entrySet()) {
                lines.add(MoreObjects.toStringHelper(entry.getKey()).add("name", (Object)((IUnlistedProperty)entry.getKey()).getName()).add("clazz", (Object)((IUnlistedProperty)entry.getKey()).getType()).add("value", (Object)((Optional)entry.getValue()).toString()).toString());
            }
        }
    }

    @Override
    public Collection<Chunk> getLoadedChunks(World world) {
        Collection<Chunk> chunksServer = super.getLoadedChunks(world);
        if (!chunksServer.isEmpty()) {
            return chunksServer;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            BlockPos pos = player.func_180425_c();
            int cX = pos.func_177958_n() >> 4;
            int cZ = pos.func_177952_p() >> 4;
            int radius = Minecraft.func_71410_x().field_71474_y.field_151451_c + 1;
            IChunkProvider provider = world.func_72863_F();
            ArrayList<Chunk> chunks = new ArrayList<Chunk>();
            for (int z = cZ - radius; z <= cZ + radius; ++z) {
                for (int x = cX - radius; x <= cX + radius; ++x) {
                    Chunk chunk = provider.func_186026_b(x, z);
                    if (chunk == null) continue;
                    chunks.add(chunk);
                }
            }
            return chunks;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public boolean isSinglePlayer() {
        return Minecraft.func_71410_x().func_71356_B();
    }

    @Override
    public void registerClientCommand() {
        TellMe.logger.info("Registering the client-side command");
        ClientCommandHandler.instance.func_71560_a((ICommand)new ClientCommandTellme());
    }

    @Override
    public void registerEventHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)new Configs());
    }
}

