/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.event.datalogging;

import fi.dy.masa.tellme.event.datalogging.DataEntry;
import fi.dy.masa.tellme.event.datalogging.DataLogger;
import fi.dy.masa.tellme.event.datalogging.LoggerBase;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;

public class LoggerWrapper
extends LoggerBase {
    private static final Pattern PATTERN_CHUNK_POS = Pattern.compile("(-?[0-9]+),(-?[0-9]+)");
    protected Set<ChunkPos> chunkFilters = new HashSet<ChunkPos>();

    public LoggerWrapper(DataLogger.DataType type) {
        super(type);
    }

    @Override
    public void addFilters(String[] filters) {
        for (String str : filters) {
            Matcher matcher = PATTERN_CHUNK_POS.matcher(str);
            if (!matcher.matches()) continue;
            try {
                int x = Integer.parseInt(matcher.group(1));
                int z = Integer.parseInt(matcher.group(2));
                this.chunkFilters.add(new ChunkPos(x, z));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void removeFilters(String[] filters) {
        for (String str : filters) {
            Matcher matcher = PATTERN_CHUNK_POS.matcher(str);
            if (!matcher.matches()) continue;
            try {
                int x = Integer.parseInt(matcher.group(1));
                int z = Integer.parseInt(matcher.group(2));
                this.chunkFilters.remove(new ChunkPos(x, z));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void onChunkEvent(Chunk chunk) {
        if (this.enabled && (this.enablePrint || this.enableLog) && (!this.useFilter || this.chunkFilters.contains(new ChunkPos(chunk.field_76635_g, chunk.field_76647_h)))) {
            this.handleData(this.createChunkDataEntry(chunk));
        }
    }

    @Override
    public void onEntityEvent(Entity entity) {
        if (this.enabled && (this.enablePrint || this.enableLog) && (!this.useFilter || this.chunkFilters.contains(new ChunkPos((int)(entity.field_70165_t / 16.0), (int)(entity.field_70165_t / 16.0))))) {
            this.handleData(this.createEntityDataEntry(entity));
        }
    }

    @Nullable
    private DataEntry.DataEntryChunkEventBase createChunkDataEntry(Chunk chunk) {
        switch (this.type) {
            case CHUNK_LOAD: {
                return new DataEntry.DataEntryChunkEventLoad(chunk);
            }
            case CHUNK_UNLOAD: {
                return new DataEntry.DataEntryChunkEventUnload(chunk);
            }
        }
        return null;
    }

    @Nullable
    private DataEntry.DataEntryEntityEvent createEntityDataEntry(Entity entity) {
        switch (this.type) {
            case ENTITY_JOIN_WORLD: {
                return new DataEntry.DataEntryEntityEvent(entity);
            }
        }
        return null;
    }
}

