/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.event.datalogging;

import fi.dy.masa.tellme.TellMe;
import fi.dy.masa.tellme.datadump.DataDump;
import fi.dy.masa.tellme.event.datalogging.DataEntry;
import fi.dy.masa.tellme.event.datalogging.DataLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.world.chunk.Chunk;

public class LoggerBase {
    protected final DataLogger.DataType type;
    protected final List<DataEntry.DataEntryBase<?>> loggedData = new ArrayList();
    protected boolean enablePrint;
    protected boolean enableLog;
    protected boolean enabled;
    protected boolean useFilter;

    public LoggerBase(DataLogger.DataType type) {
        this.type = type;
        this.enabled = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setFilterEnabled(boolean useFilters) {
        this.useFilter = useFilters;
    }

    public boolean isFilterEnabled() {
        return this.useFilter;
    }

    public void addFilters(String[] filters) {
    }

    public void removeFilters(String[] filters) {
    }

    public boolean isOutputTypeEnabled(OutputType type) {
        switch (type) {
            case PRINT: {
                return this.enablePrint;
            }
            case LOG: {
                return this.enableLog;
            }
        }
        return false;
    }

    public void setOutputTypeEnabled(OutputType type, boolean enable) {
        switch (type) {
            case PRINT: {
                this.enablePrint = enable;
                break;
            }
            case LOG: {
                this.enableLog = enable;
            }
        }
    }

    public void clearData() {
        this.loggedData.clear();
    }

    @Nullable
    public File dumpData(DataDump.Format format, int dimension) {
        if (this.loggedData.size() > 0) {
            DataDump dump = this.loggedData.get(0).createDataDump(format);
            for (DataEntry.DataEntryBase<?> entry : this.loggedData) {
                entry.addDataToDump(dump);
            }
            return DataDump.dumpDataToFile("logged_data_" + this.type.getArgName() + "_dim_" + dimension, dump.getLines());
        }
        return null;
    }

    protected void handleData(DataEntry.DataEntryBase<?> data) {
        if (data != null) {
            if (this.enablePrint) {
                TellMe.logger.info(data.getPrintLine());
            }
            if (this.enableLog) {
                this.loggedData.add(data);
            }
        }
    }

    public void onChunkEvent(Chunk chunk) {
    }

    public void onEntityEvent(Entity entity) {
    }

    public static enum OutputType {
        PRINT,
        LOG;

    }
}

