/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.event.datalogging;

import fi.dy.masa.tellme.event.datalogging.DataLogger;
import fi.dy.masa.tellme.event.datalogging.EventHandlerChunkLoad;
import fi.dy.masa.tellme.event.datalogging.EventHandlerChunkUnload;
import fi.dy.masa.tellme.event.datalogging.EventHandlerEntityJoinWorld;
import java.util.EnumMap;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;

public class EventManager {
    private static final EnumMap<DataLogger.DataType, Boolean> REGISTERED_HANDLERS = new EnumMap(DataLogger.DataType.class);
    private static final EnumMap<DataLogger.DataType, Object> HANDLER_INSTANCES = new EnumMap(DataLogger.DataType.class);

    public static void registerHandler(DataLogger.DataType type) {
        if (REGISTERED_HANDLERS.get((Object)type) == null) {
            Object handler = HANDLER_INSTANCES.get((Object)type);
            if (handler == null) {
                handler = EventManager.createHandler(type);
                if (handler == null) {
                    return;
                }
                HANDLER_INSTANCES.put(type, handler);
            }
            MinecraftForge.EVENT_BUS.register(handler);
            REGISTERED_HANDLERS.put(type, Boolean.TRUE);
        }
    }

    public static void unregisterHandler(DataLogger.DataType type) {
        Object handler;
        if (REGISTERED_HANDLERS.get((Object)type) != null && (handler = HANDLER_INSTANCES.get((Object)type)) != null) {
            MinecraftForge.EVENT_BUS.unregister(handler);
            REGISTERED_HANDLERS.remove((Object)type);
        }
    }

    @Nullable
    private static Object createHandler(DataLogger.DataType type) {
        switch (type) {
            case CHUNK_LOAD: {
                return new EventHandlerChunkLoad();
            }
            case CHUNK_UNLOAD: {
                return new EventHandlerChunkUnload();
            }
            case ENTITY_JOIN_WORLD: {
                return new EventHandlerEntityJoinWorld();
            }
        }
        return null;
    }
}

