/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.datadump;

import fi.dy.masa.tellme.datadump.DataDump;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class VillagerProfessionDump {
    private static final Field field_careers = ObfuscationReflectionHelper.findField(VillagerRegistry.VillagerProfession.class, (String)"careers");

    public static List<String> getFormattedVillagerProfessionDump(DataDump.Format format) {
        DataDump villagerProfessionDump = new DataDump(2, format);
        for (Map.Entry entry : ForgeRegistries.VILLAGER_PROFESSIONS.getEntries()) {
            String regName = ((ResourceLocation)entry.getKey()).toString();
            String careers = VillagerProfessionDump.getCareersString((VillagerRegistry.VillagerProfession)entry.getValue());
            villagerProfessionDump.addData(regName, careers);
        }
        villagerProfessionDump.addTitle("Registry name", "Careers");
        villagerProfessionDump.setUseColumnSeparator(true);
        return villagerProfessionDump.getLines();
    }

    private static String getCareersString(VillagerRegistry.VillagerProfession profession) {
        List<VillagerRegistry.VillagerCareer> careers = VillagerProfessionDump.getCareers(profession);
        if (careers != null) {
            ArrayList<String> listCareerNames = new ArrayList<String>();
            for (VillagerRegistry.VillagerCareer career : careers) {
                listCareerNames.add(career.getName());
            }
            return String.join((CharSequence)", ", listCareerNames);
        }
        return "ERROR";
    }

    @Nullable
    public static List<VillagerRegistry.VillagerCareer> getCareers(VillagerRegistry.VillagerProfession profession) {
        try {
            List careers = (List)field_careers.get(profession);
            return careers;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

