/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.datadump;

import fi.dy.masa.tellme.TellMe;
import fi.dy.masa.tellme.datadump.DataDump;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class TileEntityDump
extends DataDump {
    private static final Field field_REGISTRY = ObfuscationReflectionHelper.findField(TileEntity.class, (String)"field_190562_f");

    private TileEntityDump(DataDump.Format format) {
        super(3, format);
    }

    public static List<String> getFormattedTileEntityDump(DataDump.Format format) {
        TileEntityDump tileEntityDump = new TileEntityDump(format);
        try {
            RegistryNamespaced<ResourceLocation, Class<? extends TileEntity>> registry = TileEntityDump.getTileEntityRegistry();
            Set keys = registry.func_148742_b();
            for (ResourceLocation key : keys) {
                Class clazz = (Class)registry.func_82594_a((Object)key);
                tileEntityDump.addData(clazz.getName(), key.toString(), ITickable.class.isAssignableFrom(clazz) ? "yes" : "-");
            }
            tileEntityDump.addTitle("Class", "Registry name", "Ticking?");
            tileEntityDump.setColumnAlignment(2, DataDump.Alignment.RIGHT);
            tileEntityDump.setUseColumnSeparator(true);
        }
        catch (Exception e) {
            TellMe.logger.warn("Failed to dump the TileEntity map");
        }
        return tileEntityDump.getLines();
    }

    @Nullable
    public static RegistryNamespaced<ResourceLocation, Class<? extends TileEntity>> getTileEntityRegistry() {
        try {
            RegistryNamespaced registry = (RegistryNamespaced)field_REGISTRY.get(null);
            return registry;
        }
        catch (IllegalAccessException e) {
            TellMe.logger.warn("Failed to get the TileEntity registry", (Throwable)e);
            return null;
        }
    }
}

