/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.datadump;

import fi.dy.masa.tellme.datadump.DataDump;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class DimensionDump {
    private static final Field field_worldProvider = ObfuscationReflectionHelper.findField(DimensionType.class, (String)"field_186077_g");

    public static List<String> getFormattedDimensionDump(DataDump.Format format) {
        Integer[] ids = DimensionManager.getStaticDimensionIDs();
        DataDump dimensionDump = new DataDump(6, format);
        dimensionDump.setSort(false);
        for (int i = 0; i < ids.length; ++i) {
            String worldProviderClass;
            DimensionType type = DimensionManager.getProviderType((int)ids[i]);
            if (type == null) continue;
            String dimId = ids[i].toString();
            String typeId = String.valueOf(type.func_186068_a());
            String name = type.func_186065_b();
            String shouldLoadSpawn = String.valueOf(type.shouldLoadSpawn());
            String currentlyLoaded = String.valueOf(DimensionManager.getWorld((int)ids[i]) != null);
            try {
                worldProviderClass = ((Class)field_worldProvider.get(type)).getName();
            }
            catch (Exception e) {
                worldProviderClass = "ERROR";
            }
            dimensionDump.addData(dimId, typeId, name, shouldLoadSpawn, currentlyLoaded, worldProviderClass);
        }
        dimensionDump.addTitle("ID", "DimensionType ID", "Name", "shouldLoadSpawn", "Currently loaded", "WorldProvider class");
        dimensionDump.setColumnProperties(0, DataDump.Alignment.RIGHT, true);
        dimensionDump.setColumnProperties(1, DataDump.Alignment.RIGHT, true);
        dimensionDump.setColumnAlignment(3, DataDump.Alignment.RIGHT);
        dimensionDump.setColumnAlignment(4, DataDump.Alignment.RIGHT);
        dimensionDump.setUseColumnSeparator(true);
        return dimensionDump.getLines();
    }
}

