/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.datadump;

import fi.dy.masa.tellme.TellMe;
import fi.dy.masa.tellme.datadump.DataDump;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;

public class ChunkDump {
    public static List<String> getFormattedChunkDump(DataDump.Format format, @Nullable Integer dimension) {
        Integer[] ids = dimension != null ? new Integer[]{dimension} : DimensionManager.getIDs();
        DataDump chunkDump = new DataDump(4, format);
        for (int i = 0; i < ids.length; ++i) {
            Integer id = ids[i];
            WorldServer world = DimensionManager.getWorld((int)id);
            if (world == null) continue;
            String dimId = ids[i].toString();
            Collection<Chunk> chunks = TellMe.proxy.getLoadedChunks((World)world);
            for (Chunk chunk : chunks) {
                int count = 0;
                for (int l = 0; l < chunk.func_177429_s().length; ++l) {
                    count += chunk.func_177429_s()[l].size();
                }
                String entityCount = String.valueOf(count);
                chunkDump.addData(dimId, String.format("%4d, %4d", chunk.field_76635_g, chunk.field_76647_h), String.format("%5d, %5d", chunk.field_76635_g << 4, chunk.field_76647_h << 4), entityCount);
            }
        }
        chunkDump.addTitle("Dim ID", "Chunk", "Block pos", "Entities");
        chunkDump.setColumnProperties(0, DataDump.Alignment.RIGHT, true);
        chunkDump.setColumnProperties(3, DataDump.Alignment.RIGHT, true);
        chunkDump.setUseColumnSeparator(true);
        return chunkDump.getLines();
    }
}

