/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.datadump;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.tellme.TellMe;
import fi.dy.masa.tellme.datadump.DataDump;
import fi.dy.masa.tellme.util.ChatUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class BiomeDump {
    public static List<String> getFormattedBiomeDump(DataDump.Format format, boolean outputColors) {
        boolean isClient = TellMe.proxy.isClient();
        int columns = 11;
        if (outputColors) {
            columns += isClient ? 3 : 1;
        }
        DataDump biomeDump = new DataDump(columns, format);
        for (Map.Entry entry : ForgeRegistries.BIOMES.getEntries()) {
            Biome biome = (Biome)entry.getValue();
            String id = String.valueOf(Biome.func_185362_a((Biome)biome));
            ResourceLocation rl = (ResourceLocation)entry.getKey();
            String regName = rl != null ? rl.toString() : "<null>";
            String name = TellMe.proxy.getBiomeName(biome);
            String biomeTypes = BiomeDump.getBiomeTypesForBiome(biome);
            String biomeDictionaryTypes = BiomeDump.getBiomeDictionaryTypesForBiome(biome);
            String validFor = BiomeDump.getValidForString(biome);
            String temp = String.format("%5.2f", Float.valueOf(biome.func_185353_n()));
            String tempCat = biome.func_150561_m().toString();
            String rain = String.format("%.2f", Float.valueOf(biome.func_76727_i()));
            String snow = String.valueOf(biome.func_76746_c());
            String oceanic = String.valueOf(BiomeManager.oceanBiomes.contains(biome));
            if (isClient) {
                if (outputColors) {
                    Pair<Integer, Integer> pair = TellMe.proxy.getBiomeGrassAndFoliageColors(biome);
                    String waterColor = String.format("0x%08X (%10d)", biome.getWaterColorMultiplier(), biome.getWaterColorMultiplier());
                    String grassColor = String.format("0x%08X (%10d)", pair.getLeft(), pair.getLeft());
                    String foliageColor = String.format("0x%08X (%10d)", pair.getRight(), pair.getRight());
                    biomeDump.addData(id, regName, name, temp, tempCat, rain, snow, oceanic, biomeTypes, biomeDictionaryTypes, validFor, waterColor, grassColor, foliageColor);
                    continue;
                }
                biomeDump.addData(id, regName, name, temp, tempCat, rain, snow, oceanic, biomeTypes, biomeDictionaryTypes, validFor);
                continue;
            }
            if (outputColors) {
                String waterColor = String.format("0x%08X (%10d)", biome.getWaterColorMultiplier(), biome.getWaterColorMultiplier());
                biomeDump.addData(id, regName, name, temp, tempCat, rain, snow, oceanic, biomeTypes, biomeDictionaryTypes, validFor, waterColor);
                continue;
            }
            biomeDump.addData(id, regName, name, temp, tempCat, rain, snow, oceanic, biomeTypes, biomeDictionaryTypes, validFor);
        }
        if (isClient && outputColors) {
            biomeDump.addTitle("ID", "Registry name", "Biome name", "temp.", "temp cat", "rain", "snow", "oceanic", "BiomeType", "BiomeDictionary.Type", "Valid for", "waterColorMultiplier", "grassColorMultiplier", "foliageColorMultiplier");
        } else if (outputColors) {
            biomeDump.addTitle("ID", "Registry name", "Biome name", "temp.", "temp cat", "rain", "snow", "oceanic", "BiomeType", "BiomeDictionary.Type", "Valid for", "waterColorMultiplier");
        } else {
            biomeDump.addTitle("ID", "Registry name", "Biome name", "temp.", "temp cat", "rain", "snow", "oceanic", "BiomeType", "BiomeDictionary.Type", "Valid for");
        }
        biomeDump.setColumnProperties(0, DataDump.Alignment.RIGHT, true);
        biomeDump.setColumnProperties(3, DataDump.Alignment.RIGHT, true);
        biomeDump.setColumnProperties(5, DataDump.Alignment.RIGHT, true);
        biomeDump.setColumnAlignment(6, DataDump.Alignment.RIGHT);
        biomeDump.setUseColumnSeparator(true);
        return biomeDump.getLines();
    }

    public static List<String> getFormattedBiomeDumpWithMobSpawns(DataDump.Format format) {
        DataDump biomeDump = new DataDump(6, format);
        for (Map.Entry entry : ForgeRegistries.BIOMES.getEntries()) {
            Biome biome = (Biome)entry.getValue();
            String id = String.valueOf(Biome.func_185362_a((Biome)biome));
            ResourceLocation rl = (ResourceLocation)entry.getKey();
            String regName = rl != null ? rl.toString() : "<null>";
            String name = TellMe.proxy.getBiomeName(biome);
            String biomeTypes = BiomeDump.getBiomeTypesForBiome(biome);
            String biomeDictionaryTypes = BiomeDump.getBiomeDictionaryTypesForBiome(biome);
            ArrayList spawns = new ArrayList();
            for (EnumCreatureType type : EnumCreatureType.values()) {
                ArrayList<String> tmpList = new ArrayList<String>();
                for (Biome.SpawnListEntry spawn : biome.func_76747_a(type)) {
                    ResourceLocation erl = EntityList.func_191306_a((Class)spawn.field_76300_b);
                    String entName = erl != null ? erl.toString() : spawn.field_76300_b.getName();
                    tmpList.add(String.format("{ %s [weight: %d, min: %d, max: %d] }", entName, spawn.field_76292_a, spawn.field_76301_c, spawn.field_76299_d));
                }
                Collections.sort(tmpList);
                spawns.addAll(tmpList);
            }
            biomeDump.addData(id, regName, name, biomeTypes, biomeDictionaryTypes, String.join((CharSequence)"; ", spawns));
        }
        biomeDump.addTitle("ID", "Registry name", "Biome name", "BiomeType", "BiomeDictionary.Type", "Spawns");
        biomeDump.setColumnProperties(0, DataDump.Alignment.RIGHT, true);
        biomeDump.setUseColumnSeparator(true);
        return biomeDump.getLines();
    }

    public static void printCurrentBiomeInfoToChat(EntityPlayer player) {
        World world = player.func_130014_f_();
        BlockPos pos = player.func_180425_c();
        Biome biome = world.func_180494_b(pos);
        String pre = TextFormatting.GREEN.toString();
        String preAqua = TextFormatting.AQUA.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.WHITE.toString();
        String regName = biome.getRegistryName().toString();
        String biomeTypes = BiomeDump.getBiomeTypesForBiome(biome);
        String biomeDictionaryTypes = BiomeDump.getBiomeDictionaryTypesForBiome(biome);
        String validFor = BiomeDump.getValidForString(biome);
        String enableSnow = biome.func_76746_c() ? pre + "true" : TextFormatting.RED.toString() + "false";
        String textPre = String.format("Name: %s%s%s - ID: %s%d%s - Registry name: %s", pre, TellMe.proxy.getBiomeName(biome), rst, pre, Biome.func_185362_a((Biome)biome), rst, pre);
        player.func_145747_a((ITextComponent)new TextComponentString("------------- Current biome info ------------"));
        player.func_145747_a(ChatUtils.getClipboardCopiableMessage(textPre, regName, rst));
        player.func_145747_a((ITextComponent)new TextComponentString(String.format("canRain: %s%s%s, rainfall: %s%f%s - enableSnow: %s%s", pre, biome.func_76738_d(), rst, pre, Float.valueOf(biome.func_76727_i()), rst, enableSnow, rst)));
        player.func_145747_a((ITextComponent)new TextComponentString(String.format("BiomeType: %s%s%s", preAqua, biomeTypes, rst)));
        player.func_145747_a((ITextComponent)new TextComponentString(String.format("BiomeDictionary.Type: %s%s%s", preAqua, biomeDictionaryTypes, rst)));
        if (!StringUtils.isBlank((CharSequence)validFor)) {
            player.func_145747_a((ITextComponent)new TextComponentString(String.format("Valid for: %s%s%s", preAqua, validFor, rst)));
        }
        player.func_145747_a((ITextComponent)new TextComponentString(String.format("waterColorMultiplier: %s0x%08X (%d)%s", pre, biome.getWaterColorMultiplier(), biome.getWaterColorMultiplier(), rst)));
        player.func_145747_a((ITextComponent)new TextComponentString(String.format("temperature: %s%f%s, temp. category: %s%s%s", pre, Float.valueOf(biome.func_180626_a(pos)), rst, pre, biome.func_150561_m(), rst)));
        TellMe.proxy.getCurrentBiomeInfoClientSide(player, biome);
    }

    public static List<String> getBiomeDumpIdToName(DataDump.Format format) {
        ArrayList<String> lines;
        block4: {
            ArrayList<IdToStringHolder> data;
            block3: {
                data = new ArrayList<IdToStringHolder>();
                lines = new ArrayList<String>();
                for (Biome biome : Biome.field_185377_q) {
                    data.add(new IdToStringHolder(Biome.func_185362_a((Biome)biome), TellMe.proxy.getBiomeName(biome)));
                }
                Collections.sort(data);
                if (format != DataDump.Format.ASCII) break block3;
                for (IdToStringHolder holder : data) {
                    lines.add(String.valueOf(holder.getId()) + " = " + holder.getString());
                }
                break block4;
            }
            if (format != DataDump.Format.CSV) break block4;
            for (IdToStringHolder holder : data) {
                lines.add(String.valueOf(holder.getId()) + ",\"" + holder.getString() + "\"");
            }
        }
        return lines;
    }

    private static String getBiomeTypesForBiome(Biome biome) {
        HashSet<String> typeNames = new HashSet<String>();
        block0: for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
            ImmutableList entries = BiomeManager.getBiomes((BiomeManager.BiomeType)type);
            for (BiomeManager.BiomeEntry entry : entries) {
                if (entry.biome != biome) continue;
                typeNames.add(type.toString().toUpperCase());
                continue block0;
            }
        }
        if (!typeNames.isEmpty()) {
            ArrayList typeList = new ArrayList(typeNames);
            Collections.sort(typeList);
            return String.join((CharSequence)", ", typeList);
        }
        return "";
    }

    private static String getBiomeDictionaryTypesForBiome(Biome biome) {
        ArrayList<String> typeStrings = new ArrayList<String>();
        Set types = BiomeDictionary.getTypes((Biome)biome);
        for (BiomeDictionary.Type type : types) {
            typeStrings.add(type.getName().toUpperCase());
        }
        if (!typeStrings.isEmpty()) {
            Collections.sort(typeStrings);
            return String.join((CharSequence)", ", typeStrings);
        }
        return "";
    }

    private static String getValidForString(Biome biome) {
        ArrayList<String> strings = new ArrayList<String>();
        if (BiomeProvider.allowedBiomes.contains(biome)) {
            strings.add("spawn");
        }
        if (biome.func_185355_j() > 0.0f && !BiomeManager.strongHoldBiomesBlackList.contains(biome) || BiomeManager.strongHoldBiomes.contains(biome)) {
            strings.add("stronghold");
        }
        if (MapGenVillage.field_75055_e.contains(biome)) {
            strings.add("village");
        }
        return String.join((CharSequence)", ", strings);
    }

    public static class IdToStringHolder
    implements Comparable<IdToStringHolder> {
        private final int id;
        private final String str;

        public IdToStringHolder(int id, String str) {
            this.id = id;
            this.str = str;
        }

        public int getId() {
            return this.id;
        }

        public String getString() {
            return this.str;
        }

        @Override
        public int compareTo(IdToStringHolder other) {
            if (this.id < other.id) {
                return -1;
            }
            if (this.id > other.id) {
                return 1;
            }
            return 0;
        }
    }
}

