/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.command;

import fi.dy.masa.tellme.command.CommandTellme;
import fi.dy.masa.tellme.command.SubCommand;
import fi.dy.masa.tellme.datadump.DataDump;
import fi.dy.masa.tellme.event.datalogging.DataLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.DimensionManager;

public class SubCommandTrack
extends SubCommand {
    private final List<String> dataTypes = new ArrayList<String>();

    public SubCommandTrack(CommandTellme baseCommand) {
        super(baseCommand);
        this.subSubCommands.add("add-filter");
        this.subSubCommands.add("add-log");
        this.subSubCommands.add("add-print");
        this.subSubCommands.add("clear-data");
        this.subSubCommands.add("enable");
        this.subSubCommands.add("enable-filters");
        this.subSubCommands.add("disable");
        this.subSubCommands.add("disable-filters");
        this.subSubCommands.add("dump");
        this.subSubCommands.add("print");
        this.subSubCommands.add("remove-filter");
        this.subSubCommands.add("remove-log");
        this.subSubCommands.add("remove-print");
        this.subSubCommands.add("show-loggers");
        this.dataTypes.add("all");
        this.dataTypes.add("chunk-load");
        this.dataTypes.add("chunk-unload");
        this.dataTypes.add("entity-join-world");
        this.addSubCommandHelp("_generic", "Can track various events, such as chunk loads/unloads, entities joining the world, etc.");
    }

    @Override
    public String getName() {
        return "track";
    }

    private void printUsageTrack(ICommandSender sender) {
        String pre = this.getSubCommandUsagePre();
        sender.func_145747_a((ITextComponent)new TextComponentString(pre + " <enable | disable> <all-dims | dimId> [all | type ... ]"));
        sender.func_145747_a((ITextComponent)new TextComponentString(pre + " <add-log | remove-log> <all-dims | dimId> [all | type ... ]"));
        sender.func_145747_a((ITextComponent)new TextComponentString(pre + " <add-print | remove-print> <all-dims | dimId> [all | type ... ]"));
        sender.func_145747_a((ITextComponent)new TextComponentString(pre + " <enable-filters | disable-filters> <all-dims | dimId> [all | type ... ]"));
        sender.func_145747_a((ITextComponent)new TextComponentString(pre + " <add-filter | remove-filter> <all-dims | dimId> <type> filters ..."));
        sender.func_145747_a((ITextComponent)new TextComponentString(pre + " show-loggers <all-dims | dimId>"));
        sender.func_145747_a((ITextComponent)new TextComponentString(pre + " clear-data <all-dims | dimId> [all | type ... ]"));
        sender.func_145747_a((ITextComponent)new TextComponentString(pre + " <dump | print> <all-dims | dimId> [all | type ... ]"));
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length < 1) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return CommandBase.func_175762_a((String[])args, (Collection)this.subSubCommands);
        }
        if (args.length == 2) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"all-dims"});
        }
        if (args.length >= 3) {
            return CommandBase.func_175762_a((String[])args, this.dataTypes);
        }
        return Collections.emptyList();
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int[] dims;
        if (!this.isValidCommand(args, sender)) {
            this.printUsageTrack(sender);
            return;
        }
        String cmd = args[0];
        if (args[1].equals("all-dims")) {
            Integer[] d = DimensionManager.getStaticDimensionIDs();
            dims = new int[d.length];
            for (int i = 0; i < dims.length; ++i) {
                dims[i] = d[i];
            }
        } else {
            dims = new int[]{CommandBase.func_175755_a((String)args[1])};
        }
        DataDump dumpLoggers = new DataDump(5, DataDump.Format.ASCII);
        for (int dimension : dims) {
            DataLogger.DataType[] types;
            if (cmd.equals("show-loggers")) {
                DataLogger.instance(dimension).printLoggers(dumpLoggers);
                continue;
            }
            if (args[2].equals("all")) {
                types = DataLogger.DataType.values();
            } else {
                types = new DataLogger.DataType[args.length - 2];
                int i = 2;
                int j = 0;
                while (i < args.length) {
                    types[j] = DataLogger.DataType.fromArgument(args[i]);
                    ++i;
                    ++j;
                }
            }
            for (DataLogger.DataType type : types) {
                File file;
                String msg;
                if (type == null) continue;
                if (cmd.equals("add-log") || cmd.equals("remove-log")) {
                    boolean enable = cmd.equals("add-log");
                    String string = msg = enable ? "Enabled" : "Disabled";
                    if (!DataLogger.instance(dimension).setLoggingEnabled(type, enable)) continue;
                    this.sendMessage(sender, msg + " logging mode for '%s' in dimension %s", type.getOutputName(), dimension);
                    continue;
                }
                if (cmd.equals("add-print") || cmd.equals("remove-print")) {
                    boolean enable = cmd.equals("add-print");
                    String string = msg = enable ? "Enabled" : "Disabled";
                    if (!DataLogger.instance(dimension).setPrintingEnabled(type, enable)) continue;
                    this.sendMessage(sender, msg + " immediate-print mode for '%s' in dimension %s", type.getOutputName(), dimension);
                    continue;
                }
                if (cmd.equals("enable") || cmd.equals("disable")) {
                    boolean enable = cmd.equals("enable");
                    String string = msg = enable ? "Enabled" : "Disabled";
                    if (!DataLogger.instance(dimension).setEnabled(type, enable)) continue;
                    this.sendMessage(sender, msg + " tracking of '%s' in dimension %s", type.getOutputName(), dimension);
                    continue;
                }
                if (args.length >= 4 && (cmd.equals("add-filter") || cmd.equals("remove-filter"))) {
                    boolean add = cmd.equals("add-filter");
                    msg = add ? "Added" : "Removed";
                    DataLogger.instance(dimension).modifyFilters(type, add, SubCommandTrack.dropFirstStrings(args, 3));
                    this.sendMessage(sender, msg + " filters for '%s' in dimension %s", type.getOutputName(), dimension);
                    continue;
                }
                if (cmd.equals("enable-filters") || cmd.equals("disable-filters")) {
                    boolean enable = cmd.equals("enable-filters");
                    String string = msg = enable ? "Enabled" : "Disabled";
                    if (!DataLogger.instance(dimension).setFilterEnabled(type, enable)) continue;
                    this.sendMessage(sender, msg + " filters for '%s' in dimension %s", type.getOutputName(), dimension);
                    continue;
                }
                if (cmd.equals("clear-data")) {
                    DataLogger.instance(dimension).clearData(type);
                    this.sendMessage(sender, "Cleared logged data for '%s' in dimension %s", type.getOutputName(), dimension);
                    continue;
                }
                if (!cmd.equals("dump") || (file = DataLogger.instance(dimension).dumpData(type, DataDump.Format.ASCII)) == null) continue;
                String str = String.format("Dumped logged data for '%s' in dimension %d to file %%s", type.getOutputName(), dimension);
                SubCommandTrack.sendClickableLinkMessage(sender, str, file);
            }
        }
        if (cmd.equals("show-loggers")) {
            dumpLoggers.addFooter("Currently enabled loggers/printers");
            dumpLoggers.addTitle("Dim", "Type", "Enabled", "Print", "Log");
            dumpLoggers.setColumnProperties(0, DataDump.Alignment.RIGHT, true);
            dumpLoggers.setColumnAlignment(2, DataDump.Alignment.RIGHT);
            dumpLoggers.setColumnAlignment(3, DataDump.Alignment.RIGHT);
            dumpLoggers.setColumnAlignment(4, DataDump.Alignment.RIGHT);
            dumpLoggers.setUseColumnSeparator(true);
            DataDump.printDataToLogger(dumpLoggers.getLines());
            this.sendMessage(sender, "Output printed to console", new Object[0]);
        }
    }

    private boolean isValidCommand(String[] args, ICommandSender sender) {
        if (args.length < 2 || args.length < 3 && !args[0].equals("show-loggers")) {
            this.sendMessage(sender, "Too few arguments", new Object[0]);
            return false;
        }
        if (!this.subSubCommands.contains(args[0])) {
            this.sendMessage(sender, "Invalid sub-command '%s'", args[1]);
            return false;
        }
        if (!args[1].equals("all-dims")) {
            try {
                Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                this.sendMessage(sender, "Invalid dimension id '%s'", args[1]);
                return false;
            }
        }
        if (args.length >= 3) {
            if (args[0].equals("add-filter") || args[0].equals("remove-filter")) {
                return args.length >= 4;
            }
            for (int i = 2; i < args.length; ++i) {
                if (this.dataTypes.contains(args[i])) continue;
                this.sendMessage(sender, "Invalid data type '%s'", args[i]);
                return false;
            }
        }
        return true;
    }
}

