/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.command;

import fi.dy.masa.tellme.TellMe;
import fi.dy.masa.tellme.command.CommandTellme;
import fi.dy.masa.tellme.command.SubCommand;
import fi.dy.masa.tellme.datadump.ChunkDump;
import fi.dy.masa.tellme.datadump.DataDump;
import fi.dy.masa.tellme.datadump.EntityCountDump;
import fi.dy.masa.tellme.util.WorldUtils;
import java.io.File;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class SubCommandLoaded
extends SubCommand {
    public SubCommandLoaded(CommandTellme baseCommand) {
        super(baseCommand);
        this.subSubCommands.add("chunks");
        this.subSubCommands.add("dimensions");
        this.subSubCommands.add("entities-all");
        this.subSubCommands.add("entities-in-area");
        this.subSubCommands.add("entities-in-chunk");
        this.subSubCommands.add("tileentities-all");
        this.subSubCommands.add("tileentities-in-area");
        this.subSubCommands.add("tileentities-in-chunk");
        this.addSubCommandUsage("chunks", "chunks <list | dump> [dimension]");
        this.addSubCommandUsage("dimensions", "dimensions");
        this.addSubCommandUsage("entities-all", "entities-all <all | by-chunk | by-type> <list | dump> [dimension]");
        this.addSubCommandUsage("entities-in-area", "entities-in-area <all | by-chunk | by-type> <list | dump> <x-min> <z-min> <x-max> <z-max> [dimension]");
        this.addSubCommandUsage("entities-in-chunk", "entities-in-chunk <all | by-chunk | by-type> <list | dump> <chunkX> <chunkZ> [dimension]");
        this.addSubCommandUsage("tileentities-all", "tileentities-all <all | by-chunk | by-type> <list | dump> [dimension]");
        this.addSubCommandUsage("tileentities-in-area", "tileentities-in-area <all | by-chunk | by-type> <list | dump> <x-min> <z-min> <x-max> <z-max> [dimension]");
        this.addSubCommandUsage("tileentities-in-chunk", "tileentities-in-chunk <all | by-chunk | by-type> <list | dump> <chunkX> <chunkZ> [dimension]");
    }

    @Override
    public String getName() {
        return "loaded";
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        String cmd = args[0];
        if (!cmd.equals("dimensions") && this.subSubCommands.contains(cmd)) {
            if (args.length == 3 && !cmd.equals("chunks") || args.length == 2 && cmd.equals("chunks")) {
                return CommandBase.func_71530_a((String[])args, (String[])new String[]{"dump", "list"});
            }
            if (args.length == 2) {
                return CommandBase.func_71530_a((String[])args, (String[])new String[]{"all", "by-chunk", "by-type"});
            }
        }
        return super.getTabCompletions(server, sender, args, targetPos);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        Entity senderEntity;
        EntityCountDump.EntityListType type;
        String pre = "/" + this.getBaseCommand().func_71517_b() + " " + this.getName() + " ";
        if (args.length < 1 || !this.subSubCommands.contains(args[0]) || args[0].equals("help")) {
            this.sendMessage(sender, "Usage:", new Object[0]);
            for (String cmd : this.subSubCommands) {
                if (cmd.equals("help")) continue;
                sender.func_145747_a((ITextComponent)new TextComponentString(pre + this.getSubCommandUsage(cmd)));
            }
            return;
        }
        String cmd = args[0];
        int outputTypeArgIndex = 2;
        if (cmd.equals("dimensions") && args.length == 1) {
            Integer[] dims;
            Integer[] integerArray = dims = DimensionManager.getIDs();
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int id = integerArray[i];
                WorldServer world = DimensionManager.getWorld((int)id);
                if (world == null) continue;
                TellMe.logger.info(String.format("DIM %4d: %-16s [%4d loaded chunks, %4d loaded entities, %d players]", id, world.field_73011_w.func_186058_p().func_186065_b(), WorldUtils.getLoadedChunkCount((World)world), world.field_72996_f.size(), world.field_73010_i.size()));
            }
            this.sendMessage(sender, "Command output printed to console", new Object[0]);
            return;
        }
        List<String> data = null;
        if (cmd.equals("chunks") && (args.length == 2 || args.length == 3)) {
            outputTypeArgIndex = 1;
            Integer dim = args.length == 3 ? Integer.valueOf(CommandBase.func_175755_a((String)args[2])) : null;
            data = ChunkDump.getFormattedChunkDump(DataDump.Format.ASCII, dim);
        } else if ((cmd.equals("entities-all") || cmd.equals("tileentities-all")) && (args.length == 3 || args.length == 4)) {
            type = this.getListType(cmd, args[1]);
            World world = this.checkAndGetWorld(sender, args, 3);
            data = EntityCountDump.getFormattedEntityCountDumpAll(world, type);
        } else if ((cmd.equals("entities-in-area") || cmd.equals("tileentities-in-area")) && (args.length == 7 || args.length == 8)) {
            ChunkPos pos2;
            ChunkPos pos1;
            type = this.getListType(cmd, args[2]);
            senderEntity = sender.func_174793_f();
            if (senderEntity != null) {
                Vec3d senderPos = senderEntity.func_174791_d();
                pos1 = new ChunkPos((int)CommandBase.func_175770_a((double)senderPos.field_72450_a, (String)args[3], (boolean)false).func_179628_a() >> 4, (int)CommandBase.func_175770_a((double)senderPos.field_72449_c, (String)args[4], (boolean)false).func_179628_a() >> 4);
                pos2 = new ChunkPos((int)CommandBase.func_175770_a((double)senderPos.field_72450_a, (String)args[5], (boolean)false).func_179628_a() >> 4, (int)CommandBase.func_175770_a((double)senderPos.field_72449_c, (String)args[6], (boolean)false).func_179628_a() >> 4);
            } else {
                pos1 = new ChunkPos(CommandBase.func_175755_a((String)args[3]) >> 4, CommandBase.func_175755_a((String)args[4]) >> 4);
                pos2 = new ChunkPos(CommandBase.func_175755_a((String)args[5]) >> 4, CommandBase.func_175755_a((String)args[6]) >> 4);
            }
            World world = this.checkAndGetWorld(sender, args, 7);
            data = EntityCountDump.getFormattedEntityCountDumpArea(world, type, pos1, pos2);
        } else if ((cmd.equals("entities-in-chunk") || cmd.equals("tileentities-in-chunk")) && (args.length == 5 || args.length == 6)) {
            ChunkPos pos;
            type = this.getListType(cmd, args[1]);
            senderEntity = sender.func_174793_f();
            if (senderEntity != null) {
                Vec3d senderPos = senderEntity.func_174791_d();
                pos = new ChunkPos((int)CommandBase.func_175770_a((double)senderPos.field_72450_a, (String)args[3], (boolean)false).func_179628_a(), (int)CommandBase.func_175770_a((double)senderPos.field_72449_c, (String)args[4], (boolean)false).func_179628_a());
            } else {
                pos = new ChunkPos(CommandBase.func_175755_a((String)args[3]), CommandBase.func_175755_a((String)args[4]));
            }
            World world = this.checkAndGetWorld(sender, args, 5);
            data = EntityCountDump.getFormattedEntityCountDumpArea(world, type, pos, pos);
        }
        if (data != null) {
            String outputType = args[outputTypeArgIndex];
            if (outputType.equals("list")) {
                DataDump.printDataToLogger(data);
                this.sendMessage(sender, "Command output printed to console", new Object[0]);
                return;
            } else {
                if (!outputType.equals("dump")) throw new WrongUsageException("Unrecognized parameter: '" + outputType + "'", new Object[0]);
                File file = DataDump.dumpDataToFile("loaded_" + cmd, data);
                SubCommandLoaded.sendClickableLinkMessage(sender, "Output written to file %s", file);
            }
            return;
        } else {
            this.sendMessage(sender, "Usage:", new Object[0]);
            sender.func_145747_a((ITextComponent)new TextComponentString(pre + this.getSubCommandUsage(cmd)));
        }
    }

    private World checkAndGetWorld(ICommandSender sender, String[] args, int index) throws CommandException {
        World world;
        if (args.length >= index + 1) {
            int dimension = CommandBase.func_175755_a((String)args[index]);
            world = DimensionManager.getWorld((int)dimension);
        } else {
            world = sender.func_130014_f_();
        }
        if (world == null) {
            throw new WrongUsageException("The requested world is not currently loaded", new Object[0]);
        }
        return world;
    }

    private EntityCountDump.EntityListType getListType(String cmd, String arg) {
        if (cmd.contains("tileentities")) {
            if (arg.equals("by-chunk")) {
                return EntityCountDump.EntityListType.TILE_ENTITIES_BY_CHUNK;
            }
            if (arg.equals("by-type")) {
                return EntityCountDump.EntityListType.TILE_ENTITIES_BY_TYPE;
            }
            return EntityCountDump.EntityListType.ALL_TILE_ENTITIES;
        }
        if (arg.equals("by-chunk")) {
            return EntityCountDump.EntityListType.ENTITIES_BY_CHUNK;
        }
        if (arg.equals("by-type")) {
            return EntityCountDump.EntityListType.ENTITIES_BY_TYPE;
        }
        return EntityCountDump.EntityListType.ALL_ENTITIES;
    }
}

