/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.command;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import fi.dy.masa.tellme.TellMe;
import fi.dy.masa.tellme.command.CommandTellme;
import fi.dy.masa.tellme.command.SubCommand;
import fi.dy.masa.tellme.datadump.DataDump;
import fi.dy.masa.tellme.util.WorldUtils;
import fi.dy.masa.tellme.util.chunkprocessor.BlockStats;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class SubCommandBlockStats
extends SubCommand {
    private final Map<UUID, BlockStats> blockStats = Maps.newHashMap();
    private final BlockStats blockStatsConsole = new BlockStats();

    public SubCommandBlockStats(CommandTellme baseCommand) {
        super(baseCommand);
        this.subSubCommands.add("count");
        this.subSubCommands.add("count-append");
        this.subSubCommands.add("dump");
        this.subSubCommands.add("dump-csv");
        this.subSubCommands.add("query");
        this.addSubCommandHelp("_generic", "Calculates the number of each block type in a given area");
        this.addSubCommandHelp("count", "Counts all the blocks in the given area");
        this.addSubCommandHelp("dump", "Dumps the stats from a previous 'count' command into a file in config/tellme/");
        this.addSubCommandHelp("dump-csv", "Dumps the stats from a previous 'count' command into a CSV file in config/tellme/");
        this.addSubCommandHelp("query", "Prints the stats from a previous 'count' command into the console");
    }

    @Override
    public String getName() {
        return "blockstats";
    }

    private void printUsageCount(ICommandSender sender) {
        String pre = this.getSubCommandUsagePre();
        sender.func_145747_a((ITextComponent)new TextComponentString(pre + " count all-loaded-chunks [dimension]"));
        sender.func_145747_a((ITextComponent)new TextComponentString(pre + " count chunk-radius <radius> [dimension] [x y z (of the center)]"));
        sender.func_145747_a((ITextComponent)new TextComponentString(pre + " count range <x-distance> <y-distance> <z-distance> [dimension] [x y z (of the center)]"));
        sender.func_145747_a((ITextComponent)new TextComponentString(pre + " count box <x1> <y1> <z1> <x2> <y2> <z2> [dimension]"));
    }

    private void printUsageDump(ICommandSender sender) {
        String pre = this.getSubCommandUsagePre();
        sender.func_145747_a((ITextComponent)new TextComponentString(pre + " dump[-csv] [sort-by-count] [modid:blockname[:meta] modid:blockname[:meta] ...]"));
    }

    private void printUsageQuery(ICommandSender sender) {
        String pre = this.getSubCommandUsagePre();
        sender.func_145747_a((ITextComponent)new TextComponentString(pre + " query [sort-by-count] [modid:blockname[:meta] modid:blockname[:meta] ...]"));
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"count", "count-append", "dump", "dump-csv", "query"});
        }
        if (args.length >= 2) {
            if (args.length == 2 && args[0].equals("count")) {
                return CommandBase.func_71530_a((String[])args, (String[])new String[]{"all-loaded-chunks", "box", "chunk-radius", "range"});
            }
            if (args[0].equals("dump") || args[0].equals("dump-csv") || args[0].equals("query")) {
                if (args.length == 2) {
                    if (CommandBase.func_71523_a((String)args[1], (String)"sort-by-count")) {
                        return ImmutableList.of((Object)"sort-by-count");
                    }
                    return CommandBase.func_175762_a((String[])args, (Collection)ForgeRegistries.BLOCKS.getKeys());
                }
                return CommandBase.func_175762_a((String[])args, (Collection)ForgeRegistries.BLOCKS.getKeys());
            }
            if (args.length >= 3 && args.length <= 8 && args[0].equals("count") && args[1].equals("box")) {
                int index = args.length >= 3 && args.length <= 5 ? 2 : 5;
                return CommandBase.func_175771_a((String[])args, (int)index, (BlockPos)targetPos);
            }
        }
        return Collections.emptyList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        BlockStats blockStats;
        if (args.length < 1) {
            this.sendMessage(sender, "Usage:", new Object[0]);
            this.printUsageCount(sender);
            this.printUsageDump(sender);
            this.printUsageQuery(sender);
            return;
        }
        super.execute(server, sender, args);
        String cmd = args[0];
        args = SubCommandBlockStats.dropFirstStrings(args, 1);
        BlockStats blockStats2 = blockStats = sender instanceof EntityPlayer ? this.getBlockStatsForPlayer((EntityPlayer)sender) : this.blockStatsConsole;
        if ((cmd.equals("count") || cmd.equals("count-append")) && args.length >= 1) {
            String type = args[0];
            args = SubCommandBlockStats.dropFirstStrings(args, 1);
            blockStats.setAppend(cmd.equals("count-append"));
            World world = this.getWorld(type, args, sender, server);
            BlockPos pos = sender instanceof EntityPlayer ? sender.func_180425_c() : WorldUtils.getSpawnPoint(world);
            String pre = this.getSubCommandUsagePre();
            if (type.equals("range") && (args.length == 3 || args.length == 4 || args.length == 7)) {
                try {
                    if (args.length == 7) {
                        int x = CommandBase.func_175755_a((String)args[4]);
                        int y = CommandBase.func_175755_a((String)args[5]);
                        int z = CommandBase.func_175755_a((String)args[6]);
                        pos = new BlockPos(x, y, z);
                    }
                    int rx = Math.abs(CommandBase.func_175755_a((String)args[0]));
                    int ry = Math.abs(CommandBase.func_175755_a((String)args[1]));
                    int rz = Math.abs(CommandBase.func_175755_a((String)args[2]));
                    this.sendMessage(sender, "Counting blocks...", new Object[0]);
                    blockStats.processChunks(world, pos, rx, ry, rz);
                    this.sendMessage(sender, "Done", new Object[0]);
                    return;
                }
                catch (NumberInvalidException e) {
                    throw new WrongUsageException(pre + " count range <x-distance> <y-distance> <z-distance> [dimension] [x y z (of the center)]", new Object[0]);
                }
            }
            if (type.equals("box") && (args.length == 6 || args.length == 7)) {
                try {
                    BlockPos pos1 = SubCommandBlockStats.parseBlockPos(pos, args, 0, false);
                    BlockPos pos2 = SubCommandBlockStats.parseBlockPos(pos, args, 3, false);
                    this.sendMessage(sender, "Counting blocks...", new Object[0]);
                    blockStats.processChunks(world, pos1, pos2);
                    this.sendMessage(sender, "Done", new Object[0]);
                    return;
                }
                catch (NumberInvalidException e) {
                    throw new WrongUsageException("Usage: " + pre + " count box <x1> <y1> <z1> <x2> <y2> <z2> [dimension]", new Object[0]);
                }
            }
            if (type.equals("all-loaded-chunks") && (args.length == 0 || args.length == 1)) {
                this.sendMessage(sender, "Counting blocks...", new Object[0]);
                blockStats.processChunks(TellMe.proxy.getLoadedChunks(world));
                this.sendMessage(sender, "Done", new Object[0]);
                return;
            }
            if (type.equals("chunk-radius") && (args.length == 1 || args.length == 2 || args.length == 5)) {
                if (args.length == 5) {
                    int x = CommandBase.func_175755_a((String)args[2]);
                    int y = CommandBase.func_175755_a((String)args[3]);
                    int z = CommandBase.func_175755_a((String)args[4]);
                    pos = new BlockPos(x, y, z);
                }
                int radius = 0;
                try {
                    radius = Integer.parseInt(args[0]);
                }
                catch (NumberFormatException e) {
                    throw new WrongUsageException(pre + " count chunk-radius <radius> [dimension] [x y z (of the center)]", new Object[0]);
                }
                int chunkCount = (radius * 2 + 1) * (radius * 2 + 1);
                this.sendMessage(sender, "Loading all the " + chunkCount + " chunks in the given radius of " + radius + " chunks ...", new Object[0]);
                List<Chunk> chunks = WorldUtils.loadAndGetChunks(world, pos, radius);
                this.sendMessage(sender, "Counting blocks in the selected " + chunks.size() + " chunks...", new Object[0]);
                blockStats.processChunks(chunks);
                this.sendMessage(sender, "Done", new Object[0]);
                return;
            }
            this.printUsageCount(sender);
            throw new CommandException("Invalid (number of?) arguments!", new Object[0]);
        }
        if (cmd.equals("query") || cmd.equals("dump") || cmd.equals("dump-csv")) {
            boolean sortByCount;
            DataDump.Format format = cmd.equals("dump-csv") ? DataDump.Format.CSV : DataDump.Format.ASCII;
            boolean bl = sortByCount = args.length >= 1 && args[0].equals("sort-by-count");
            if (sortByCount) {
                args = SubCommandBlockStats.dropFirstStrings(args, 1);
            }
            List<String> lines = args.length >= 1 ? blockStats.query(format, Arrays.asList(args), sortByCount) : blockStats.queryAll(format, sortByCount);
            if (cmd.equals("query")) {
                DataDump.printDataToLogger(lines);
                this.sendMessage(sender, "Command output printed to console", new Object[0]);
                return;
            } else {
                File file = DataDump.dumpDataToFile("block_stats", lines, format);
                if (file == null) return;
                SubCommandBlockStats.sendClickableLinkMessage(sender, "Output written to file %s", file);
            }
            return;
        } else {
            this.sendMessage(sender, "Usage:", new Object[0]);
            this.printUsageCount(sender);
            this.printUsageDump(sender);
            this.printUsageQuery(sender);
        }
    }

    private World getWorld(String countSubCommand, String[] args, ICommandSender sender, MinecraftServer server) throws CommandException {
        int index = -1;
        World world = sender.func_130014_f_();
        switch (countSubCommand) {
            case "all-loaded-chunks": {
                index = 0;
                break;
            }
            case "chunk-radius": {
                index = 1;
                break;
            }
            case "range": {
                index = 3;
                break;
            }
            case "box": {
                index = 6;
            }
        }
        if (index >= 0 && args.length > index) {
            String dimStr = args[index];
            try {
                int dimension = Integer.parseInt(dimStr);
                world = server.func_71218_a(dimension);
            }
            catch (NumberFormatException e) {
                throw new NumberInvalidException("Invalid dimension '%s'", new Object[]{dimStr});
            }
            if (world == null) {
                throw new NumberInvalidException("Could not load dimension '%s'", new Object[]{dimStr});
            }
        }
        return world;
    }

    private BlockStats getBlockStatsForPlayer(EntityPlayer player) {
        BlockStats stats = this.blockStats.get(player.func_110124_au());
        if (stats == null) {
            stats = new BlockStats();
            this.blockStats.put(player.func_110124_au(), stats);
        }
        return stats;
    }
}

