/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.command;

import com.google.common.collect.Maps;
import fi.dy.masa.tellme.command.CommandTellme;
import fi.dy.masa.tellme.command.SubCommand;
import fi.dy.masa.tellme.datadump.DataDump;
import fi.dy.masa.tellme.util.WorldUtils;
import fi.dy.masa.tellme.util.chunkprocessor.BiomeStats;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class SubCommandBiomeStats
extends SubCommand {
    private final Map<UUID, BiomeStats> biomeStats = Maps.newHashMap();
    private final BiomeStats biomeStatsConsole = new BiomeStats();

    public SubCommandBiomeStats(CommandTellme baseCommand) {
        super(baseCommand);
        this.subSubCommands.add("count");
        this.subSubCommands.add("count-append");
        this.subSubCommands.add("dump");
        this.subSubCommands.add("dump-csv");
        this.subSubCommands.add("query");
        this.addSubCommandHelp("_generic", "Calculates the number of x/z columns with each biome in a given area");
        this.addSubCommandHelp("count", "Counts all the biomes in the given area");
        this.addSubCommandHelp("dump", "Dumps the stats from a previous 'count' command into a file in config/tellme/");
        this.addSubCommandHelp("dump-csv", "Dumps the stats from a previous 'count' command into a CSV file in config/tellme/");
        this.addSubCommandHelp("query", "Prints the stats from a previous 'count' command into the console");
    }

    @Override
    public String getName() {
        return "biomestats";
    }

    private void printUsageCount(ICommandSender sender) {
        String pre = this.getSubCommandUsagePre();
        sender.func_145747_a((ITextComponent)new TextComponentString(pre + " count[-append] area <x1> <z1> <x2> <z2> [dimension]"));
        sender.func_145747_a((ITextComponent)new TextComponentString(pre + " count[-append] chunk-radius <radius> [x z (of the center)] [dimension]"));
        sender.func_145747_a((ITextComponent)new TextComponentString(pre + " count[-append] range <x-distance> <z-distance> [x z (of the center)] [dimension]"));
        sender.func_145747_a((ITextComponent)new TextComponentString(pre + " count[-append] sampled <sampleInterval> <sampleRadius> [centerX centerZ] [dimension]"));
    }

    private void printUsageQuery(ICommandSender sender) {
        String pre = this.getSubCommandUsagePre();
        sender.func_145747_a((ITextComponent)new TextComponentString(pre + " <dump | query> [modid:biome modid:biome ...]"));
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandBase.func_175762_a((String[])args, (Collection)this.subSubCommands);
        }
        if (args.length == 2) {
            if (args[0].equals("dump") || args[0].equals("dump-csv") || args[0].equals("query")) {
                return CommandBase.func_175762_a((String[])args, (Collection)ForgeRegistries.BIOMES.getKeys());
            }
            if (args[0].equals("count")) {
                return CommandBase.func_71530_a((String[])args, (String[])new String[]{"area", "chunk-radius", "range", "sampled"});
            }
        } else if (args.length >= 3 && args[0].equals("count")) {
            if (args.length <= 6 && args[1].equals("area")) {
                int index = args.length <= 4 ? 2 : 4;
                return CommandBase.func_181043_b((String[])args, (int)index, (BlockPos)targetPos);
            }
            if (args.length >= 4 && args.length <= 5 && args[1].equals("chunk-radius")) {
                return CommandBase.func_181043_b((String[])args, (int)3, (BlockPos)targetPos);
            }
            if (args.length >= 5 && args.length <= 6 && args[1].equals("range")) {
                return CommandBase.func_181043_b((String[])args, (int)4, (BlockPos)targetPos);
            }
            if (args.length >= 5 && args.length <= 6 && args[1].equals("sampled")) {
                return CommandBase.func_181043_b((String[])args, (int)4, (BlockPos)targetPos);
            }
        }
        return Collections.emptyList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        BiomeStats biomeStats;
        if (args.length < 1) {
            this.sendMessage(sender, "Usage:", new Object[0]);
            this.printUsageCount(sender);
            this.printUsageQuery(sender);
            return;
        }
        super.execute(server, sender, args);
        String cmd = args[0];
        BiomeStats biomeStats2 = biomeStats = sender instanceof EntityPlayer ? this.getBiomeStatsForPlayer((EntityPlayer)sender) : this.biomeStatsConsole;
        if ((cmd.equals("count") || cmd.equals("count-append")) && args.length >= 2) {
            String type = args[1];
            args = SubCommandBiomeStats.dropFirstStrings(args, 2);
            biomeStats.setAppend(cmd.equals("count-append"));
            World world = this.getWorld(type, args, sender, server);
            BlockPos pos = sender instanceof EntityPlayer ? sender.func_180425_c() : WorldUtils.getSpawnPoint(world);
            String pre = this.getSubCommandUsagePre();
            BiomeProvider biomeProvider = world.func_72959_q();
            if (type.equals("range") && args.length >= 2 && args.length <= 5) {
                try {
                    if (args.length >= 4) {
                        pos = SubCommandBiomeStats.parseBlockPosXZ(pos, args, 2, false);
                    }
                    int rx = Math.abs(CommandBase.func_175755_a((String)args[0]));
                    int rz = Math.abs(CommandBase.func_175755_a((String)args[1]));
                    this.sendMessage(sender, "Counting biomes...", new Object[0]);
                    biomeStats.getFullBiomeDistribution(biomeProvider, pos.func_177982_a(-rx, 0, -rz), pos.func_177982_a(rx, 0, rz));
                    this.sendMessage(sender, "Done", new Object[0]);
                    return;
                }
                catch (NumberInvalidException e) {
                    throw new WrongUsageException(pre + " count range <x-distance> <z-distance> [x z (of the center)] [dimension]", new Object[0]);
                }
            }
            if (type.equals("area") && (args.length == 4 || args.length == 5)) {
                try {
                    double x1 = CommandBase.func_175769_b((double)pos.func_177958_n(), (String)args[0], (int)-30000000, (int)30000000, (boolean)false);
                    double z1 = CommandBase.func_175769_b((double)pos.func_177952_p(), (String)args[1], (int)-30000000, (int)30000000, (boolean)false);
                    double x2 = CommandBase.func_175769_b((double)pos.func_177958_n(), (String)args[2], (int)-30000000, (int)30000000, (boolean)false);
                    double z2 = CommandBase.func_175769_b((double)pos.func_177952_p(), (String)args[3], (int)-30000000, (int)30000000, (boolean)false);
                    BlockPos pos1 = new BlockPos(Math.min(x1, x2), 0.0, Math.min(z1, z2));
                    BlockPos pos2 = new BlockPos(Math.max(x1, x2), 0.0, Math.max(z1, z2));
                    this.sendMessage(sender, "Counting biomes...", new Object[0]);
                    biomeStats.getFullBiomeDistribution(biomeProvider, pos1, pos2);
                    this.sendMessage(sender, "Done", new Object[0]);
                    return;
                }
                catch (NumberInvalidException e) {
                    throw new WrongUsageException("Usage: " + pre + " count area <x1> <z1> <x2> <z2> [dimension]", new Object[0]);
                }
            }
            if (type.equals("chunk-radius") && args.length >= 1 && args.length <= 4) {
                if (args.length == 4) {
                    pos = SubCommandBiomeStats.parseBlockPosXZ(pos, args, 1, false);
                }
                int radius = 0;
                try {
                    radius = Integer.parseInt(args[0]);
                }
                catch (NumberFormatException e) {
                    throw new WrongUsageException(pre + " count chunk-radius <radius> [x y z (of the center)] [dimension]", new Object[0]);
                }
                int chunkCount = (radius * 2 + 1) * (radius * 2 + 1);
                this.sendMessage(sender, "Counting biomes in the selected " + chunkCount + " chunks...", new Object[0]);
                biomeStats.getFullBiomeDistribution(biomeProvider, pos.func_177982_a(-radius * 16, 0, -radius * 16), pos.func_177982_a(radius * 16, 0, radius * 16));
                this.sendMessage(sender, "Done", new Object[0]);
                return;
            }
            if (type.equals("sampled") && args.length >= 2 && args.length <= 5) {
                try {
                    if (args.length >= 4) {
                        pos = SubCommandBiomeStats.parseBlockPosXZ(pos, args, 2, false);
                    }
                    int interval = CommandBase.func_175755_a((String)args[0]);
                    int radius = CommandBase.func_175755_a((String)args[1]);
                    if (interval <= 0) {
                        new NumberInvalidException("Interval must be a positive integer number", new Object[0]);
                    }
                    if (radius < 0) {
                        new NumberInvalidException("Radius must be a positive integer number or 0", new Object[0]);
                    }
                    this.sendMessage(sender, "Counting biomes...", new Object[0]);
                    biomeStats.getSampledBiomeDistribution(biomeProvider, pos.func_177958_n(), pos.func_177952_p(), interval, radius);
                    this.sendMessage(sender, "Done", new Object[0]);
                    return;
                }
                catch (NumberInvalidException e) {
                    throw new WrongUsageException(pre + " count sampled <sampleInterval> <sampleRadius> [centerX centerZ] [dimension]", new Object[0]);
                }
            }
            this.printUsageCount(sender);
            throw new CommandException("Invalid (number of?) arguments!", new Object[0]);
        }
        if (!(cmd.equals("query") || cmd.equals("dump") || cmd.equals("dump-csv"))) {
            this.sendMessage(sender, "Usage:", new Object[0]);
            this.printUsageCount(sender);
            this.printUsageQuery(sender);
            return;
        }
        DataDump.Format format = cmd.equals("dump-csv") ? DataDump.Format.CSV : DataDump.Format.ASCII;
        List<String> lines = args.length > 1 ? biomeStats.query(format, Arrays.asList(SubCommandBiomeStats.dropFirstStrings(args, 1))) : biomeStats.queryAll(format);
        if (cmd.equals("query")) {
            DataDump.printDataToLogger(lines);
            this.sendMessage(sender, "Command output printed to console", new Object[0]);
            return;
        }
        File file = DataDump.dumpDataToFile("biome_stats", lines, format);
        if (file == null) return;
        SubCommandBiomeStats.sendClickableLinkMessage(sender, "Output written to file %s", file);
    }

    private World getWorld(String countSubCommand, String[] args, ICommandSender sender, MinecraftServer server) throws CommandException {
        int index = -1;
        World world = sender.func_130014_f_();
        switch (countSubCommand) {
            case "area": {
                index = 4;
                break;
            }
            case "chunk-radius": {
                if (args.length == 4) {
                    index = 3;
                    break;
                }
                if (args.length != 2) break;
                index = 1;
                break;
            }
            case "range": 
            case "sampled": {
                if (args.length == 5) {
                    index = 4;
                    break;
                }
                if (args.length != 3) break;
                index = 2;
            }
        }
        if (index >= 0 && args.length > index) {
            String dimStr = args[index];
            try {
                int dimension = Integer.parseInt(dimStr);
                world = server.func_71218_a(dimension);
            }
            catch (NumberFormatException e) {
                throw new NumberInvalidException("Invalid dimension '%s'", new Object[]{dimStr});
            }
            if (world == null) {
                throw new NumberInvalidException("Could not load dimension '%s'", new Object[]{dimStr});
            }
        }
        return world;
    }

    private BiomeStats getBiomeStatsForPlayer(EntityPlayer player) {
        BiomeStats stats = this.biomeStats.get(player.func_110124_au());
        if (stats == null) {
            stats = new BiomeStats();
            this.biomeStats.put(player.func_110124_au(), stats);
        }
        return stats;
    }
}

