/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme;

import fi.dy.masa.tellme.command.CommandTellme;
import fi.dy.masa.tellme.config.Configs;
import fi.dy.masa.tellme.event.InteractEventHandler;
import fi.dy.masa.tellme.network.PacketHandler;
import fi.dy.masa.tellme.proxy.CommonProxy;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="tellme", name="Tell Me", version="0.7.0-dev.20200919.184303", certificateFingerprint="2b03e1423915a189b8094816baa18f239d576dff", guiFactory="fi.dy.masa.tellme.config.TellMeGuiFactory", acceptableRemoteVersions="*", acceptedMinecraftVersions="1.12")
public class TellMe {
    @Mod.Instance(value="tellme")
    public static TellMe instance;
    @SidedProxy(clientSide="fi.dy.masa.tellme.proxy.ClientProxy", serverSide="fi.dy.masa.tellme.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static final Logger logger;
    public static String configDirPath;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        configDirPath = new File(event.getModConfigurationDirectory(), "tellme").getAbsolutePath();
        Configs.loadConfigsFromFile(event.getSuggestedConfigurationFile());
        MinecraftForge.EVENT_BUS.register((Object)new InteractEventHandler());
        proxy.registerClientCommand();
        proxy.registerEventHandlers();
        PacketHandler.init();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandTellme());
    }

    @Mod.EventHandler
    public void onFingerPrintViolation(FMLFingerprintViolationEvent event) {
        if (!event.isDirectory()) {
            logger.warn("*********************************************************************************************");
            logger.warn("*****                                    WARNING                                        *****");
            logger.warn("*****                                                                                   *****");
            logger.warn("*****   The signature of the mod file '{}' does not match the expected fingerprint!     *****", (Object)event.getSource().getName());
            logger.warn("*****   This might mean that the mod file has been tampered with!                       *****");
            logger.warn("*****   If you did not download the mod {} directly from Curse/CurseForge,       *****", (Object)"Tell Me");
            logger.warn("*****   or using one of the well known launchers, and you did not                       *****");
            logger.warn("*****   modify the mod file at all yourself, then it's possible,                        *****");
            logger.warn("*****   that it may contain malware or other unwanted things!                           *****");
            logger.warn("*********************************************************************************************");
        }
    }

    static {
        logger = LogManager.getLogger((String)"tellme");
    }
}

