/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common;

import git.jbredwards.fluidlogged_api.api.event.FluidloggableEvent;
import git.jbredwards.fluidlogged_api.api.event.FluidloggedEvent;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfigHandler;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.ItemHandlerHelper;

@Mod.EventBusSubscriber(modid="fluidlogged_api")
public final class EventHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    static void forceForgeCascadingFix(@Nonnull ConfigChangedEvent.PostConfigChangedEvent event) {
        if (event.getModID().equals("forge")) {
            ForgeModContainer.fixVanillaCascading = true;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    static void handleConfigOverrides(@Nonnull FluidloggableEvent event) {
        Event.Result result = FluidloggedAPIConfigHandler.isStateFluidloggable(event.state, event.fluid);
        if (result != Event.Result.DEFAULT) {
            event.setCanceled(true);
            event.setResult(result);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    static void updateStaticLiquids(@Nonnull FluidloggedEvent event) {
        if (!event.world.field_72995_K) {
            if (!event.fluidState.isEmpty()) {
                Block block = event.fluidState.getBlock();
                event.world.func_175684_a(event.pos, block, block.func_149738_a(event.world));
            } else if (event.here.func_177230_c() instanceof BlockLiquid) {
                BlockDynamicLiquid block = BlockLiquid.func_176361_a((Material)event.here.func_185904_a());
                event.world.func_180501_a(event.pos, block.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, event.here.func_177229_b((IProperty)BlockLiquid.field_176367_b)), 2);
                event.world.func_175684_a(event.pos, (Block)block, block.func_149738_a(event.world));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    static void bucketFluidlogging(@Nonnull FillBucketEvent event) {
        if (event.getResult() != Event.Result.DEFAULT) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        Vec3d playerVec = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        RayTraceResult trace = event.getWorld().func_72933_a(playerVec, playerVec.func_178787_e(player.func_70040_Z().func_186678_a(player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e())));
        if (trace == null) {
            return;
        }
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)event.getEmptyBucket(), (int)1));
        if (handler == null) {
            return;
        }
        FluidStack contained = handler.drain(1000, false);
        if (contained != null && !contained.getFluid().canBePlacedInWorld()) {
            return;
        }
        BlockPos pos = trace.func_178782_a();
        World world = event.getWorld();
        if (contained == null) {
            if (EventHandler.tryBucketFill(world, pos, player, handler) || EventHandler.tryBucketFill(world, pos.func_177972_a(trace.field_178784_b), player, handler)) {
                event.setFilledBucket(handler.getContainer());
                event.setResult(Event.Result.ALLOW);
            }
        } else if (!player.func_70093_af() && FluidloggedUtils.isFluidloggableFluid(contained.getFluid().getBlock()) && (EventHandler.tryBucketDrain(world, pos, player, handler, contained) || EventHandler.tryBucketDrain(world, pos.func_177972_a(trace.field_178784_b), player, handler, contained))) {
            event.setFilledBucket(handler.getContainer());
            event.setResult(Event.Result.ALLOW);
        }
    }

    static boolean tryBucketFill(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, @Nonnull IFluidHandlerItem handler) {
        FluidState fluidState = FluidState.get((IBlockAccess)world, pos);
        if (fluidState.isValid()) {
            if (world.field_72995_K) {
                return true;
            }
            if (handler.fill(fluidState.getFluidBlock().drain(world, pos, true), true) == 1000) {
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, fluidState.getFluid().getFillSound(world, pos), SoundCategory.BLOCKS, 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    static boolean tryBucketDrain(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, @Nonnull IFluidHandlerItem handler, @Nonnull FluidStack stack) {
        FluidState fluidState;
        Fluid fluid = stack.getFluid();
        if (FluidloggedUtils.isStateFluidloggable(world.func_180495_p(pos), world, pos, fluid) && (fluidState = FluidState.of(fluid)).isValid()) {
            if (world.field_72995_K) {
                return true;
            }
            if (handler.drain(new FluidStack(stack, fluidState.getFluidBlock().place(world, pos, stack.copy(), true)), true) != null) {
                if (!world.field_73011_w.func_177500_n() || !fluid.doesVaporize(stack)) {
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, fluid.getEmptySound(stack), SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                return true;
            }
        }
        return false;
    }
}

