/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.client.optifine;

import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiErrorScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.CustomModLoadingErrorDisplayException;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class UnsupportedOptifineException
extends CustomModLoadingErrorDisplayException {
    @Nonnull
    protected final String currentVersion;

    public UnsupportedOptifineException(@Nonnull String currentVersionIn) {
        this.currentVersion = currentVersionIn.replaceAll("1.12.2_", "").replaceAll("_MOD", "");
    }

    public void initGui(@Nonnull GuiErrorScreen errorScreen, @Nonnull FontRenderer fontRenderer) {
    }

    public void drawScreen(@Nonnull GuiErrorScreen errorScreen, @Nonnull FontRenderer fontRenderer, int mouseRelX, int mouseRelY, float tickTime) {
        String modMissingDependenciesText = I18n.func_135052_a((String)"fml.messages.mod.missing.dependencies.compatibility", (Object[])new Object[]{TextFormatting.BOLD + "Fluidlogged API" + TextFormatting.RESET});
        errorScreen.func_73732_a(fontRenderer, modMissingDependenciesText, errorScreen.field_146294_l / 2, 75, 0xFFFFFF);
        String missingReason = I18n.func_135052_a((String)"fml.messages.mod.missing.dependencies.you.have", (Object[])new Object[]{this.currentVersion});
        String versionInfoText = String.format(TextFormatting.BOLD + "%s " + TextFormatting.RESET + "(%s)", "OptiFine_HD_U_G5+", missingReason);
        String message = I18n.func_135052_a((String)"fml.messages.mod.missing.dependencies.compatible.with", (Object[])new Object[]{versionInfoText});
        errorScreen.func_73732_a(fontRenderer, message, errorScreen.field_146294_l / 2, 90, 0xEEEEEE);
    }

    public static void checkOptifineVersion() {
        DummyModContainer container;
        if (FMLClientHandler.instance().hasOptifine() && !(container = (DummyModContainer)ObfuscationReflectionHelper.getPrivateValue(FMLClientHandler.class, (Object)FMLClientHandler.instance(), (String)"optifineContainer")).getVersion().startsWith("OptiFine_1.12.2_HD_U_G")) {
            throw new LoaderException((Throwable)((Object)new UnsupportedOptifineException(container.getVersion())));
        }
    }
}

