/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.client;

import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelFluid;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="fluidlogged_api", value={Side.CLIENT})
public final class ClientEventHandler {
    @SubscribeEvent(priority=EventPriority.LOW)
    static void removeBuiltInLiquidStateMappers(@Nonnull TextureStitchEvent.Pre event) {
        Minecraft.func_71410_x().field_175617_aL.func_174954_c().func_178120_a().field_178449_b.removeIf(b -> b instanceof BlockLiquid);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    static void registerLiquidStateMappers(@Nonnull ModelRegistryEvent event) {
        for (final Block block : ForgeRegistries.BLOCKS) {
            if (!(block instanceof BlockLiquid) || !FluidloggedUtils.isFluid(block)) continue;
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMapperBase(){

                @Nonnull
                protected ModelResourceLocation func_178132_a(@Nullable IBlockState state) {
                    return new ModelResourceLocation(Objects.requireNonNull(block.getRegistryName()), "fluid");
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    static void registerLiquidBakedModels(@Nonnull ModelBakeEvent event) {
        for (Block block : ForgeRegistries.BLOCKS) {
            if (!(block instanceof BlockLiquid) || !FluidloggedUtils.isFluid(block)) continue;
            ModelResourceLocation location = new ModelResourceLocation(block.getRegistryName(), "fluid");
            IBakedModel model = new ModelFluid(FluidloggedUtils.getFluidFromBlock(block)).bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176600_a, ModelLoader.defaultTextureGetter());
            event.getModelRegistry().func_82595_a((Object)location, (Object)model);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    static void improveDebugScreen(@Nonnull RenderGameOverlayEvent.Text event) {
        FluidState fluidState;
        RayTraceResult trace = Minecraft.func_71410_x().field_71476_x;
        if (trace != null && trace.field_72313_a == RayTraceResult.Type.BLOCK && !event.getRight().isEmpty() && !(fluidState = FluidState.get(trace.func_178782_a())).isEmpty()) {
            event.getRight().add("");
            event.getRight().add(String.valueOf(fluidState.getBlock().getRegistryName()));
            event.getRight().add(I18n.func_135052_a((String)"debugOverlay.fluidloggedAPI", (Object[])new Object[]{fluidState.getFluid().getName()}));
        }
    }
}

