/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.vanilla.world;

import atomicstryker.dynamiclights.client.DynamicLights;
import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.FluidloggedAPI;
import git.jbredwards.fluidlogged_api.mod.asm.plugins.vanilla.world.PluginChunk;
import git.jbredwards.fluidlogged_api.mod.asm.plugins.vanilla.world.PluginChunkCache;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PluginWorld
implements IASMPlugin {
    boolean isGalaxySpace = false;

    @Override
    public int getMethodIndex(@Nonnull MethodNode method, boolean obfuscated) {
        if (this.checkMethod(method, obfuscated ? "func_180501_a" : "setBlockState", "(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z")) {
            this.isGalaxySpace = !method.localVariables.isEmpty() && ((LocalVariableNode)method.localVariables.get((int)0)).index == 5;
            return 1;
        }
        if (this.checkMethod(method, obfuscated ? "func_175698_g" : "setBlockToAir", null)) {
            return 2;
        }
        if (this.checkMethod(method, obfuscated ? "func_175655_b" : "destroyBlock", null)) {
            return 2;
        }
        if (this.checkMethod(method, obfuscated ? "func_190524_a" : "neighborChanged", null)) {
            return 3;
        }
        if (this.checkMethod(method, obfuscated ? "func_72918_a" : "handleMaterialAcceleration", null)) {
            return 4;
        }
        if (this.checkMethod(method, obfuscated ? "func_72875_a" : "isMaterialInBB", null)) {
            return 5;
        }
        if (this.checkMethod(method, obfuscated ? "func_72953_d" : "containsAnyLiquid", null) || this.checkMethod(method, obfuscated ? "func_147470_e" : "isFlammableWithin", null) || this.checkMethod(method, obfuscated ? "func_175696_F" : "isWater", null)) {
            return 6;
        }
        if (method.name.equals(obfuscated ? "func_147470_e" : "isFlammableWithin")) {
            return 7;
        }
        if (this.checkMethod(method, obfuscated ? "func_175721_c" : "getLight", "(Lnet/minecraft/util/math/BlockPos;Z)I") || method.name.equals(obfuscated ? "func_175705_a" : "getLightFromNeighborsFor")) {
            return 8;
        }
        if (method.name.equals(obfuscated ? "func_180500_c" : "checkLightFor")) {
            return 9;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (index == 1) {
            if (this.checkMethod(insn, obfuscated ? "func_180495_p" : "getBlockState")) {
                if (obfuscated) {
                    ((MethodInsnNode)insn).name = "func_177435_g";
                }
                ((MethodInsnNode)insn).owner = "net/minecraft/world/chunk/Chunk";
                ((VarInsnNode)this.getPrevious((AbstractInsnNode)insn, (int)2)).var = this.isGalaxySpace ? 5 : 4;
                return false;
            }
            if (this.checkMethod(insn, "getLightValue") || this.checkMethod(insn, "getLightOpacity")) {
                instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, this.isGalaxySpace ? 5 : 4));
                instructions.insertBefore(insn, (AbstractInsnNode)this.genMethodNode(((MethodInsnNode)insn).name, "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/chunk/Chunk;)I"));
                instructions.remove(insn);
                return false;
            }
            if (!this.checkMethod(insn, obfuscated ? "func_177436_a" : "setBlockState")) return this.checkMethod(insn, "markAndNotifyBlock");
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)new VarInsnNode(25, this.isGalaxySpace ? 5 : 4));
            list.add((AbstractInsnNode)new VarInsnNode(25, this.isGalaxySpace ? 7 : 6));
            list.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list.add((AbstractInsnNode)new VarInsnNode(25, this.isGalaxySpace ? 10 : 9));
            list.add((AbstractInsnNode)new VarInsnNode(21, 3));
            list.add((AbstractInsnNode)this.genMethodNode("handleOldFluidState", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/chunk/Chunk;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/block/state/IBlockState;I)V"));
            instructions.insert(insn.getNext(), list);
            return false;
        }
        if (index == 2 && this.checkMethod(insn, obfuscated ? "func_176223_P" : "getDefaultState", "()Lnet/minecraft/block/state/IBlockState;")) {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)this.genMethodNode("git/jbredwards/fluidlogged_api/api/util/FluidState", "get", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Lgit/jbredwards/fluidlogged_api/api/util/FluidState;"));
            list.add((AbstractInsnNode)new MethodInsnNode(182, "git/jbredwards/fluidlogged_api/api/util/FluidState", "getState", "()Lnet/minecraft/block/state/IBlockState;", false));
            instructions.insert(insn, list);
            this.removeFrom(instructions, insn, -1);
            return true;
        }
        if (index == 3) {
            if (this.checkMethod(insn, obfuscated ? "func_180495_p" : "getBlockState")) {
                InsnList list = new InsnList();
                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                list.add((AbstractInsnNode)new VarInsnNode(25, 1));
                list.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/world/World", obfuscated ? "func_175726_f" : "getChunk", "(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/world/chunk/Chunk;", false));
                list.add((AbstractInsnNode)new VarInsnNode(58, 8));
                list.add((AbstractInsnNode)new VarInsnNode(25, 8));
                instructions.insertBefore(this.getPrevious(insn, 2), list);
                instructions.remove(this.getPrevious(insn, 2));
                if (obfuscated) {
                    ((MethodInsnNode)insn).name = "func_177435_g";
                }
                ((MethodInsnNode)insn).owner = "net/minecraft/world/chunk/Chunk";
                return false;
            }
            if (!this.checkMethod(insn, obfuscated ? "func_189546_a" : "neighborChanged", null)) return false;
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list.add((AbstractInsnNode)new VarInsnNode(25, 3));
            list.add((AbstractInsnNode)new VarInsnNode(25, 8));
            list.add((AbstractInsnNode)this.genMethodNode("fluidNeighborChanged", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/Block;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/chunk/Chunk;)V"));
            instructions.insert(insn, list);
            return true;
        }
        if (index == 4 && this.checkMethod(insn, obfuscated ? "func_185344_t" : "release", "()V")) {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list.add((AbstractInsnNode)new VarInsnNode(25, 3));
            list.add((AbstractInsnNode)new VarInsnNode(25, 11));
            list.add((AbstractInsnNode)new VarInsnNode(21, 10));
            list.add((AbstractInsnNode)new VarInsnNode(21, 4));
            list.add((AbstractInsnNode)new VarInsnNode(21, 5));
            list.add((AbstractInsnNode)new VarInsnNode(21, 6));
            list.add((AbstractInsnNode)new VarInsnNode(21, 7));
            list.add((AbstractInsnNode)new VarInsnNode(21, 8));
            list.add((AbstractInsnNode)new VarInsnNode(21, 9));
            list.add((AbstractInsnNode)this.genMethodNode("handleFluidAcceleration", "(Lnet/minecraft/world/World;Lnet/minecraft/block/material/Material;Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/Vec3d;ZIIIIII)Lorg/apache/commons/lang3/tuple/Pair;"));
            list.add((AbstractInsnNode)new VarInsnNode(58, 22));
            list.add((AbstractInsnNode)new VarInsnNode(25, 22));
            list.add((AbstractInsnNode)new MethodInsnNode(182, "org/apache/commons/lang3/tuple/Pair", "getKey", "()Ljava/lang/Object;", false));
            list.add((AbstractInsnNode)new TypeInsnNode(192, "java/lang/Boolean"));
            list.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Boolean", "booleanValue", "()Z", false));
            list.add((AbstractInsnNode)new VarInsnNode(54, 10));
            list.add((AbstractInsnNode)new VarInsnNode(25, 22));
            list.add((AbstractInsnNode)new MethodInsnNode(182, "org/apache/commons/lang3/tuple/Pair", "getValue", "()Ljava/lang/Object;", false));
            list.add((AbstractInsnNode)new TypeInsnNode(192, "net/minecraft/util/math/Vec3d"));
            list.add((AbstractInsnNode)new VarInsnNode(58, 11));
            instructions.insert(insn, list);
            return true;
        }
        if (index == 5 && insn.getOpcode() == 3) {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list.add((AbstractInsnNode)new VarInsnNode(21, 3));
            list.add((AbstractInsnNode)new VarInsnNode(21, 4));
            list.add((AbstractInsnNode)new VarInsnNode(21, 5));
            list.add((AbstractInsnNode)new VarInsnNode(21, 6));
            list.add((AbstractInsnNode)new VarInsnNode(21, 7));
            list.add((AbstractInsnNode)new VarInsnNode(21, 8));
            list.add((AbstractInsnNode)this.genMethodNode("isMaterialInFluidBB", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/AxisAlignedBB;Lnet/minecraft/block/material/Material;IIIIII)Z"));
            instructions.insert(insn, list);
            instructions.remove(insn);
            return true;
        }
        if (index == 6 && this.checkMethod(insn, obfuscated ? "func_180495_p" : "getBlockState", "(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;")) {
            instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("git/jbredwards/fluidlogged_api/api/util/FluidloggedUtils", "getFluidOrReal", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;"));
            instructions.remove(insn);
            return true;
        }
        if (index == 7 && this.checkField(insn, obfuscated ? "field_150353_l" : "LAVA")) {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new VarInsnNode(25, 8));
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)this.genMethodNode("isFlammableFluidWithin", "(Lnet/minecraft/block/Block;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/AxisAlignedBB;)Z"));
            instructions.insert(insn, list);
            this.removeFrom(instructions, insn, -3);
            return true;
        }
        if (index == 8 && this.checkMethod(insn, obfuscated ? "func_185916_f" : "useNeighborBrightness")) {
            instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("useNeighborBrightness", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z"));
            this.removeFrom(instructions, insn, -1);
            return true;
        }
        if (index != 9) return false;
        if (this.checkMethod(insn, obfuscated ? "func_180495_p" : "getBlockState")) {
            instructions.insert(insn, (AbstractInsnNode)new InsnNode(1));
            this.removeFrom(instructions, insn, -2);
            return false;
        }
        if (!this.checkMethod(insn, "getLightOpacity")) return false;
        this.removeFrom(instructions, this.getPrevious(insn, 3), -2);
        instructions.insert(insn, (AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/world/World", "getBlockLightOpacity", "(Lnet/minecraft/util/math/BlockPos;)I", false));
        instructions.remove(insn);
        return true;
    }

    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        classNode.interfaces.add("git/jbredwards/fluidlogged_api/api/asm/impl/IChunkProvider");
        this.addMethod(classNode, "getChunkFromBlockCoords", "(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/world/chunk/Chunk;", null, null, generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitMethodInsn(182, "net/minecraft/world/World", obfuscated ? "func_175726_f" : "getChunk", "(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/world/chunk/Chunk;", false);
        });
        this.overrideMethod(classNode, method -> this.checkMethod((MethodNode)method, obfuscated ? "func_147447_a" : "rayTraceBlocks", "(Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/math/Vec3d;ZZZ)Lnet/minecraft/util/math/RayTraceResult;"), "rayTraceBlocks", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/math/Vec3d;ZZZ)Lnet/minecraft/util/math/RayTraceResult;", generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(21, 3);
            generator.visitVarInsn(21, 4);
            generator.visitVarInsn(21, 5);
        });
        this.overrideMethod(classNode, method -> method.name.equals(obfuscated ? "func_175638_a" : "getRawLight"), "getRawLight", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/EnumSkyBlock;)I", generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
        });
        this.overrideMethod(classNode, method -> method.name.equals(obfuscated ? "func_175623_d" : "isAirBlock"), "isAirBlock", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z", generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
        });
        return true;
    }

    @Override
    public boolean addLocalVariables(@Nonnull MethodNode method, @Nonnull LabelNode start, @Nonnull LabelNode end, int index) {
        if (index == 3) {
            method.localVariables.add(new LocalVariableNode("chunk", "Lnet/minecraft/world/chunk/Chunk;", null, start, end, 8));
            return true;
        }
        if (index == 4) {
            method.localVariables.add(new LocalVariableNode("flags", "Lorg/apache/commons/lang3/tuple/Pair;", null, start, end, 22));
            return true;
        }
        return false;
    }

    public static final class DLHooks {
        public static int getLightValue(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState fluidState) {
            return Math.max(DynamicLights.getLightValue((Block)state.func_177230_c(), (IBlockState)state, (IBlockAccess)world, (BlockPos)pos), fluidState.getLightValue((IBlockAccess)world, pos));
        }
    }

    public static final class Hooks {
        public static void fluidNeighborChanged(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos, @Nonnull Chunk chunk) {
            FluidState fluidState = FluidState.getFromProvider((ICapabilityProvider)chunk, pos);
            if (!fluidState.isEmpty()) {
                fluidState.getState().func_189546_a(world, pos, blockIn, fromPos);
            }
        }

        public static int getLightOpacity(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Chunk chunk) {
            return PluginChunk.Hooks.getFluidLightOpacity(state, world, pos, chunk);
        }

        public static int getLightValue(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Chunk chunk) {
            return PluginChunk.Hooks.getFluidLightValue(state, world, pos, chunk);
        }

        public static int getRawLight(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumSkyBlock lightType) {
            if (lightType == EnumSkyBlock.SKY && world.func_175678_i(pos)) {
                return 15;
            }
            Chunk chunk = world.func_175726_f(pos);
            IBlockState state = chunk.func_177435_g(pos);
            IBlockState fluidState = FluidState.getFromProvider((ICapabilityProvider)chunk, pos).getState();
            int light = lightType == EnumSkyBlock.SKY ? 0 : (FluidloggedAPI.isDynamicLights ? DLHooks.getLightValue(state, world, pos, fluidState) : Math.max(state.getLightValue((IBlockAccess)world, pos), fluidState.getLightValue((IBlockAccess)world, pos)));
            int opacity = Math.max(Math.max(state.getLightOpacity((IBlockAccess)world, pos), fluidState.getLightOpacity((IBlockAccess)world, pos)), 1);
            if (opacity >= 15) {
                return light;
            }
            if (light >= 14) {
                return light;
            }
            for (EnumFacing facing : EnumFacing.values()) {
                BlockPos offset = pos.func_177972_a(facing);
                int neighborLight = world.func_175642_b(lightType, offset) - opacity;
                if (neighborLight > light) {
                    light = neighborLight;
                }
                if (light < 14) continue;
                return light;
            }
            return light;
        }

        @Nonnull
        public static Pair<Boolean, Vec3d> handleFluidAcceleration(@Nonnull World world, @Nonnull Material material, @Nonnull Entity entity, @Nonnull Vec3d vec3dIn, boolean flagIn, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    for (int z = minZ; z < maxZ; ++z) {
                        BlockPos pos = new BlockPos(x, y, z);
                        FluidState fluidState = FluidState.get((IBlockAccess)world, pos);
                        if (fluidState.isEmpty()) continue;
                        Block block = fluidState.getBlock();
                        Boolean result = block.isEntityInsideMaterial((IBlockAccess)world, pos, fluidState.getState(), entity, (double)maxY, material, false);
                        if (Boolean.TRUE.equals(result)) {
                            vec3dIn = block.func_176197_a(world, pos, entity, vec3dIn);
                            flagIn = true;
                            continue;
                        }
                        if (Boolean.FALSE.equals(result) || fluidState.getMaterial() != material || !((float)maxY >= (float)(y + 1) - 0.11111111f)) continue;
                        vec3dIn = block.func_176197_a(world, pos, entity, vec3dIn);
                        flagIn = true;
                    }
                }
            }
            return Pair.of((Object)flagIn, (Object)vec3dIn);
        }

        public static void handleOldFluidState(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Chunk chunk, @Nonnull IBlockState oldState, @Nonnull IBlockState newState, @Nullable IBlockState iblockstate, int blockFlags) {
            if (iblockstate != null) {
                FluidState fluidState = FluidState.getFromProvider((ICapabilityProvider)chunk, pos);
                if ((blockFlags & 0x20) != 0) {
                    if (!fluidState.isEmpty()) {
                        FluidloggedUtils.setFluidState(world, pos, newState, FluidState.EMPTY, false, false, blockFlags);
                    }
                    return;
                }
                if (!fluidState.isEmpty()) {
                    if (!FluidloggedUtils.isStateFluidloggable(newState, world, pos, fluidState.getFluid())) {
                        FluidloggedUtils.setFluidState(world, pos, newState, FluidState.EMPTY, false, false, blockFlags);
                        if (world.func_175697_a(pos, 1)) {
                            FluidloggedUtils.notifyFluids(world, pos, fluidState, false, new EnumFacing[0]);
                        }
                    } else if (world.func_175697_a(pos, 1)) {
                        FluidloggedUtils.notifyFluids(world, pos, fluidState, true, new EnumFacing[0]);
                    }
                    return;
                }
                Fluid fluid = FluidloggedUtils.getFluidFromState(oldState);
                if (fluid != null && FluidloggedUtils.isFluidloggableFluid(oldState, world, pos) && FluidloggedUtils.isStateFluidloggable(newState, world, pos, fluid)) {
                    FluidloggedUtils.setFluidState(world, pos, newState, FluidState.of(fluid), false, false, blockFlags);
                }
            }
        }

        public static boolean isAirBlock(@Nonnull World world, @Nonnull BlockPos pos) {
            IBlockState state = world.func_180495_p(pos);
            return state.func_177230_c().isAir(state, (IBlockAccess)world, pos);
        }

        public static boolean isFlammableFluidWithin(@Nonnull Block block, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB bb) {
            if (block.func_176223_P().func_185904_a() == Material.field_151587_i) {
                return Boolean.TRUE.equals(block.isAABBInsideLiquid(world, pos, bb));
            }
            FluidState fluidState = FluidState.get((IBlockAccess)world, pos);
            return fluidState.getMaterial() == Material.field_151587_i && Boolean.TRUE.equals(fluidState.getBlock().isAABBInsideLiquid(world, pos, bb));
        }

        public static boolean isMaterialInFluidBB(@Nonnull World world, @Nonnull AxisAlignedBB bb, @Nonnull Material materialIn, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    for (int z = minZ; z < maxZ; ++z) {
                        BlockPos pos = new BlockPos(x, y, z);
                        FluidState fluidState = FluidState.get((IBlockAccess)world, pos);
                        if (fluidState.isEmpty()) continue;
                        Boolean result = fluidState.getBlock().isAABBInsideMaterial(world, pos, bb, materialIn);
                        if (result != null) {
                            if (!result.booleanValue()) continue;
                            return true;
                        }
                        if (fluidState.getMaterial() != materialIn) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        @Nullable
        public static RayTraceResult rayTraceBlocks(@Nonnull World world, @Nonnull Vec3d vec, @Nonnull Vec3d end, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
            RayTraceResult result;
            FluidState fluidState;
            if (Double.isNaN(vec.field_72450_a) || Double.isNaN(vec.field_72448_b) || Double.isNaN(vec.field_72449_c) || Double.isNaN(end.field_72450_a) || Double.isNaN(end.field_72448_b) || Double.isNaN(end.field_72449_c)) {
                return null;
            }
            int endX = MathHelper.func_76128_c((double)end.field_72450_a);
            int endY = MathHelper.func_76128_c((double)end.field_72448_b);
            int endZ = MathHelper.func_76128_c((double)end.field_72449_c);
            int prevX = MathHelper.func_76128_c((double)vec.field_72450_a);
            int prevY = MathHelper.func_76128_c((double)vec.field_72448_b);
            int prevZ = MathHelper.func_76128_c((double)vec.field_72449_c);
            BlockPos pos = new BlockPos(prevX, prevY, prevZ);
            if (stopOnLiquid && !(fluidState = FluidState.get((IBlockAccess)world, pos)).isEmpty() && fluidState.getBlock().func_176209_a(fluidState.getState(), true) && (result = fluidState.getState().func_185910_a(world, pos, vec, end)) != null) {
                return result;
            }
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177230_c().func_176209_a(state, stopOnLiquid) && (stopOnLiquid && FluidloggedUtils.isFluid(state) || !ignoreBlockWithoutBoundingBox || state.func_185890_d((IBlockAccess)world, pos) != Block.field_185506_k) && (result = state.func_185910_a(world, pos, vec, end)) != null) {
                return result;
            }
            RayTraceResult lastResult = FluidloggedAPI.isChiseledMe ? new RayTraceResult(RayTraceResult.Type.MISS, end, EnumFacing.DOWN, pos) : null;
            int i = 200;
            while (i-- >= 0) {
                FluidState fluidState2;
                EnumFacing facing;
                if (Double.isNaN(vec.field_72450_a) || Double.isNaN(vec.field_72448_b) || Double.isNaN(vec.field_72449_c)) {
                    return null;
                }
                if (prevX == endX && prevY == endY && prevZ == endZ) {
                    return returnLastUncollidableBlock ? lastResult : null;
                }
                boolean flagX = true;
                boolean flagY = true;
                boolean flagZ = true;
                double x = 999.0;
                double y = 999.0;
                double z = 999.0;
                if (endX > prevX) {
                    x = prevX + 1;
                } else if (endX < prevX) {
                    x = prevX;
                } else {
                    flagX = false;
                }
                if (endY > prevY) {
                    y = prevY + 1;
                } else if (endY < prevY) {
                    y = prevY;
                } else {
                    flagY = false;
                }
                if (endZ > prevZ) {
                    z = prevZ + 1;
                } else if (endZ < prevZ) {
                    z = prevZ;
                } else {
                    flagZ = false;
                }
                double coveredX = 999.0;
                double coveredY = 999.0;
                double coveredZ = 999.0;
                double distX = end.field_72450_a - vec.field_72450_a;
                double distY = end.field_72448_b - vec.field_72448_b;
                double distZ = end.field_72449_c - vec.field_72449_c;
                if (flagX) {
                    coveredX = (x - vec.field_72450_a) / distX;
                }
                if (flagY) {
                    coveredY = (y - vec.field_72448_b) / distY;
                }
                if (flagZ) {
                    coveredZ = (z - vec.field_72449_c) / distZ;
                }
                if (coveredX == 0.0) {
                    coveredX = -1.0E-4;
                }
                if (coveredY == 0.0) {
                    coveredY = -1.0E-4;
                }
                if (coveredZ == 0.0) {
                    coveredZ = -1.0E-4;
                }
                if (coveredX < coveredY && coveredX < coveredZ) {
                    facing = endX > prevX ? EnumFacing.WEST : EnumFacing.EAST;
                    vec = new Vec3d(x, vec.field_72448_b + distY * coveredX, vec.field_72449_c + distZ * coveredX);
                } else if (coveredY < coveredZ) {
                    facing = endY > prevY ? EnumFacing.DOWN : EnumFacing.UP;
                    vec = new Vec3d(vec.field_72450_a + distX * coveredY, y, vec.field_72449_c + distZ * coveredY);
                } else {
                    facing = endZ > prevZ ? EnumFacing.NORTH : EnumFacing.SOUTH;
                    vec = new Vec3d(vec.field_72450_a + distX * coveredZ, vec.field_72448_b + distY * coveredZ, z);
                }
                prevX = MathHelper.func_76128_c((double)vec.field_72450_a) - (facing == EnumFacing.EAST ? 1 : 0);
                prevY = MathHelper.func_76128_c((double)vec.field_72448_b) - (facing == EnumFacing.UP ? 1 : 0);
                prevZ = MathHelper.func_76128_c((double)vec.field_72449_c) - (facing == EnumFacing.SOUTH ? 1 : 0);
                pos = new BlockPos(prevX, prevY, prevZ);
                if (stopOnLiquid && !(fluidState2 = FluidState.get((IBlockAccess)world, pos)).isEmpty()) {
                    if (fluidState2.getBlock().func_176209_a(fluidState2.getState(), true)) {
                        result = fluidState2.getState().func_185910_a(world, pos, vec, end);
                        if (result != null) {
                            return result;
                        }
                    } else {
                        lastResult = new RayTraceResult(RayTraceResult.Type.MISS, vec, facing, pos);
                    }
                }
                state = world.func_180495_p(pos);
                if (ignoreBlockWithoutBoundingBox && state.func_185904_a() != Material.field_151567_E && (!stopOnLiquid || !FluidloggedUtils.isFluid(state)) && state.func_185890_d((IBlockAccess)world, pos) == Block.field_185506_k) continue;
                if (state.func_177230_c().func_176209_a(state, stopOnLiquid)) {
                    result = state.func_185910_a(world, pos, vec, end);
                    if (result == null) continue;
                    return result;
                }
                lastResult = new RayTraceResult(RayTraceResult.Type.MISS, vec, facing, pos);
            }
            return returnLastUncollidableBlock ? lastResult : null;
        }

        public static boolean useNeighborBrightness(@Nonnull World world, @Nonnull BlockPos pos) {
            return PluginChunkCache.Hooks.useNeighborBrightness((IBlockAccess)world, pos);
        }
    }
}

