/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.vanilla.entity;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PluginEntity
implements IASMPlugin {
    @Override
    public int getMethodIndex(@Nonnull MethodNode method, boolean obfuscated) {
        if (method.name.equals(obfuscated ? "func_180799_ab" : "isInLava")) {
            return 1;
        }
        if (method.name.equals(obfuscated ? "func_70072_I" : "handleWaterMovement")) {
            return 2;
        }
        if (method.name.equals(obfuscated ? "func_71061_d_" : "doWaterSplashEffect")) {
            return 3;
        }
        if (method.name.equals(obfuscated ? "func_70055_a" : "isInsideOfMaterial")) {
            return 4;
        }
        if (method.name.equals(obfuscated ? "func_145775_I" : "doBlockCollisions")) {
            return 5;
        }
        return 0;
    }

    @Override
    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (index == 1 && this.checkMethod(insn, obfuscated ? "func_72314_b" : "grow")) {
            this.removeFrom(instructions, insn, -3);
            return true;
        }
        if (index == 2 && this.checkMethod(this.getNext(insn, 2), obfuscated ? "func_72314_b" : "grow")) {
            instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("fixSquidWaterCollision", "(DLnet/minecraft/entity/Entity;)D"));
            instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
            return true;
        }
        if (index == 3) {
            if (this.checkMethod(insn.getPrevious(), obfuscated ? "func_76128_c" : "floor")) {
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("fixWaterSplashEffect", "(Lnet/minecraft/entity/Entity;)F"));
                this.removeFrom(instructions, insn, -3);
            } else if (insn.getOpcode() == 98 && insn.getPrevious().getOpcode() == 12) {
                this.removeFrom(instructions, insn, -1);
            } else if (this.checkField(insn, "WATER_BUBBLE")) {
                this.removeFrom(instructions, this.getNext(insn, 15), 12);
                instructions.insert(this.getNext(insn, 14), (AbstractInsnNode)new InsnNode(14));
                instructions.insert(this.getNext(insn, 14), (AbstractInsnNode)new InsnNode(14));
                instructions.insert(this.getNext(insn, 14), (AbstractInsnNode)new InsnNode(14));
            }
        } else {
            if (index == 4 && this.checkMethod(insn, "isEntityInsideMaterial")) {
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("isEntityInsideFluidState", "(Lnet/minecraft/block/Block;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/Entity;DLnet/minecraft/block/material/Material;Z)Ljava/lang/Boolean;"));
                instructions.remove(insn);
                return true;
            }
            if (index == 5 && this.checkMethod(insn, obfuscated ? "func_180634_a" : "onEntityCollision")) {
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("onEntityCollidedWithFluidState", "(Lnet/minecraft/block/Block;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/Entity;)V"));
                instructions.remove(insn);
                return true;
            }
        }
        return false;
    }

    public static final class Hooks {
        public static double fixSquidWaterCollision(double factor, @Nonnull Entity entity) {
            return entity.isCreatureType(EnumCreatureType.WATER_CREATURE, false) ? factor : 0.0;
        }

        public static float fixWaterSplashEffect(@Nonnull Entity entity) {
            BlockPos pos;
            FluidState fluidState;
            RayTraceResult result = entity.field_70170_p.func_147447_a(new Vec3d(entity.field_70165_t - entity.field_70159_w, entity.field_70163_u - entity.field_70181_x, entity.field_70161_v - entity.field_70179_y), new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v), true, true, false);
            if (result != null && !(fluidState = FluidloggedUtils.getFluidState((IBlockAccess)entity.field_70170_p, pos = result.func_178782_a())).isEmpty() && fluidState.isValid()) {
                float filled = fluidState.getFluidBlock().getFilledPercentage(entity.field_70170_p, pos);
                return (float)pos.func_177956_o() + (filled < 0.0f ? filled + 1.1f : filled - 0.1f);
            }
            return (float)(entity.field_70163_u + entity.field_70181_x * -0.7 - 0.1);
        }

        @Nullable
        public static Boolean isEntityInsideFluidState(@Nonnull Block block, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState here, @Nonnull Entity entity, double yToTest, @Nonnull Material materialIn, boolean testingHead) {
            FluidState fluidState;
            Boolean result = block.isEntityInsideMaterial((IBlockAccess)world, pos, here, entity, yToTest, materialIn, testingHead);
            if (result != null) {
                return result;
            }
            if (FluidloggedUtils.getFluidFromBlock(block) == null && !(fluidState = FluidState.get((IBlockAccess)world, pos)).isEmpty()) {
                result = fluidState.getBlock().isEntityInsideMaterial((IBlockAccess)world, pos, fluidState.getState(), entity, yToTest, materialIn, testingHead);
                if (result != null) {
                    return result;
                }
                if (fluidState.getMaterial() == materialIn) {
                    return ForgeHooks.isInsideOfMaterial((Material)materialIn, (Entity)entity, (BlockPos)pos);
                }
            }
            return null;
        }

        public static void onEntityCollidedWithFluidState(@Nonnull Block block, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState here, @Nonnull Entity entityIn) {
            if (!Boolean.FALSE.equals(block.isAABBInsideLiquid(worldIn, pos, entityIn.func_174813_aQ()))) {
                block.func_180634_a(worldIn, pos, here, entityIn);
            }
            if (FluidloggedUtils.getFluidFromBlock(block) != null) {
                return;
            }
            FluidState fluidState = FluidState.get((IBlockAccess)worldIn, pos);
            if (!fluidState.isEmpty() && !Boolean.FALSE.equals(fluidState.getBlock().isAABBInsideLiquid(worldIn, pos, entityIn.func_174813_aQ()))) {
                fluidState.getBlock().func_180634_a(worldIn, pos, fluidState.getState(), entityIn);
            }
        }
    }
}

