/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.vanilla.block;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;

public final class PluginBlockDoor
implements IASMPlugin {
    @Override
    public int getMethodIndex(@Nonnull MethodNode method, boolean obfuscated) {
        if (method.name.equals(obfuscated ? "func_180639_a" : "onBlockActivated") || method.name.equals(obfuscated ? "func_176512_a" : "toggleDoor") || method.name.equals(obfuscated ? "func_189540_a" : "neighborChanged")) {
            return 1;
        }
        return method.name.equals(obfuscated ? "func_176208_a" : "onBlockHarvested") ? 2 : 0;
    }

    @Override
    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (index == 1 && this.checkMethod(insn, obfuscated ? "func_175704_b" : "markBlockRangeForRenderUpdate", "(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;)V")) {
            instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("notifyDoorFluids", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;)V"));
            instructions.remove(insn);
            return true;
        }
        if (index == 2) {
            if (this.checkField(insn, obfuscated ? "field_75098_d" : "isCreativeMode") && this.getNext(insn, 3) instanceof LineNumberNode) {
                instructions.insert(insn, (AbstractInsnNode)new InsnNode(3));
                this.removeFrom(instructions, insn, -2);
            } else if (this.checkMethod(insn, obfuscated ? "func_175698_g" : "setBlockToAir")) {
                boolean isLast = this.getNext(insn, 5).getOpcode() == 177;
                instructions.insertBefore(insn, (AbstractInsnNode)this.genMethodNode("setBlockToAirNoUpdate", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)V"));
                this.removeFrom(instructions, insn, 1);
                return isLast;
            }
        }
        return false;
    }

    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        classNode.interfaces.add("git/jbredwards/fluidlogged_api/api/block/IFluidloggable");
        this.addMethod(classNode, "canFluidFlow", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/EnumFacing;)Z", "canDoorFluidFlow", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/EnumFacing;)Z", generator -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(25, 4);
        });
        return true;
    }

    public static final class Hooks {
        public static boolean canDoorFluidFlow(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState here, @Nonnull EnumFacing side) {
            if (side.func_176740_k().func_176720_b()) {
                return true;
            }
            here = here.func_185899_b(world, pos);
            EnumFacing facing = (EnumFacing)here.func_177229_b((IProperty)BlockDoor.field_176520_a);
            return (((Boolean)here.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue() ? (here.func_177229_b((IProperty)BlockDoor.field_176521_M) == BlockDoor.EnumHingePosition.RIGHT ? facing.func_176746_e() : facing.func_176735_f()) : facing.func_176734_d()) != side;
        }

        public static void notifyDoorFluids(@Nonnull World world, @Nonnull BlockPos rangeMin, @Nonnull BlockPos rangeMax) {
            FluidloggedUtils.notifyFluids(world, rangeMin.func_177984_a(), FluidState.get((IBlockAccess)world, rangeMin.func_177984_a()), false, EnumFacing.DOWN);
            world.func_175704_b(rangeMin, rangeMax);
        }

        public static void setBlockToAirNoUpdate(@Nonnull World world, @Nonnull BlockPos pos) {
            world.func_180501_a(pos, FluidState.get((IBlockAccess)world, pos).getState(), 2);
        }
    }
}

