/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.forge;

import com.google.common.collect.ImmutableMap;
import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.asm.impl.IChunkProvider;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.asm.plugins.vanilla.block.PluginBlockLiquid;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfigHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.PropertyFloat;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidBlock;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PluginBlockFluidBase
implements IASMPlugin {
    @Override
    public int getMethodIndex(@Nonnull MethodNode method, boolean obfuscated) {
        if (this.checkMethod(method, "<init>", "(Lnet/minecraftforge/fluids/Fluid;Lnet/minecraft/block/material/Material;Lnet/minecraft/block/material/MapColor;)V")) {
            return 1;
        }
        if (this.checkMethod(method, "<clinit>", "()V")) {
            return 2;
        }
        if (method.name.equals("canDisplace")) {
            return 3;
        }
        if (method.name.equals("getFlowDirection") || method.name.equals("getDensity") || method.name.equals("getTemperature")) {
            return 4;
        }
        if (method.name.equals("getFluid")) {
            return 5;
        }
        if (this.checkMethod(method, "getFilledPercentage", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)F")) {
            return 6;
        }
        return method.name.equals("getStateAtViewpoint") ? 7 : 0;
    }

    @Override
    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (index == 1 && this.checkField(insn, "defaultDisplacements", "Ljava/util/Map;")) {
            instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("defaultDisplacements", "(Ljava/util/Map;)Ljava/util/Map;"));
            return true;
        }
        if (index == 2 && insn.getNext().getOpcode() == 18) {
            while (insn.getPrevious().getOpcode() != 179) {
                instructions.remove(insn.getPrevious());
            }
            return true;
        }
        if (index == 3) {
            if (insn.getOpcode() == 166) {
                InsnList list = new InsnList();
                list.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraftforge/fluids/BlockFluidBase", "getFluid", "()Lnet/minecraftforge/fluids/Fluid;", false));
                list.add((AbstractInsnNode)new VarInsnNode(25, 1));
                list.add((AbstractInsnNode)new VarInsnNode(25, 2));
                list.add((AbstractInsnNode)new VarInsnNode(25, 3));
                list.add((AbstractInsnNode)this.genMethodNode("git/jbredwards/fluidlogged_api/api/util/FluidloggedUtils", "getFluidState", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)Lgit/jbredwards/fluidlogged_api/api/util/FluidState;"));
                list.add((AbstractInsnNode)new MethodInsnNode(182, "git/jbredwards/fluidlogged_api/api/util/FluidState", "getFluid", "()Lnet/minecraftforge/fluids/Fluid;", false));
                list.add((AbstractInsnNode)this.genMethodNode("git/jbredwards/fluidlogged_api/api/util/FluidloggedUtils", "isCompatibleFluid", "(Lnet/minecraftforge/fluids/Fluid;Lnet/minecraftforge/fluids/Fluid;)Z"));
                instructions.remove(this.getPrevious(insn, 2));
                instructions.insertBefore(insn, list);
                ((JumpInsnNode)insn).setOpcode(153);
            } else if (insn.getOpcode() == 165) {
                InsnList list = new InsnList();
                list.add((AbstractInsnNode)new VarInsnNode(25, 5));
                list.add((AbstractInsnNode)new FieldInsnNode(178, "net/minecraft/block/material/Material", obfuscated ? "field_151594_q" : "CIRCUITS", "Lnet/minecraft/block/material/Material;"));
                list.add((AbstractInsnNode)new JumpInsnNode(165, ((JumpInsnNode)insn).label));
                instructions.insert(insn, list);
                return true;
            }
        } else {
            if (index == 4 && this.checkMethod(insn, obfuscated ? "func_180495_p" : "getBlockState")) {
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("git/jbredwards/fluidlogged_api/api/util/FluidloggedUtils", "getFluidOrReal", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;"));
                instructions.remove(insn);
                return true;
            }
            if (index == 5 && this.checkMethod(insn, "getFluid", "(Ljava/lang/String;)Lnet/minecraftforge/fluids/Fluid;")) {
                instructions.insert(insn, (AbstractInsnNode)new FieldInsnNode(180, "net/minecraftforge/fluids/BlockFluidBase", "definedFluid", "Lnet/minecraftforge/fluids/Fluid;"));
                instructions.remove(insn.getPrevious());
                instructions.remove(insn);
                return true;
            }
            if (index == 6 && insn.getOpcode() == 174) {
                instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                instructions.insertBefore(insn, (AbstractInsnNode)new FieldInsnNode(180, "net/minecraftforge/fluids/BlockFluidBase", "quantaFraction", "F"));
                instructions.insertBefore(insn, (AbstractInsnNode)this.genMethodNode("applyQuantaFraction", "(FF)F"));
                return true;
            }
            if (index == 7 && this.checkMethod(insn, obfuscated ? "func_180495_p" : "getBlockState")) {
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("getStateAtViewpoint", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/Vec3d;)Lnet/minecraft/block/state/IBlockState;"));
                instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 4));
                instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 1));
                this.removeFrom(instructions, insn, -3);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        this.overrideMethod(classNode, method -> method.name.equals(obfuscated ? "func_176225_a" : "shouldSideBeRendered"), "shouldFluidSideBeRendered", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;I)Z", generator -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(25, 4);
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraftforge/fluids/BlockFluidBase", "densityDir", "I");
        });
        this.overrideMethod(classNode, method -> method.name.equals("getExtendedState"), "getFluidExtendedState", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraftforge/fluids/Fluid;IIFFF)Lnet/minecraft/block/state/IBlockState;", generator -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(25, 0);
            generator.visitMethodInsn(185, "net/minecraftforge/fluids/IFluidBlock", "getFluid", "()Lnet/minecraftforge/fluids/Fluid;", true);
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraftforge/fluids/BlockFluidBase", "densityDir", "I");
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraftforge/fluids/BlockFluidBase", "quantaPerBlock", "I");
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraftforge/fluids/BlockFluidBase", "quantaPerBlockFloat", "F");
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraftforge/fluids/BlockFluidBase", "quantaFraction", "F");
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitMethodInsn(184, "net/minecraftforge/fluids/BlockFluidBase", "getFlowDirection", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)D", false);
            generator.visitInsn(144);
        });
        this.overrideMethod(classNode, method -> method.name.equals("getFlowVector"), "getFluidFlowVector", "(Lnet/minecraftforge/fluids/BlockFluidBase;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;II)Lnet/minecraft/util/math/Vec3d;", generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraftforge/fluids/BlockFluidBase", "densityDir", "I");
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraftforge/fluids/BlockFluidBase", "quantaPerBlock", "I");
        });
        this.overrideMethod(classNode, method -> method.name.equals("hasVerticalFlow"), "hasVerticalFlow", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraftforge/fluids/Fluid;I)Z", generator -> {
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 0);
            generator.visitMethodInsn(185, "net/minecraftforge/fluids/IFluidBlock", "getFluid", "()Lnet/minecraftforge/fluids/Fluid;", true);
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraftforge/fluids/BlockFluidBase", "densityDir", "I");
        });
        this.overrideMethod(classNode, method -> method.name.equals("getFogColor"), "getFluidFogColor", "(Lnet/minecraftforge/fluids/BlockFluidBase;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/Vec3d;F)Lnet/minecraft/util/math/Vec3d;", generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(25, 4);
            generator.visitVarInsn(25, 5);
            generator.visitVarInsn(23, 6);
        });
        this.addMethod(classNode, "isEntityInsideMaterial", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/Entity;DLnet/minecraft/block/material/Material;Z)Ljava/lang/Boolean;", "isEntityInsideFluid", "(Lnet/minecraft/block/Block;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/Entity;DLnet/minecraft/block/material/Material;Z)Ljava/lang/Boolean;", generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(25, 4);
            generator.visitVarInsn(24, 5);
            generator.visitVarInsn(25, 7);
            generator.visitVarInsn(21, 8);
        });
        this.addMethod(classNode, "isAABBInsideMaterial", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/AxisAlignedBB;Lnet/minecraft/block/material/Material;)Ljava/lang/Boolean;", "isAABBInsideMaterial", "(Lnet/minecraft/block/Block;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/AxisAlignedBB;Lnet/minecraft/block/material/Material;)Ljava/lang/Boolean;", generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(25, 4);
        });
        this.addMethod(classNode, "isAABBInsideLiquid", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/AxisAlignedBB;)Ljava/lang/Boolean;", null, null, generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitMethodInsn(184, this.getHookClass(), "isWithinFluid", "(Lnet/minecraft/block/Block;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/AxisAlignedBB;)Z", false);
            generator.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
        });
        classNode.interfaces.add("git/jbredwards/fluidlogged_api/mod/asm/plugins/forge/PluginBlockFluidBase$Accessor");
        this.addMethod(classNode, "getFlowDecay_Public", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)I", null, null, generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitMethodInsn(183, "net/minecraftforge/fluids/BlockFluidBase", "getFlowDecay", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)I", false);
        });
        return true;
    }

    private static final class FluidExtendedBlockState
    extends BlockStateContainer.StateImplementation
    implements IExtendedBlockState {
        private Float flowDirection;
        private final Float[] levelCorners = new Float[4];
        private final Boolean[] sideOverlays = new Boolean[4];
        @Nonnull
        private final IExtendedBlockState parent;

        private FluidExtendedBlockState(@Nonnull IExtendedBlockState parentIn) {
            super(parentIn.func_177230_c(), parentIn.func_177228_b());
            this.parent = parentIn;
        }

        @Nonnull
        public <V> V getValue(@Nonnull IUnlistedProperty<V> property) {
            if (property == BlockFluidBase.FLOW_DIRECTION) {
                return (V)this.flowDirection;
            }
            if (property == BlockFluidBase.LEVEL_CORNERS[0]) {
                return (V)this.levelCorners[0];
            }
            if (property == BlockFluidBase.LEVEL_CORNERS[1]) {
                return (V)this.levelCorners[1];
            }
            if (property == BlockFluidBase.LEVEL_CORNERS[2]) {
                return (V)this.levelCorners[2];
            }
            if (property == BlockFluidBase.LEVEL_CORNERS[3]) {
                return (V)this.levelCorners[3];
            }
            if (property == BlockFluidBase.SIDE_OVERLAYS[0]) {
                return (V)this.sideOverlays[0];
            }
            if (property == BlockFluidBase.SIDE_OVERLAYS[1]) {
                return (V)this.sideOverlays[1];
            }
            if (property == BlockFluidBase.SIDE_OVERLAYS[2]) {
                return (V)this.sideOverlays[2];
            }
            if (property == BlockFluidBase.SIDE_OVERLAYS[3]) {
                return (V)this.sideOverlays[3];
            }
            return (V)this.parent.getValue(property);
        }

        @Nonnull
        public <V> IExtendedBlockState withProperty(@Nonnull IUnlistedProperty<V> property, @Nonnull V value) {
            if (property == BlockFluidBase.FLOW_DIRECTION) {
                this.flowDirection = (Float)value;
            } else if (property == BlockFluidBase.LEVEL_CORNERS[0]) {
                this.levelCorners[0] = (Float)value;
            } else if (property == BlockFluidBase.LEVEL_CORNERS[1]) {
                this.levelCorners[1] = (Float)value;
            } else if (property == BlockFluidBase.LEVEL_CORNERS[2]) {
                this.levelCorners[2] = (Float)value;
            } else if (property == BlockFluidBase.LEVEL_CORNERS[3]) {
                this.levelCorners[3] = (Float)value;
            } else if (property == BlockFluidBase.SIDE_OVERLAYS[0]) {
                this.sideOverlays[0] = (Boolean)value;
            } else if (property == BlockFluidBase.SIDE_OVERLAYS[1]) {
                this.sideOverlays[1] = (Boolean)value;
            } else if (property == BlockFluidBase.SIDE_OVERLAYS[2]) {
                this.sideOverlays[2] = (Boolean)value;
            } else if (property == BlockFluidBase.SIDE_OVERLAYS[3]) {
                this.sideOverlays[3] = (Boolean)value;
            } else {
                return this.parent.withProperty(property, value);
            }
            return this;
        }

        @Nonnull
        public ImmutableMap<IUnlistedProperty<?>, Optional<?>> getUnlistedProperties() {
            return this.parent.getUnlistedProperties();
        }

        @Nonnull
        public Collection<IUnlistedProperty<?>> getUnlistedNames() {
            return this.parent.getUnlistedNames();
        }

        @Nonnull
        public IBlockState getClean() {
            return this.parent.getClean();
        }
    }

    public static interface Accessor {
        public int getFlowDecay_Public(@Nonnull IBlockAccess var1, @Nonnull BlockPos var2);
    }

    public static final class Hooks {
        @Nonnull
        static final EnumFacing[][] FACES = new EnumFacing[][]{{EnumFacing.NORTH, EnumFacing.WEST}, {EnumFacing.NORTH}, {EnumFacing.NORTH, EnumFacing.EAST}, {EnumFacing.WEST}, new EnumFacing[0], {EnumFacing.EAST}, {EnumFacing.SOUTH, EnumFacing.WEST}, {EnumFacing.SOUTH}, {EnumFacing.SOUTH, EnumFacing.EAST}};

        @Nonnull
        public static Map<Block, Boolean> defaultDisplacements(@Nonnull Map<Block, Boolean> map) {
            HashMap<Block, Boolean> ret = new HashMap<Block, Boolean>();
            ret.put((Block)Blocks.field_180413_ao, false);
            ret.put((Block)Blocks.field_180414_ap, false);
            ret.put((Block)Blocks.field_180412_aq, false);
            ret.put((Block)Blocks.field_180411_ar, false);
            ret.put((Block)Blocks.field_180410_as, false);
            ret.put((Block)Blocks.field_180409_at, false);
            ret.put(Blocks.field_150415_aT, false);
            ret.put(Blocks.field_180400_cw, false);
            ret.put(Blocks.field_180407_aO, false);
            ret.put(Blocks.field_180408_aP, false);
            ret.put(Blocks.field_180404_aQ, false);
            ret.put(Blocks.field_180403_aR, false);
            ret.put(Blocks.field_180406_aS, false);
            ret.put(Blocks.field_180405_aT, false);
            ret.put(Blocks.field_150386_bk, false);
            ret.put(Blocks.field_180390_bo, false);
            ret.put(Blocks.field_180391_bp, false);
            ret.put(Blocks.field_180392_bq, false);
            ret.put(Blocks.field_180386_br, false);
            ret.put(Blocks.field_180385_bs, false);
            ret.put(Blocks.field_180387_bt, false);
            ret.put(Blocks.field_150452_aw, false);
            ret.put(Blocks.field_150456_au, false);
            ret.put(Blocks.field_150445_bS, false);
            ret.put(Blocks.field_150443_bT, false);
            ret.put(Blocks.field_150468_ap, false);
            ret.put(Blocks.field_150411_aY, false);
            ret.put(Blocks.field_150410_aZ, false);
            ret.put((Block)Blocks.field_150397_co, false);
            ret.put((Block)Blocks.field_150427_aO, false);
            ret.put(Blocks.field_150384_bq, false);
            ret.put(Blocks.field_150463_bK, false);
            ret.put(Blocks.field_180401_cv, false);
            ret.put(Blocks.field_180393_cK, false);
            ret.put(Blocks.field_180394_cL, false);
            ret.put(Blocks.field_150414_aQ, false);
            ret.put((Block)Blocks.field_150454_av, false);
            ret.put(Blocks.field_150472_an, false);
            ret.put(Blocks.field_150444_as, false);
            ret.put((Block)Blocks.field_150436_aH, false);
            ret.putAll(map);
            return ret;
        }

        @Nonnull
        public static IBlockState getFluidExtendedState(@Nonnull IBlockState oldState, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull Fluid fluid, int densityDir, int quantaPerBlock, float quantaPerBlockFloat, float quantaFraction, float flowDirection) {
            int j;
            int i;
            if (!(oldState instanceof IExtendedBlockState)) {
                return oldState;
            }
            EnumFacing densityFace = densityDir < 0 ? EnumFacing.UP : EnumFacing.DOWN;
            FluidExtendedBlockState state = new FluidExtendedBlockState((IExtendedBlockState)oldState);
            state.withProperty(BlockFluidBase.FLOW_DIRECTION, Float.valueOf(flowDirection));
            IBlockState[][][] states = new IBlockState[3][2][3];
            FluidState[][][] fluids = new FluidState[3][2][3];
            float[][] height = new float[3][3];
            float[][] corner = new float[2][2];
            Chunk[][] chunks = new Chunk[3][3];
            int originX = pos.func_177958_n() >> 4;
            int originZ = pos.func_177952_p() >> 4;
            states[1][0][1] = Hooks.getFromCache(chunks, world, pos, originX, originZ, Chunk::func_177435_g);
            states[1][1][1] = Hooks.getFromCache(chunks, world, pos.func_177979_c(densityDir), originX, originZ, Chunk::func_177435_g);
            fluids[1][0][1] = Hooks.getFluidFromCache(chunks, world, pos, originX, originZ, states[1][0][1]);
            fluids[1][1][1] = Hooks.getFluidFromCache(chunks, world, pos.func_177979_c(densityDir), originX, originZ, states[1][1][1]);
            height[1][1] = Hooks.getFluidHeightForRender(chunks, world, pos, states, fluids, 1, 1, densityFace, quantaPerBlock, quantaPerBlockFloat, quantaFraction, originX, originZ);
            if (height[1][1] == 1.0f) {
                for (i = 0; i < 2; ++i) {
                    for (j = 0; j < 2; ++j) {
                        corner[i][j] = 1.0f;
                    }
                }
            } else {
                for (i = 0; i < 3; ++i) {
                    for (j = 0; j < 3; ++j) {
                        if (i == 1 && j == 1) continue;
                        if (states[i][0][j] == null) {
                            states[i][0][j] = Hooks.getFromCache(chunks, world, pos.func_177982_a(i - 1, 0, j - 1), originX, originZ, Chunk::func_177435_g);
                        }
                        if (states[i][1][j] == null) {
                            states[i][1][j] = Hooks.getFromCache(chunks, world, pos.func_177982_a(i - 1, -densityDir, j - 1), originX, originZ, Chunk::func_177435_g);
                        }
                        if (fluids[i][0][j] == null) {
                            fluids[i][0][j] = Hooks.getFluidFromCache(chunks, world, pos.func_177982_a(i - 1, 0, j - 1), originX, originZ, states[i][0][j]);
                        }
                        if (fluids[i][1][j] == null) {
                            fluids[i][1][j] = Hooks.getFluidFromCache(chunks, world, pos.func_177982_a(i - 1, -densityDir, j - 1), originX, originZ, states[i][1][j]);
                        }
                        height[i][j] = Hooks.getFluidHeightForRender(chunks, world, pos, states, fluids, i, j, densityFace, quantaPerBlock, quantaPerBlockFloat, quantaFraction, originX, originZ);
                    }
                }
                for (i = 0; i < 2; ++i) {
                    for (j = 0; j < 2; ++j) {
                        corner[i][j] = Hooks.getFluidHeightAverage(quantaFraction, height[i][j], height[i][j + 1], height[i + 1][j], height[i + 1][j + 1]);
                    }
                }
            }
            if (fluid.getOverlay() != null) {
                for (i = 0; i < 4; ++i) {
                    EnumFacing side = EnumFacing.func_176731_b((int)i);
                    BlockPos offset = pos.func_177972_a(side);
                    IBlockState neighbor = Hooks.getOrSet(states, () -> Hooks.getFromCache(chunks, world, offset, originX, originZ, Chunk::func_177435_g), side.func_82601_c() + 1, side.func_82599_e() + 1);
                    state.withProperty(BlockFluidBase.SIDE_OVERLAYS[i], neighbor.func_193401_d(world, offset, side.func_176734_d()) == BlockFaceShape.SOLID);
                }
            }
            if (!FluidloggedUtils.canFluidFlow(world, pos, states[1][0][1], densityFace)) {
                if (corner[0][0] == 1.0f) {
                    corner[0][0] = 0.998f;
                }
                if (corner[0][1] == 1.0f) {
                    corner[0][1] = 0.998f;
                }
                if (corner[1][0] == 1.0f) {
                    corner[1][0] = 0.998f;
                }
                if (corner[1][1] == 1.0f) {
                    corner[1][1] = 0.998f;
                }
            }
            Hooks.withPropertyFallback(state, BlockFluidBase.LEVEL_CORNERS[0], corner[0][0], quantaFraction);
            Hooks.withPropertyFallback(state, BlockFluidBase.LEVEL_CORNERS[1], corner[0][1], quantaFraction);
            Hooks.withPropertyFallback(state, BlockFluidBase.LEVEL_CORNERS[2], corner[1][1], quantaFraction);
            Hooks.withPropertyFallback(state, BlockFluidBase.LEVEL_CORNERS[3], corner[1][0], quantaFraction);
            return state;
        }

        public static float getFluidHeightForRender(@Nonnull Chunk[][] chunks, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState[][][] states, @Nonnull FluidState[][][] fluids, int i, int j, EnumFacing densityFace, int quantaPerBlock, float quantaPerBlockFloat, float quantaFraction, int originX, int originZ) {
            EnumFacing[] faces = FACES[j * 3 + i];
            if (Hooks.connectToVertical(chunks, states, fluids, world, pos, densityFace, i, j, faces, originX, originZ)) {
                return 1.0f;
            }
            if (Hooks.connectToHorizontal(chunks, states, fluids, world, pos, i, j, faces, originX, originZ)) {
                if (states[i][0][j].func_177230_c().isAir(states[i][0][j], world, pos.func_177982_a(i - 1, 0, j - 1))) {
                    return 0.0f;
                }
                if (FluidloggedUtils.isCompatibleFluid(fluids[1][0][1].getFluid(), fluids[i][0][j].getFluid())) {
                    int lowest = Hooks.capLowest(fluids[i][0][j].getLevel());
                    if (lowest == 0) {
                        return quantaFraction;
                    }
                    if (faces.length > 1) {
                        for (EnumFacing facing : faces) {
                            EnumFacing other = faces[facing.func_82601_c() != 0 ? 0 : 1];
                            BlockPos offset = pos.func_177972_a(facing);
                            IBlockState neighbor = Hooks.getOrSet(states, () -> Hooks.getFromCache(chunks, world, offset, originX, originZ, Chunk::func_177435_g), facing);
                            if ((!FluidloggedUtils.canFluidFlow(world, pos, states[1][0][1], other) || !FluidloggedUtils.canFluidFlow(world, pos.func_177972_a(other), Hooks.getOrSet(states, () -> Hooks.getFromCache(chunks, world, pos.func_177972_a(other), originX, originZ, Chunk::func_177435_g), other), other.func_176734_d())) && FluidloggedUtils.canFluidFlow(world, pos, states[1][0][1], facing) && FluidloggedUtils.canFluidFlow(world, offset, neighbor, facing.func_176734_d()) && FluidloggedUtils.canFluidFlow(world, offset, neighbor, other) && FluidloggedUtils.canFluidFlow(world, pos.func_177982_a(i - 1, 0, j - 1), states[i][0][j], other.func_176734_d()) && FluidloggedUtils.isCompatibleFluid(fluids[1][0][1].getFluid(), Hooks.getOrSet(fluids, () -> Hooks.getFluidFromCache(chunks, world, offset, originX, originZ, neighbor), facing).getFluid()) && FluidloggedUtils.canFluidFlow(world, pos.func_177982_a(i - 1, 0, j - 1), states[i][0][j], facing.func_176734_d()) && FluidloggedUtils.canFluidFlow(world, pos.func_177972_a(other), Hooks.getOrSet(states, () -> Hooks.getFromCache(chunks, world, pos.func_177972_a(other), originX, originZ, Chunk::func_177435_g), other), facing) && FluidloggedUtils.isCompatibleFluid(fluids[1][0][1].getFluid(), Hooks.getOrSet(fluids, () -> Hooks.getFluidFromCache(chunks, world, pos.func_177972_a(other), originX, originZ, Hooks.get(states, other)), other).getFluid()) && lowest > Hooks.get(fluids, other).getLevel() && (lowest = Hooks.capLowest(Hooks.get(fluids, other).getLevel())) == 0) break;
                        }
                    }
                    return (float)(quantaPerBlock - lowest) / quantaPerBlockFloat * quantaFraction;
                }
            }
            return -1.0f;
        }

        public static int capLowest(int lowest) {
            return lowest >= 8 ? 0 : lowest;
        }

        public static float getFluidHeightAverage(float quantaFraction, float ... heights) {
            float total = 0.0f;
            int count = 0;
            for (float height : heights) {
                if (height == 1.0f) {
                    return 1.0f;
                }
                if (height >= quantaFraction) {
                    total += height * 10.0f;
                    count += 10;
                }
                if (!(height >= 0.0f)) continue;
                total += height;
                ++count;
            }
            return total / (float)count;
        }

        public static boolean connectToVertical(@Nonnull Chunk[][] chunks, @Nonnull IBlockState[][][] states, @Nonnull FluidState[][][] fluids, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing densityFace, int i, int j, @Nonnull EnumFacing[] sides, int originX, int originZ) {
            return FluidloggedUtils.isCompatibleFluid(fluids[1][0][1].getFluid(), fluids[i][1][j].getFluid()) && FluidloggedUtils.isCompatibleFluid(fluids[1][0][1].getFluid(), fluids[i][0][j].getFluid()) && FluidloggedUtils.canFluidFlow(world, pos.func_177982_a(i - 1, 0, j - 1), states[i][0][j], densityFace) && FluidloggedUtils.canFluidFlow(world, pos.func_177982_a(i - 1, -densityFace.func_96559_d(), j - 1), states[i][1][j], densityFace.func_176734_d()) && Hooks.connectToHorizontal(chunks, states, fluids, world, pos, i, j, sides, originX, originZ);
        }

        public static boolean connectToHorizontal(@Nonnull Chunk[][] chunks, @Nonnull IBlockState[][][] states, @Nonnull FluidState[][][] fluids, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, int i, int j, @Nonnull EnumFacing[] sides, int originX, int originZ) {
            boolean diagonal = sides.length > 1;
            for (EnumFacing facing : sides) {
                if (diagonal) {
                    EnumFacing other = sides[facing.func_82601_c() != 0 ? 0 : 1];
                    BlockPos offset = pos.func_177972_a(facing);
                    IBlockState neighbor = Hooks.getOrSet(states, () -> Hooks.getFromCache(chunks, world, offset, originX, originZ, Chunk::func_177435_g), facing);
                    if (!FluidloggedUtils.canFluidFlow(world, pos, states[1][0][1], facing) || !FluidloggedUtils.canFluidFlow(world, offset, neighbor, facing.func_176734_d()) || !FluidloggedUtils.canFluidFlow(world, offset, neighbor, other) || !FluidloggedUtils.canFluidFlow(world, pos.func_177982_a(i - 1, 0, j - 1), states[i][0][j], other.func_176734_d()) || !FluidloggedUtils.isCompatibleFluid(fluids[1][0][1].getFluid(), Hooks.getOrSet(fluids, () -> Hooks.getFluidFromCache(chunks, world, offset, originX, originZ, neighbor), facing).getFluid())) continue;
                    return true;
                }
                if (FluidloggedUtils.canFluidFlow(world, pos, states[1][0][1], facing) && FluidloggedUtils.canFluidFlow(world, pos.func_177972_a(facing), states[i][0][j], facing.func_176734_d())) continue;
                return false;
            }
            return !diagonal;
        }

        @Nonnull
        public static <T> T get(@Nonnull T[][][] values, @Nonnull EnumFacing facing) {
            return values[facing.func_82601_c() + 1][0][facing.func_82599_e() + 1];
        }

        @Nonnull
        public static <T> T getOrSet(@Nonnull T[][][] values, @Nonnull Supplier<T> fallback, @Nonnull EnumFacing facing) {
            return Hooks.getOrSet(values, fallback, facing.func_82601_c() + 1, facing.func_82599_e() + 1);
        }

        @Nonnull
        public static <T> T getOrSet(@Nonnull T[][][] values, @Nonnull Supplier<T> fallback, int i, int j) {
            if (values[i][0][j] != null) {
                return values[i][0][j];
            }
            T t = fallback.get();
            values[i][0][j] = t;
            return t;
        }

        @Nonnull
        public static <T> T getFromCache(@Nonnull Chunk[][] chunks, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, int originX, int originZ, @Nonnull BiFunction<Chunk, BlockPos, T> func) {
            int z;
            int x = (pos.func_177958_n() >> 4) - originX + 1;
            Chunk chunk = chunks[x][z = (pos.func_177952_p() >> 4) - originZ + 1];
            if (chunk == null) {
                chunks[x][z] = IChunkProvider.getChunk(world, pos);
                chunk = chunks[x][z];
            }
            return func.apply(chunk, pos);
        }

        @Nonnull
        public static FluidState getFluidFromCache(@Nonnull Chunk[][] chunks, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, int originX, int originZ, @Nonnull IBlockState state) {
            return Hooks.getFromCache(chunks, world, pos, originX, originZ, (chunk, posIn) -> FluidloggedUtils.isFluid(state) ? FluidState.of(state) : FluidState.getFromProvider((ICapabilityProvider)chunk, posIn));
        }

        public static void withPropertyFallback(@Nonnull IExtendedBlockState state, @Nonnull PropertyFloat property, float value, float quantaFraction) {
            state.withProperty((IUnlistedProperty)property, (Object)Float.valueOf(property.isValid(Float.valueOf(value)) ? value : quantaFraction));
        }

        @Nonnull
        public static Vec3d getFluidFlowVector(@Nonnull BlockFluidBase block, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, int densityDir, int quantaPerBlock) {
            IBlockState here = world.func_180495_p(pos);
            Vec3d vec = Vec3d.field_186680_a;
            int decay = ((Accessor)block).getFlowDecay_Public(world, pos);
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                int power;
                BlockPos offset;
                if (!FluidloggedUtils.canFluidFlow(world, pos, here, facing) || !FluidloggedUtils.canFluidFlow(world, offset = pos.func_177972_a(facing), world.func_180495_p(offset), facing.func_176734_d())) continue;
                int otherDecay = ((Accessor)block).getFlowDecay_Public(world, offset);
                if (otherDecay >= quantaPerBlock) {
                    otherDecay = ((Accessor)block).getFlowDecay_Public(world, offset.func_177981_b(densityDir));
                    if (otherDecay >= quantaPerBlock) continue;
                    power = otherDecay - (decay - quantaPerBlock);
                    vec = vec.func_72441_c((double)(facing.func_82601_c() * power), 0.0, (double)(facing.func_82599_e() * power));
                    continue;
                }
                power = otherDecay - decay;
                vec = vec.func_72441_c((double)(facing.func_82601_c() * power), 0.0, (double)(facing.func_82599_e() * power));
            }
            return vec.func_72432_b();
        }

        @Nonnull
        public static Vec3d getFluidFogColor(@Nonnull BlockFluidBase block, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Entity entity, @Nonnull Vec3d originalColor, float partialTicks) {
            boolean isWithinFluid = FluidloggedAPIConfigHandler.fancyFluidEntityCollision ? Hooks.isWithinFluid((Block)block, (IBlockAccess)world, pos, ActiveRenderInfo.func_178806_a((Entity)entity, (double)((double)partialTicks)).field_72448_b, state) : Hooks.isWithinFluid((Block)block, (IBlockAccess)world, pos, ActiveRenderInfo.func_178806_a((Entity)entity, (double)partialTicks), (IExtendedBlockState)block.getExtendedState(state, (IBlockAccess)world, pos));
            if (isWithinFluid) {
                int color = block.getFluid().getColor();
                float red = (float)(color >> 16 & 0xFF) / 255.0f;
                float green = (float)(color >> 8 & 0xFF) / 255.0f;
                float blue = (float)(color & 0xFF) / 255.0f;
                return new Vec3d((double)red, (double)green, (double)blue);
            }
            return originalColor;
        }

        @Nonnull
        public static IBlockState getStateAtViewpoint(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Vec3d viewpoint) {
            IBlockState here = world.func_180495_p(pos);
            return here == state ? Blocks.field_150350_a.func_176223_P() : here.func_177230_c().getStateAtViewpoint(here, world, pos, viewpoint);
        }

        public static boolean hasVerticalFlow(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull Fluid fluid, int densityDir) {
            IBlockState state;
            EnumFacing facing;
            EnumFacing enumFacing = facing = densityDir < 0 ? EnumFacing.UP : EnumFacing.DOWN;
            if (!FluidloggedUtils.canFluidFlow(world, pos, world.func_180495_p(pos), facing)) {
                return false;
            }
            BlockPos offset = pos.func_177979_c(densityDir);
            return FluidloggedUtils.canFluidFlow(world, offset, state = world.func_180495_p(offset), facing.func_176734_d()) && FluidloggedUtils.isCompatibleFluid(FluidloggedUtils.getFluidState(world, offset, state).getFluid(), fluid);
        }

        @Nullable
        public static Boolean isAABBInsideMaterial(@Nonnull Block block, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB boundingBox, @Nonnull Material materialIn) {
            return materialIn != block.func_176223_P().func_185904_a() ? null : block.isAABBInsideLiquid(world, pos, boundingBox);
        }

        @Nullable
        public static Boolean isEntityInsideFluid(@Nonnull Block block, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Entity entity, double yToTest, @Nonnull Material materialIn, boolean testingHead) {
            if (materialIn != state.func_185904_a() || !(state instanceof IExtendedBlockState)) {
                return null;
            }
            if (!testingHead) {
                return Hooks.isWithinFluid(block, world, pos, entity.func_174813_aQ());
            }
            AxisAlignedBB bb = entity.func_174813_aQ().func_191500_a(new AxisAlignedBB(pos));
            if (!FluidloggedAPIConfigHandler.fancyFluidEntityCollision) {
                return Hooks.isWithinFluid(block, world, pos, bb.field_72338_b, state);
            }
            IBlockState extendedState = block.getExtendedState(state, world, pos);
            return !(extendedState instanceof IExtendedBlockState) || Hooks.isWithinFluid(block, world, pos, new Vec3d(entity.field_70165_t, yToTest, entity.field_70161_v), (IExtendedBlockState)extendedState);
        }

        public static boolean isWithinFluid(@Nonnull Block block, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB bb) {
            bb = bb.func_191500_a(new AxisAlignedBB(pos));
            IBlockState state = FluidloggedUtils.getFluidOrReal(world, pos);
            if (!(state instanceof IExtendedBlockState)) {
                return true;
            }
            if (!FluidloggedAPIConfigHandler.fancyFluidEntityCollision) {
                return Hooks.isWithinFluid(block, world, pos, bb.field_72338_b, state);
            }
            IExtendedBlockState extendedState = (IExtendedBlockState)block.getExtendedState(state, world, pos);
            return Hooks.isWithinFluid(block, world, pos, new Vec3d(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c), extendedState) || Hooks.isWithinFluid(block, world, pos, new Vec3d(bb.field_72340_a, bb.field_72338_b, bb.field_72334_f), extendedState) || Hooks.isWithinFluid(block, world, pos, new Vec3d(bb.field_72336_d, bb.field_72338_b, bb.field_72339_c), extendedState) || Hooks.isWithinFluid(block, world, pos, new Vec3d(bb.field_72336_d, bb.field_72338_b, bb.field_72334_f), extendedState);
        }

        public static boolean isWithinFluid(@Nonnull Block block, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull Vec3d entityVec, @Nonnull IExtendedBlockState state) {
            float[][] corners = new float[2][2];
            corners[0][0] = ((Float)state.getValue((IUnlistedProperty)BlockFluidBase.LEVEL_CORNERS[0])).floatValue();
            corners[0][1] = ((Float)state.getValue((IUnlistedProperty)BlockFluidBase.LEVEL_CORNERS[1])).floatValue();
            corners[1][1] = ((Float)state.getValue((IUnlistedProperty)BlockFluidBase.LEVEL_CORNERS[2])).floatValue();
            corners[1][0] = ((Float)state.getValue((IUnlistedProperty)BlockFluidBase.LEVEL_CORNERS[3])).floatValue();
            double x = entityVec.field_72450_a - (double)pos.func_177958_n();
            double z = entityVec.field_72449_c - (double)pos.func_177952_p();
            if (x < 0.0) {
                x += 1.0;
            }
            if (z < 0.0) {
                z += 1.0;
            }
            double dif1 = Math.sqrt(2.0) - Hooks.distance(0.0, x, 0.0, z);
            double dif2 = Math.sqrt(2.0) - Hooks.distance(0.0, x, 1.0, z);
            double dif3 = Math.sqrt(2.0) - Hooks.distance(1.0, x, 1.0, z);
            double dif4 = Math.sqrt(2.0) - Hooks.distance(1.0, x, 0.0, z);
            return Hooks.isWithinFluid(block, pos, entityVec.field_72448_b, ((double)corners[0][0] * dif1 + (double)corners[0][1] * dif2 + (double)corners[1][1] * dif3 + (double)corners[1][0] * dif4) / (dif1 + dif2 + dif3 + dif4));
        }

        public static double distance(double x1, double x2, double z1, double z2) {
            double distX = Math.max(x1, x2) - Math.min(x1, x2);
            double distZ = Math.max(z1, z2) - Math.min(z1, z2);
            return Math.sqrt(distX * distX + distZ * distZ);
        }

        public static boolean isWithinFluid(@Nonnull Block block, @Nonnull BlockPos pos, double yToCheck, double fluidHeight) {
            return block instanceof BlockFluidBase && ((BlockFluidBase)block).getDensity() < 0 ? yToCheck > (double)pos.func_177956_o() - fluidHeight + 1.0 : yToCheck < (double)pos.func_177956_o() + fluidHeight;
        }

        public static boolean isWithinFluid(@Nonnull Block block, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, double yToCheck, @Nonnull IBlockState state) {
            if (block instanceof BlockLiquid) {
                return Hooks.isWithinFluid(block, pos, yToCheck, Hooks.applyQolOffset(PluginBlockLiquid.Hooks.getBlockLiquidHeight(state, world, pos)));
            }
            return world instanceof World && block instanceof IFluidBlock && Hooks.isWithinFluid(block, pos, yToCheck, Hooks.applyQolOffset(((IFluidBlock)block).getFilledPercentage((World)world, pos)));
        }

        public static double applyQolOffset(double fluidHeight) {
            double qolOffset = 0.015;
            return (double)((int)fluidHeight) == fluidHeight ? fluidHeight : fluidHeight - 0.015;
        }

        public static boolean shouldFluidSideBeRendered(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, int densityDir) {
            if (!FluidloggedUtils.canFluidFlow(world, pos, world.func_180495_p(pos), side)) {
                return true;
            }
            IBlockState neighbor = world.func_180495_p(pos.func_177972_a(side));
            Fluid fluid = FluidloggedUtils.getFluidFromState(state);
            if (FluidloggedUtils.isCompatibleFluid(fluid, FluidloggedUtils.getFluidFromState(neighbor))) {
                return false;
            }
            if (side != (densityDir > 0 ? EnumFacing.DOWN : EnumFacing.UP) && neighbor.doesSideBlockRendering(world, pos.func_177972_a(side), side.func_176734_d())) {
                return false;
            }
            return !FluidloggedUtils.canFluidFlow(world, pos.func_177972_a(side), neighbor, side.func_176734_d()) || !FluidloggedUtils.isCompatibleFluid(FluidloggedUtils.getFluidState(world, pos.func_177972_a(side), neighbor).getFluid(), fluid);
        }

        public static float applyQuantaFraction(float remaining, float quantaFraction) {
            return (float)((int)remaining) == remaining ? remaining : remaining * quantaFraction;
        }
    }
}

