/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.api.util;

import git.jbredwards.fluidlogged_api.api.asm.impl.ICanFluidFlowHandler;
import git.jbredwards.fluidlogged_api.api.block.IFluidloggable;
import git.jbredwards.fluidlogged_api.api.block.IFluidloggableFluid;
import git.jbredwards.fluidlogged_api.api.capability.IFluidStateCapability;
import git.jbredwards.fluidlogged_api.api.event.FluidloggableEvent;
import git.jbredwards.fluidlogged_api.api.event.FluidloggedEvent;
import git.jbredwards.fluidlogged_api.api.fluid.ICompatibleFluid;
import git.jbredwards.fluidlogged_api.api.network.FluidloggedAPINetworkHandler;
import git.jbredwards.fluidlogged_api.api.network.MessageUtils;
import git.jbredwards.fluidlogged_api.api.network.message.MessageFluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class FluidloggedUtils {
    @Nonnull
    public static FluidState getFluidState(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return FluidloggedUtils.getFluidState(world, pos, world.func_180495_p(pos));
    }

    @Nonnull
    public static FluidState getFluidState(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState here) {
        return FluidloggedUtils.isFluid(here) ? FluidState.of(here) : FluidState.get(world, pos);
    }

    @Nonnull
    public static IBlockState getFluidOrReal(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return FluidloggedUtils.getFluidOrReal(world, pos, world.func_180495_p(pos));
    }

    @Nonnull
    public static IBlockState getFluidOrReal(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState here) {
        if (FluidloggedUtils.isFluid(here)) {
            return here;
        }
        FluidState fluidState = FluidState.get(world, pos);
        return fluidState.isEmpty() ? here : fluidState.getState();
    }

    public static boolean setFluidState(@Nonnull World world, @Nonnull BlockPos pos, @Nullable IBlockState here, @Nonnull FluidState fluidState, boolean checkVaporize) {
        return FluidloggedUtils.setFluidState(world, pos, here, fluidState, checkVaporize, true, 11);
    }

    public static boolean setFluidState(@Nonnull World world, @Nonnull BlockPos pos, @Nullable IBlockState here, @Nonnull FluidState fluidState, boolean checkVaporize, boolean doRenderUpdate, int blockFlags) {
        EnumActionResult result;
        FluidloggedEvent event;
        if (world.func_189509_E(pos) || world.func_175624_G() == WorldType.field_180272_g) {
            return false;
        }
        Chunk chunk = world.func_175726_f(pos);
        if (here == null) {
            here = chunk.func_177435_g(pos);
        }
        int precipitationIndex = (pos.func_177952_p() & 0xF) << 4 | pos.func_177958_n() & 0xF;
        if (pos.func_177956_o() >= chunk.field_76638_b[precipitationIndex] - 1) {
            chunk.field_76638_b[precipitationIndex] = -999;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)(event = new FluidloggedEvent(world, chunk, pos, here, fluidState, checkVaporize, blockFlags))) && event.getResult() != Event.Result.DEFAULT) {
            return event.getResult() == Event.Result.ALLOW;
        }
        if (event.doesVaporize()) {
            event.fluidState.getFluid().vaporize(null, world, pos, event.getFluidStack());
            return true;
        }
        if (here.func_177230_c() instanceof IFluidloggable && (result = ((IFluidloggable)here.func_177230_c()).onFluidChange(world, pos, here, event.fluidState, event.blockFlags)) != EnumActionResult.PASS) {
            return result == EnumActionResult.SUCCESS;
        }
        FluidloggedUtils.setFluidState_Internal(world, chunk, here, pos, event.fluidState, doRenderUpdate, event.blockFlags);
        return true;
    }

    public static void setFluidState_Internal(@Nonnull World world, @Nonnull Chunk chunk, @Nonnull IBlockState here, @Nonnull BlockPos pos, @Nonnull FluidState fluidState, boolean doRenderUpdate, int blockFlags) {
        IFluidStateCapability cap = IFluidStateCapability.get((ICapabilityProvider)chunk);
        if (cap == null) {
            throw new NullPointerException("There was a critical internal error involving the Fluidlogged API mod, notify the mod author!");
        }
        if (world.field_72995_K) {
            if (!fluidState.isEmpty()) {
                cap.getContainer(pos).setFluidState(pos, fluidState);
            }
        } else {
            cap.getContainer(pos).setFluidState(pos, fluidState);
            if ((blockFlags & 2) != 0) {
                MessageUtils.sendToAllTracking((IMessage)new MessageFluidState(pos, fluidState, doRenderUpdate), chunk, FluidloggedAPINetworkHandler.INSTANCE);
            }
            FluidloggedUtils.relightFluidBlock(world, pos, fluidState);
            if (!fluidState.isEmpty()) {
                fluidState.getBlock().func_176213_c(world, pos, fluidState.getState());
            }
        }
        if (world.func_175648_a(pos, 1, false) && (blockFlags & 1) != 0) {
            world.markAndNotifyBlock(pos, chunk, here, here, blockFlags);
        }
    }

    public static void relightFluidBlock(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull FluidState fluidState) {
        if (!world.func_175648_a(pos, 16, false)) {
            return;
        }
        Chunk chunk = world.func_175726_f(pos);
        int x = pos.func_177958_n() & 0xF;
        int z = pos.func_177952_p() & 0xF;
        int height = chunk.func_76611_b(x, z);
        if (!fluidState.isEmpty() && fluidState.getState().getLightOpacity((IBlockAccess)world, pos) > 0) {
            if (pos.func_177956_o() >= height) {
                chunk.func_76615_h(x, pos.func_177956_o() + 1, z);
            }
        } else if (pos.func_177956_o() == height - 1) {
            chunk.func_76615_h(x, pos.func_177956_o(), z);
        }
        if (chunk.func_177413_a(EnumSkyBlock.SKY, pos) > 0 || chunk.func_177413_a(EnumSkyBlock.BLOCK, pos) > 0) {
            chunk.func_76595_e(x, z);
        }
        world.field_72984_F.func_76320_a("checkLight");
        world.func_175664_x(pos);
        world.field_72984_F.func_76319_b();
    }

    public static void notifyFluids(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull FluidState fluidState, boolean notifyHere, EnumFacing ... except) {
        EnumSet<EnumFacing> set = EnumSet.allOf(EnumFacing.class);
        if (except != null) {
            Arrays.asList(except).forEach(set::remove);
        }
        if (ForgeEventFactory.onNeighborNotify((World)world, (BlockPos)pos, (IBlockState)fluidState.getState(), set, (boolean)false).isCanceled()) {
            return;
        }
        if (notifyHere && !fluidState.isEmpty()) {
            fluidState.getState().func_189546_a(world, pos, fluidState.getBlock(), pos);
        }
        for (EnumFacing facing : set) {
            BlockPos offset = pos.func_177972_a(facing);
            FluidState neighbor = FluidloggedUtils.getFluidState((IBlockAccess)world, offset);
            if (neighbor.isEmpty()) continue;
            neighbor.getState().func_189546_a(world, offset, fluidState.getBlock(), pos);
        }
    }

    public static boolean canFluidFlow(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState here, @Nonnull EnumFacing side) {
        ICanFluidFlowHandler override = ICanFluidFlowHandler.Accessor.getOverride(here.func_177230_c());
        if (override != null) {
            return override.canFluidFlow(world, pos, here, side);
        }
        return here.func_177230_c() instanceof IFluidloggable ? ((IFluidloggable)here.func_177230_c()).canFluidFlow(world, pos, here, side) : here.func_193401_d(world, pos, side) != BlockFaceShape.SOLID;
    }

    public static boolean isCompatibleFluid(@Nullable Fluid fluid1, @Nullable Fluid fluid2) {
        if (fluid1 == null || fluid2 == null) {
            return false;
        }
        return fluid1.equals(fluid2) || fluid1 instanceof ICompatibleFluid && ((ICompatibleFluid)fluid1).isCompatibleFluid(fluid2) || fluid2 instanceof ICompatibleFluid && ((ICompatibleFluid)fluid2).isCompatibleFluid(fluid1);
    }

    @Nullable
    public static Fluid getFluidFromState(@Nullable IBlockState fluid) {
        if (fluid == null) {
            return null;
        }
        if (fluid.func_177230_c() instanceof IFluidBlock) {
            return ((IFluidBlock)fluid.func_177230_c()).getFluid();
        }
        Material material = fluid.func_185904_a();
        if (material == Material.field_151586_h) {
            return FluidRegistry.WATER;
        }
        return material == Material.field_151587_i ? FluidRegistry.LAVA : null;
    }

    @Nullable
    public static Fluid getFluidFromBlock(@Nullable Block fluid) {
        if (fluid instanceof IFluidBlock) {
            return ((IFluidBlock)fluid).getFluid();
        }
        if (fluid == null) {
            return null;
        }
        Material material = fluid.func_176223_P().func_185904_a();
        if (material == Material.field_151586_h) {
            return FluidRegistry.WATER;
        }
        return material == Material.field_151587_i ? FluidRegistry.LAVA : null;
    }

    public static boolean isFluid(@Nonnull Block fluid) {
        return FluidloggedUtils.getFluidFromBlock(fluid) != null;
    }

    public static boolean isFluid(@Nonnull IBlockState fluid) {
        return FluidloggedUtils.getFluidFromState(fluid) != null;
    }

    public static boolean isFluidloggableFluid(@Nullable Block fluid) {
        return fluid instanceof IFluidloggableFluid && ((IFluidloggableFluid)fluid).isFluidloggableFluid();
    }

    public static boolean isFluidloggableFluid(@Nonnull IBlockState fluid, @Nonnull World world, @Nonnull BlockPos pos) {
        return fluid.func_177230_c() instanceof IFluidloggableFluid && ((IFluidloggableFluid)fluid.func_177230_c()).isFluidloggableFluid(fluid, world, pos);
    }

    public static boolean isStateFluidloggable(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nullable Fluid fluid) {
        if (FluidloggedUtils.isFluid(state)) {
            return false;
        }
        FluidloggableEvent event = new FluidloggableEvent(state, world, pos, fluid);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() != Event.Result.DEFAULT) {
            return event.getResult() == Event.Result.ALLOW;
        }
        return state.func_177230_c() instanceof IFluidloggable && (fluid != null ? ((IFluidloggable)state.func_177230_c()).isFluidValid(state, world, pos, fluid) : ((IFluidloggable)state.func_177230_c()).isFluidloggable(state, world, pos));
    }
}

