/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.api.asm.impl;

import com.google.common.collect.Lists;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class IFluidStatePrimer {
    @Nonnull
    protected final List<FluidState> keys = Lists.newArrayList((Object[])new FluidState[]{FluidState.EMPTY});
    protected char[] fluidData = new char[65536];

    @Nonnull
    public static IFluidStatePrimer of(@Nonnull Object chunkPrimer) {
        return (IFluidStatePrimer)chunkPrimer;
    }

    @Nonnull
    public FluidState getFluidState(int x, int y, int z) {
        return this.keys.get(this.fluidData[IFluidStatePrimer.getIndex(x, y, z)]);
    }

    public void setFluidState(int x, int y, int z, @Nonnull FluidState fluidState) {
        if (fluidState.isEmpty()) {
            this.fluidData[IFluidStatePrimer.getIndex((int)x, (int)y, (int)z)] = '\u0000';
        } else {
            int indexedState = this.keys.indexOf((Object)fluidState);
            if (indexedState == -1) {
                indexedState = this.keys.size();
                this.keys.add(fluidState);
            }
            this.fluidData[IFluidStatePrimer.getIndex((int)x, (int)y, (int)z)] = (char)indexedState;
        }
    }

    protected static int getIndex(int x, int y, int z) {
        return x << 12 | z << 8 | y;
    }
}

