/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.tag;

import com.github.lunatrius.ingameinfo.reference.Reference;
import com.github.lunatrius.ingameinfo.tag.Tag;
import com.github.lunatrius.ingameinfo.tag.registry.TagRegistry;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.AbstractHorse;

public abstract class TagRiding
extends Tag {
    private static final int TICKS = 20;
    private static final double CONSTANT = 2.1585857519901364;

    @Override
    public String getCategory() {
        return "riding";
    }

    public static void register() {
        TagRegistry.INSTANCE.register(new IsHorse().setName("ridinghorse"));
        TagRegistry.INSTANCE.register(new HorseHealth().setName("horsehealth"));
        TagRegistry.INSTANCE.register(new HorseMaxHealth().setName("horsemaxhealth"));
        TagRegistry.INSTANCE.register(new HorseSpeed().setName("horsespeed"));
        TagRegistry.INSTANCE.register(new HorseJump().setName("horsejumpstrength").setAliases("horsejumpstr"));
    }

    public static class HorseJump
    extends TagRiding {
        private final Map<Double, Double> jumpHeightCache = new HashMap<Double, Double>();

        private double getJumpHeight(AbstractHorse horse) {
            double jumpStrength = horse.func_110215_cj();
            Double height = this.jumpHeightCache.get(jumpStrength);
            if (height != null) {
                return height;
            }
            double jumpHeight = 0.0;
            for (double velocity = jumpStrength; velocity > 0.0; velocity *= 0.98) {
                jumpHeight += velocity;
                velocity -= 0.08;
            }
            if (this.jumpHeightCache.size() > 16) {
                Reference.logger.trace("Clearing horse jump height cache.");
                this.jumpHeightCache.clear();
            }
            this.jumpHeightCache.put(jumpStrength, jumpHeight);
            return jumpHeight;
        }

        @Override
        public String getValue() {
            Entity ridingEntity = player.func_184187_bx();
            if (ridingEntity instanceof AbstractHorse) {
                return String.format(Locale.ENGLISH, "%.3f", this.getJumpHeight((AbstractHorse)ridingEntity));
            }
            return "-1";
        }
    }

    public static class HorseSpeed
    extends TagRiding {
        @Override
        public String getValue() {
            Entity ridingEntity = player.func_184187_bx();
            if (ridingEntity instanceof AbstractHorse) {
                return String.format(Locale.ENGLISH, "%.3f", 43.17171503980273 * ((AbstractHorse)ridingEntity).func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
            }
            return "-1";
        }
    }

    public static class HorseMaxHealth
    extends TagRiding {
        @Override
        public String getValue() {
            Entity ridingEntity = player.func_184187_bx();
            if (ridingEntity instanceof AbstractHorse) {
                return String.valueOf(((AbstractHorse)ridingEntity).func_110138_aP());
            }
            return "-1";
        }
    }

    public static class HorseHealth
    extends TagRiding {
        @Override
        public String getValue() {
            Entity ridingEntity = player.func_184187_bx();
            if (ridingEntity instanceof AbstractHorse) {
                return String.valueOf(((AbstractHorse)ridingEntity).func_110143_aJ());
            }
            return "-1";
        }
    }

    public static class IsHorse
    extends TagRiding {
        @Override
        public String getValue() {
            return String.valueOf(player.func_184187_bx() instanceof AbstractHorse);
        }
    }
}

