/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.client.gui.overlay;

import com.github.lunatrius.core.client.gui.GuiHelper;
import com.github.lunatrius.core.util.vector.Vector2f;
import com.github.lunatrius.ingameinfo.client.gui.overlay.Info;
import com.github.lunatrius.ingameinfo.reference.Reference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class InfoIcon
extends Info {
    private static final TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
    private final ResourceLocation resourceLocation;
    private final Vector2f xy0 = new Vector2f();
    private final Vector2f xy1 = new Vector2f();
    private final Vector2f uv0 = new Vector2f();
    private final Vector2f uv1 = new Vector2f();
    private final double zLevel = 300.0;
    private int displayWidth;
    private int displayHeight;

    public InfoIcon(String location) {
        this(new ResourceLocation(location));
    }

    public InfoIcon(String location, int displayX, int displayY, int displayWidth, int displayHeight, int iconX, int iconY, int iconWidth, int iconHeight, int textureWidth, int textureHeight, int x, int y) {
        this(new ResourceLocation(location), displayX, displayY, displayWidth, displayHeight, iconX, iconY, iconWidth, iconHeight, textureWidth, textureHeight, x, y);
    }

    public InfoIcon(ResourceLocation location) {
        this(location, 0, 0, 8, 8, 0, 0, 8, 8, 8, 8, 0, 0);
    }

    public InfoIcon(ResourceLocation location, int displayX, int displayY, int displayWidth, int displayHeight, int iconX, int iconY, int iconWidth, int iconHeight, int textureWidth, int textureHeight, int x, int y) {
        super(x, y);
        this.resourceLocation = location;
        this.setDisplayDimensions(displayX, displayY, displayWidth, displayHeight);
        this.setTextureData(iconX, iconY, iconWidth, iconHeight, textureWidth, textureHeight);
    }

    public void setDisplayDimensions(int displayX, int displayY, int displayWidth, int displayHeight) {
        this.displayWidth = displayWidth;
        this.displayHeight = displayHeight;
        this.xy0.set((float)displayX, (float)displayY);
        this.xy1.set((float)(displayX + displayWidth), (float)(displayY + displayHeight));
    }

    public void setTextureData(int iconX, int iconY, int iconWidth, int iconHeight, int textureWidth, int textureHeight) {
        this.uv0.set((float)iconX / (float)textureWidth, (float)iconY / (float)textureHeight);
        this.uv1.set((float)(iconX + iconWidth) / (float)textureWidth, (float)(iconY + iconHeight) / (float)textureHeight);
    }

    @Override
    public void drawInfo() {
        try {
            textureManager.func_110577_a(this.resourceLocation);
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            GuiHelper.drawTexturedRectangle((BufferBuilder)buffer, (double)this.xy0.x, (double)this.xy0.y, (double)this.xy1.x, (double)this.xy1.y, (double)this.zLevel, (double)this.uv0.x, (double)this.uv0.y, (double)this.uv1.x, (double)this.uv1.y);
            tessellator.func_78381_a();
            GlStateManager.func_179109_b((float)(-this.getX()), (float)(-this.getY()), (float)0.0f);
        }
        catch (Exception e) {
            Reference.logger.debug((Object)e);
        }
    }

    @Override
    public int getWidth() {
        return this.displayWidth;
    }

    @Override
    public int getHeight() {
        return this.displayHeight;
    }

    @Override
    public String toString() {
        return String.format("InfoIcon{resource: %s, x: %d, y: %d, offsetX: %d, offsetY: %d, children: %s}", this.resourceLocation, this.x, this.y, this.offsetX, this.offsetY, this.children);
    }
}

