/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo;

import java.util.Locale;

public enum Alignment {
    TOPLEFT(2, 2),
    TOPCENTER(0, 2),
    TOPRIGHT(-2, 2),
    MIDDLELEFT(2, 0),
    MIDDLECENTER(0, 0),
    MIDDLERIGHT(-2, 0),
    BOTTOMLEFT(2, -2),
    BOTTOMCENTER(0, -45),
    BOTTOMRIGHT(-2, -2);

    private static final int MASK_X = 12;
    private static final int MASK_Y = 3;
    private static final int TOP = 1;
    private static final int MIDDLE = 3;
    private static final int BOTTOM = 2;
    private static final int LEFT = 4;
    private static final int CENTER = 12;
    private static final int RIGHT = 8;
    private int alignment;
    public final int defaultX;
    public final int defaultY;
    public int x;
    public int y;

    private Alignment(int x, int y) {
        this.defaultX = x;
        this.defaultY = y;
        this.x = x;
        this.y = y;
        this.alignment = 0;
    }

    public static Alignment parse(String str) {
        String value = "";
        if ((str = str.toLowerCase(Locale.ENGLISH)).startsWith("top")) {
            value = "TOP";
        } else if (str.startsWith("mid")) {
            value = "MIDDLE";
        } else if (str.startsWith("bot")) {
            value = "BOTTOM";
        }
        if (str.endsWith("left")) {
            value = value + "LEFT";
        } else if (str.endsWith("center")) {
            value = value + "CENTER";
        } else if (str.endsWith("right")) {
            value = value + "RIGHT";
        }
        try {
            return Alignment.valueOf(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getX(int screenwidth, int textwidth) {
        switch (this.alignment & 0xC) {
            case 4: {
                return this.x;
            }
            case 12: {
                return this.x + (screenwidth - textwidth) / 2;
            }
            case 8: {
                return this.x + screenwidth - textwidth;
            }
        }
        return 0;
    }

    public int getY(int screenheight, int textheight) {
        switch (this.alignment & 3) {
            case 1: {
                return this.y;
            }
            case 3: {
                return this.y + (screenheight - textheight) / 2;
            }
            case 2: {
                return this.y + screenheight - textheight;
            }
        }
        return 0;
    }

    public String getDefaultXY() {
        return String.format("%d %d", this.defaultX, this.defaultY);
    }

    public String getXY() {
        return String.format("%d %d", this.x, this.y);
    }

    public void setXY(String str) {
        try {
            String[] parts = str.split(" ");
            if (parts.length == 2) {
                int x = Integer.parseInt(parts[0]);
                int y = Integer.parseInt(parts[1]);
                this.x = x;
                this.y = y;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        Alignment.TOPLEFT.alignment = 5;
        Alignment.TOPCENTER.alignment = 13;
        Alignment.TOPRIGHT.alignment = 9;
        Alignment.MIDDLELEFT.alignment = 7;
        Alignment.MIDDLECENTER.alignment = 15;
        Alignment.MIDDLERIGHT.alignment = 11;
        Alignment.BOTTOMLEFT.alignment = 6;
        Alignment.BOTTOMCENTER.alignment = 14;
        Alignment.BOTTOMRIGHT.alignment = 10;
    }
}

