/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.widgets;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.gui.widgets.IWidget;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@SideOnly(value=Side.CLIENT)
public class WScroll
implements IWidget {
    public int xPos;
    public int yPos;
    public int ySize;
    public int current;
    public IWidget.ListenerAction<? super WScroll> listener;
    protected boolean drag;

    public WScroll(int xPos, int yPos, int ySize) {
        this.xPos = xPos;
        this.yPos = yPos;
        this.ySize = ySize;
    }

    @Override
    public void onDraw(JecaGui gui, int xMouse, int yMouse) {
        if (Mouse.isButtonDown((int)0) && this.drag) {
            this.setCurrent(yMouse - this.yPos - 9, true);
        } else {
            this.drag = false;
        }
        gui.drawResourceContinuous(Resource.WGT_SLOT, this.xPos, this.yPos, 14, this.ySize, 3, 3, 3, 3);
        gui.drawResource(Resource.WGT_SCROLL, this.xPos, this.yPos + this.current);
    }

    @Override
    public boolean onClicked(JecaGui gui, int xMouse, int yMouse, int button) {
        this.drag = this.mouseIn(xMouse, yMouse);
        if (this.drag) {
            this.setCurrent(yMouse - this.yPos - 9, true);
        }
        return this.drag;
    }

    private void setCurrent(int pos, boolean notify) {
        this.current = pos;
        if (this.current < 0) {
            this.current = 0;
        }
        if (this.current > this.ySize - 17) {
            this.current = this.ySize - 17;
        }
        if (notify && this.listener != null) {
            this.listener.invoke(this);
        }
    }

    public float getCurrent() {
        return (float)this.current / ((float)this.ySize - 17.0f);
    }

    public void setCurrent(float ratio) {
        this.setCurrent((int)((float)(this.ySize - 17) * ratio), false);
    }

    public boolean mouseIn(int xMouse, int yMouse) {
        return JecaGui.mouseIn(this.xPos + 1, this.yPos + 1, 12, this.ySize - 2, xMouse, yMouse);
    }

    public WScroll setListener(@Nullable IWidget.ListenerAction<? super WScroll> listener) {
        this.listener = listener;
        return this;
    }
}

