/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data.structure;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.LinkedList;
import java.util.List;
import me.towdium.jecalculation.data.structure.IRecord;
import me.towdium.jecalculation.utils.IllegalPositionException;
import net.minecraft.nbt.NBTTagCompound;

public class RecordMath
implements IRecord {
    public static MathContext context = new MathContext(7, RoundingMode.HALF_UP);
    public static final int DOT_NONE = -1;
    static final String KEY_CURRENT = "current";
    static final String KEY_LAST = "last";
    static final String KEY_OPERATOR = "operator";
    static final String KEY_STATE = "state";
    public BigDecimal last;
    public State state;
    public Operator operator;
    String current;

    public RecordMath(State state, Operator operator, BigDecimal last, boolean sign, int dot, List<BigDecimal> numbers) {
        this.state = state;
        this.operator = operator;
        this.last = last;
        StringBuilder sb = new StringBuilder();
        if (!sign) {
            sb.append('-');
        }
        numbers.forEach(i -> sb.append(i.toString()));
        if (dot != -1) {
            sb.insert(sb.length() - dot, '.');
        }
        this.current = sb.toString();
    }

    public RecordMath(NBTTagCompound nbt) {
        this.state = State.values()[nbt.func_74762_e(KEY_STATE)];
        this.operator = Operator.values()[nbt.func_74762_e(KEY_OPERATOR)];
        this.last = nbt.func_74764_b(KEY_LAST) ? new BigDecimal(nbt.func_74779_i(KEY_LAST)) : BigDecimal.ZERO;
        this.current = nbt.func_74779_i(KEY_CURRENT);
    }

    @Override
    public NBTTagCompound serialize() {
        NBTTagCompound ret = new NBTTagCompound();
        ret.func_74778_a(KEY_CURRENT, this.current);
        ret.func_74778_a(KEY_LAST, this.last.toString());
        ret.func_74768_a(KEY_OPERATOR, this.operator.ordinal());
        ret.func_74768_a(KEY_STATE, this.state.ordinal());
        return ret;
    }

    public boolean getSign() {
        return this.current == null || this.current.isEmpty() || this.current.charAt(0) != '-';
    }

    public LinkedList<BigDecimal> getNumbers() {
        LinkedList<BigDecimal> ret = new LinkedList<BigDecimal>();
        if (this.current == null) {
            return ret;
        }
        for (int i = 0; i < this.current.length(); ++i) {
            char ch = this.current.charAt(i);
            if (ch == '-' || ch == '.') continue;
            ret.add(new BigDecimal(ch - 48));
        }
        return ret;
    }

    public int getDot() {
        if (this.current == null) {
            return -1;
        }
        int index = this.current.indexOf(46);
        return index == -1 ? -1 : this.current.length() - index - 1;
    }

    public static enum Operator {
        EQUALS,
        PLUS,
        MINUS,
        TIMES,
        DIVIDE;


        public BigDecimal operate(BigDecimal a, BigDecimal b) {
            switch (this) {
                case PLUS: {
                    return a.add(b);
                }
                case MINUS: {
                    return a.subtract(b);
                }
                case TIMES: {
                    return a.multiply(b);
                }
                case DIVIDE: {
                    return a.divide(b, context);
                }
                case EQUALS: {
                    return b;
                }
            }
            throw new IllegalPositionException();
        }
    }

    public static enum State {
        INPUT,
        OUTPUT,
        ERROR;

    }
}

