/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.network.gregtech;

import gregtech.api.network.IClientExecutor;
import gregtech.api.network.IPacket;
import hellfall.visualores.database.gregtech.GTClientCache;
import hellfall.visualores.database.gregtech.ore.GridPos;
import hellfall.visualores.database.gregtech.ore.OreVeinPosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.network.PacketBuffer;

public class OreProspectToClientPacket
implements IPacket,
IClientExecutor {
    private final List<Integer> dimList;
    private final List<Integer> xList;
    private final List<Integer> zList;
    private final List<Integer> gridXList;
    private final List<Integer> gridZList;
    private final List<String> nameList;

    public OreProspectToClientPacket() {
        this.dimList = new ArrayList<Integer>();
        this.xList = new ArrayList<Integer>();
        this.zList = new ArrayList<Integer>();
        this.gridXList = new ArrayList<Integer>();
        this.gridZList = new ArrayList<Integer>();
        this.nameList = new ArrayList<String>();
    }

    public OreProspectToClientPacket(int dim, int x, int z, int gridX, int gridZ, String name) {
        this.dimList = Collections.singletonList(dim);
        this.xList = Collections.singletonList(x);
        this.zList = Collections.singletonList(z);
        this.gridXList = Collections.singletonList(gridX);
        this.gridZList = Collections.singletonList(gridZ);
        this.nameList = Collections.singletonList(name);
    }

    public OreProspectToClientPacket(List<Integer> dimList, List<Integer> xList, List<Integer> zList, List<Integer> gridXList, List<Integer> gridZList, List<String> nameList) {
        this.dimList = dimList;
        this.xList = xList;
        this.zList = zList;
        this.gridXList = gridXList;
        this.gridZList = gridZList;
        this.nameList = nameList;
    }

    public OreProspectToClientPacket(int dim, List<OreVeinPosition> positions) {
        this();
        for (OreVeinPosition position : positions) {
            this.dimList.add(dim);
            this.xList.add(position.x);
            this.zList.add(position.z);
            this.gridXList.add(GridPos.blockToGridCoords(position.x));
            this.gridZList.add(GridPos.blockToGridCoords(position.z));
            this.nameList.add(position.depositname);
        }
    }

    public void executeClient(NetHandlerPlayClient netHandlerPlayClient) {
        int newVeins = 0;
        for (int i = 0; i < this.dimList.size(); ++i) {
            if (!GTClientCache.instance.addVein(this.dimList.get(i), this.xList.get(i), this.zList.get(i), this.gridXList.get(i), this.gridZList.get(i), this.nameList.get(i))) continue;
            ++newVeins;
        }
        GTClientCache.instance.notifyNewVeins(newVeins);
    }

    public void encode(PacketBuffer packetBuffer) {
        packetBuffer.writeInt(this.dimList.size());
        for (int i = 0; i < this.dimList.size(); ++i) {
            packetBuffer.writeInt(this.dimList.get(i).intValue());
            packetBuffer.writeInt(this.xList.get(i).intValue());
            packetBuffer.writeInt(this.zList.get(i).intValue());
            packetBuffer.writeInt(this.gridXList.get(i).intValue());
            packetBuffer.writeInt(this.gridZList.get(i).intValue());
            packetBuffer.func_180714_a(this.nameList.get(i));
        }
    }

    public void decode(PacketBuffer packetBuffer) {
        int size = packetBuffer.readInt();
        for (int i = 0; i < size; ++i) {
            this.dimList.add(packetBuffer.readInt());
            this.xList.add(packetBuffer.readInt());
            this.zList.add(packetBuffer.readInt());
            this.gridXList.add(packetBuffer.readInt());
            this.gridZList.add(packetBuffer.readInt());
            this.nameList.add(packetBuffer.func_150789_c(Short.MAX_VALUE));
        }
    }
}

