/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.mixins.xaeroworldmap;

import hellfall.visualores.KeyBindings;
import hellfall.visualores.VOConfig;
import hellfall.visualores.map.ButtonState;
import hellfall.visualores.map.GenericMapRenderer;
import hellfall.visualores.map.xaero.SizedTexturedGuiButton;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaero.map.MapProcessor;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiMap;
import xaero.map.gui.ScreenBase;
import xaero.map.misc.Misc;

@Mixin(value={GuiMap.class})
public abstract class GuiMapMixin
extends ScreenBase {
    @Shadow(remap=false)
    private MapProcessor mapProcessor;
    @Shadow(remap=false)
    private double scale;
    @Shadow(remap=false)
    private double cameraX;
    @Shadow(remap=false)
    private double cameraZ;
    @Unique
    private GenericMapRenderer renderer;

    protected GuiMapMixin(GuiScreen parent, GuiScreen escape) {
        super(parent, escape);
    }

    @Inject(method={"initGui"}, at={@At(value="TAIL")})
    private void visualores$injectInitGui(CallbackInfo ci) {
        int startY;
        int startX;
        int yOffset;
        int xOffset;
        switch (VOConfig.client.xmap.direction) {
            case VERTICAL: {
                xOffset = 0;
                yOffset = 1;
                break;
            }
            case HORIZONTAL: {
                xOffset = 1;
                yOffset = 0;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)VOConfig.client.xmap.direction));
            }
        }
        switch (VOConfig.client.xmap.buttonAnchor) {
            case TOP_LEFT: {
                startX = VOConfig.client.xmap.xOffset;
                startY = VOConfig.client.xmap.yOffset;
                break;
            }
            case TOP_CENTER: {
                startX = this.field_146294_l / 2 + VOConfig.client.xmap.xOffset;
                startY = VOConfig.client.xmap.yOffset;
                break;
            }
            case TOP_RIGHT: {
                startX = this.field_146294_l - 20 - VOConfig.client.xmap.xOffset;
                startY = VOConfig.client.xmap.yOffset;
                xOffset = -xOffset;
                break;
            }
            case RIGHT_CENTER: {
                startX = this.field_146294_l - 20 - VOConfig.client.xmap.xOffset;
                startY = this.field_146295_m / 2 + VOConfig.client.xmap.yOffset;
                xOffset = -xOffset;
                yOffset = -yOffset;
                break;
            }
            case BOTTOM_RIGHT: {
                startX = this.field_146294_l - 20 - VOConfig.client.xmap.xOffset;
                startY = this.field_146295_m - 20 - VOConfig.client.xmap.yOffset;
                xOffset = -xOffset;
                yOffset = -yOffset;
                break;
            }
            case BOTTOM_CENTER: {
                startX = this.field_146294_l / 2 + VOConfig.client.xmap.xOffset;
                startY = this.field_146295_m - 20 - VOConfig.client.xmap.yOffset;
                yOffset = -yOffset;
                break;
            }
            case BOTTOM_LEFT: {
                startX = VOConfig.client.xmap.xOffset;
                startY = this.field_146295_m - 20 - VOConfig.client.xmap.yOffset;
                yOffset = -yOffset;
                break;
            }
            case LEFT_CENTER: {
                startX = VOConfig.client.xmap.xOffset;
                startY = this.field_146295_m / 2 + VOConfig.client.xmap.yOffset;
                yOffset = -yOffset;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)VOConfig.client.xmap.buttonAnchor));
            }
        }
        if (VOConfig.client.xmap.buttonAnchor.isCentered()) {
            int totalButtonSize = ButtonState.buttonAmount() * 10;
            if (VOConfig.client.xmap.buttonAnchor.usualDirection().equals((Object)VOConfig.client.xmap.direction)) {
                startX -= xOffset * totalButtonSize;
                startY -= yOffset * totalButtonSize;
                if (xOffset < 0) {
                    startX -= 20;
                }
                if (yOffset < 0) {
                    startY -= 20;
                }
            } else {
                startX -= Math.abs(yOffset) * 10;
                startY -= Math.abs(xOffset) * 10;
            }
        }
        int offset = 0;
        for (ButtonState.Button button : ButtonState.getAllButtons()) {
            SizedTexturedGuiButton mapButton = new SizedTexturedGuiButton(startX + 20 * xOffset * offset, startY + 20 * yOffset * offset, 20, 20, ButtonState.isEnabled(button) ? 16 : 0, 0, 16, 16, new ResourceLocation("visualores", "textures/buttons/" + button.name + ".png"), guiButton -> {
                ButtonState.toggleButton(button);
                this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
            }, () -> new CursorBox("visualores.button." + button.name));
            this.func_189646_b((GuiButton)mapButton);
            ((GuiButton)mapButton).field_146124_l = true;
            ++offset;
        }
        this.renderer = new GenericMapRenderer((GuiScreen)((GuiMap)this));
    }

    @Inject(method={"drawScreen"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GlStateManager;translate(FFF)V")}, slice={@Slice(from=@At(value="INVOKE", target="Lxaero/map/element/MapElementRenderHandler;render(Lxaero/map/gui/GuiMap;DDIIDDDDDFZLxaero/map/element/HoveredMapElementHolder;Lnet/minecraft/client/Minecraft;FLnet/minecraft/client/gui/ScaledResolution;)Lxaero/map/element/HoveredMapElementHolder;", remap=false), to=@At(value="INVOKE", target="Lxaero/map/MapProcessor;getFootprints()Ljava/util/ArrayList;", remap=false))})
    private void visualores$injectDraw(int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci) {
        double rw = (double)this.field_146297_k.field_71443_c / this.scale;
        double rh = (double)this.field_146297_k.field_71440_d / this.scale;
        this.renderer.updateVisibleArea(this.mapProcessor.getMapWorld().getCurrentDimensionId(), (int)(this.cameraX - rw / 2.0), (int)(this.cameraZ - rh / 2.0), (int)rw, (int)rh);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-this.cameraX), (double)(-this.cameraZ), (double)0.0);
        this.renderer.render(this.cameraX, this.cameraZ, this.scale);
        GlStateManager.func_179121_F();
    }

    @Inject(method={"drawScreen"}, at={@At(value="INVOKE", target="Lxaero/map/gui/ScreenBase;drawScreen(IIF)V")})
    private void visualores$injectDrawButtons(int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci) {
        GlStateManager.func_179147_l();
    }

    @Inject(method={"drawScreen"}, at={@At(value="FIELD", opcode=180, target="Lxaero/map/MapProcessor;renderThreadPauseSync:Ljava/lang/Object;", remap=false)}, slice={@Slice(from=@At(value="INVOKE", target="Lxaero/map/gui/GuiMap;renderTooltips(IIF)Z", remap=false))})
    private void visualores$injectTooltip(int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci) {
        this.renderer.updateHovered(scaledMouseX, scaledMouseY, this.cameraX, this.cameraZ, this.scale);
        this.renderer.renderTooltip(scaledMouseX, scaledMouseY);
    }

    @Inject(method={"onInputPress"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void visualores$injectKeyPress(boolean mouse, int code, CallbackInfoReturnable<Boolean> cir) {
        if (Misc.inputMatchesKeyBinding((boolean)mouse, (int)code, (KeyBinding)KeyBindings.action, (IKeyConflictContext)KeyConflictContext.GUI) && this.renderer.onActionKey()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"mapClicked"}, at={@At(value="TAIL")}, remap=false)
    private void visualores$injectMapClicked(int button, int x, int y, CallbackInfo ci) {
        if (button == 0) {
            this.renderer.onClick(x, y);
        }
    }
}

