/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.mixins.journeymap;

import hellfall.visualores.KeyBindings;
import hellfall.visualores.VOConfig;
import hellfall.visualores.map.ButtonState;
import hellfall.visualores.map.journeymap.JourneymapRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import journeymap.client.io.ThemeLoader;
import journeymap.client.model.MapState;
import journeymap.client.properties.FullMapProperties;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.theme.Theme;
import journeymap.client.ui.theme.ThemeToggle;
import journeymap.client.ui.theme.ThemeToolbar;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ITabCompleter;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Fullscreen.class})
public abstract class FullscreenMixin
extends JmUI
implements ITabCompleter {
    @Unique
    private JourneymapRenderer renderer;
    @Shadow(remap=false)
    ThemeToolbar mapTypeToolbar;
    @Shadow(remap=false)
    @Final
    static MapState state;
    @Shadow(remap=false)
    @Final
    static GridRenderer gridRenderer;
    @Shadow(remap=false)
    FullMapProperties fullMapProperties;
    @Unique
    private Map<String, ThemeToggle> buttons;
    @Unique
    private ThemeToolbar overlayToolbar;

    public FullscreenMixin(String title) {
        super(title);
    }

    @Inject(method={"initButtons"}, at={@At(value="FIELD", target="Ljourneymap/client/ui/fullscreen/Fullscreen;mapTypeToolbar:Ljourneymap/client/ui/theme/ThemeToolbar;", opcode=181, shift=At.Shift.AFTER)}, remap=false)
    private void visualores$injectInitButtons(CallbackInfo ci) {
        Theme theme = ThemeLoader.getCurrentTheme();
        this.buttons = new LinkedHashMap<String, ThemeToggle>();
        for (ButtonState.Button button : ButtonState.getAllButtons()) {
            ThemeToggle mapButton = new ThemeToggle(theme, "visualores.button." + button.name, button.name);
            mapButton.setToggled(Boolean.valueOf(ButtonState.isEnabled(button)), false);
            mapButton.setEnabled(true);
            mapButton.addToggleListener((onOffButton, b) -> {
                ButtonState.toggleButton(button);
                return true;
            });
            this.buttons.put(button.name, mapButton);
        }
        ArrayList<ThemeToggle> allButtons = new ArrayList<ThemeToggle>(this.buttons.values());
        Collections.reverse(allButtons);
        if (VOConfig.client.jmap.rightToolbar) {
            this.overlayToolbar = new ThemeToolbar(theme, allButtons.toArray(new Button[0]));
            this.overlayToolbar.setLayout(ButtonList.Layout.Vertical, ButtonList.Direction.RightToLeft);
            this.overlayToolbar.addAllButtons((JmUI)((Fullscreen)this));
        } else {
            this.mapTypeToolbar.reverse();
            this.mapTypeToolbar.reverse().addAll(0, allButtons);
        }
        this.renderer = new JourneymapRenderer((Fullscreen)this);
    }

    @Inject(method={"layoutButtons"}, at={@At(value="TAIL")}, remap=false)
    private void visualores$injectLayoutButtons(CallbackInfo ci) {
        for (String buttonName : this.buttons.keySet()) {
            this.buttons.get(buttonName).setToggled(Boolean.valueOf(ButtonState.isEnabled(buttonName)), false);
        }
        if (VOConfig.client.jmap.rightToolbar) {
            this.overlayToolbar.layoutCenteredVertical(this.field_146294_l - this.overlayToolbar.getHMargin(), this.field_146295_m / 2, false, this.mapTypeToolbar.getToolbarSpec().padding);
        }
    }

    @Redirect(method={"drawMap"}, at=@At(value="INVOKE", target="Ljourneymap/client/render/map/GridRenderer;draw(Ljava/util/List;DDDD)V", ordinal=1), remap=false)
    private void visualores$injectDrawMap(GridRenderer instance, List<? extends DrawStep> drawStepList, double xOffset, double yOffset, double fontScale, double rotation) {
        instance.draw(drawStepList, xOffset, yOffset, fontScale, rotation);
        double scale = Math.pow(2.0, this.fullMapProperties.zoomLevel.get().intValue());
        double rw = (double)this.field_146297_k.field_71443_c / scale;
        double rh = (double)this.field_146297_k.field_71440_d / scale;
        this.renderer.updateVisibleArea(state.getDimension(), (int)(gridRenderer.getCenterBlockX() - xOffset / scale - rw / 2.0), (int)(gridRenderer.getCenterBlockZ() - yOffset / scale - rh / 2.0), (int)rw, (int)rh);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)xOffset, (double)yOffset, (double)0.0);
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)1.0);
        GlStateManager.func_179137_b((double)(rw / 2.0 - gridRenderer.getCenterBlockX()), (double)(rh / 2.0 - gridRenderer.getCenterBlockZ()), (double)0.0);
        this.renderer.render(gridRenderer.getCenterBlockX(), gridRenderer.getCenterBlockZ(), scale);
        GlStateManager.func_179121_F();
    }

    @Inject(method={"drawScreen"}, at={@At(value="INVOKE", target="Ljava/util/List;isEmpty()Z", shift=At.Shift.BY, by=-2)}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private void visualores$injectTooltip(int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci, List<String> tooltip) {
        double scale = Math.pow(2.0, this.fullMapProperties.zoomLevel.get().intValue());
        this.renderer.updateHovered(scaledMouseX, scaledMouseY, gridRenderer.getCenterBlockX(), gridRenderer.getCenterBlockZ(), scale);
        if (tooltip == null || tooltip.isEmpty()) {
            this.renderer.renderTooltip(scaledMouseX, scaledMouseY);
        }
    }

    @Inject(method={"keyTyped"}, at={@At(value="TAIL")})
    private void visualores$injectKeyPress(char c, int key, CallbackInfo ci) {
        if (KeyBindings.action.func_151463_i() == key) {
            this.renderer.onActionKey();
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="INVOKE", target="Ljourneymap/client/ui/fullscreen/layer/LayerDelegate;onMouseClicked(Lnet/minecraft/client/Minecraft;Ljourneymap/client/render/map/GridRenderer;Ljava/awt/geom/Point2D$Double;IF)V", remap=false)}, cancellable=true)
    private void visualores$injectMouseClicked(int mouseX, int mouseY, int mouseButton, CallbackInfo ci) {
        if (mouseButton == 0 && this.renderer.onClick(mouseX, mouseY)) {
            ci.cancel();
        }
    }
}

