/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.map.layers.astralsorcery;

import codechicken.lib.gui.GuiDraw;
import hellfall.visualores.database.astralsorcery.ASClientCache;
import hellfall.visualores.database.astralsorcery.StarfieldPosition;
import hellfall.visualores.map.layers.RenderLayer;
import java.util.ArrayList;
import java.util.List;

public class StarfieldRenderLayer
extends RenderLayer {
    private static final int LOW_COLOR = 1996490298;
    private static final int HIGH_COLOR = -1442835785;
    private List<StarfieldPosition> visibleChunks = new ArrayList<StarfieldPosition>();

    public StarfieldRenderLayer(String key) {
        super(key);
    }

    @Override
    public void render(double cameraX, double cameraZ, double scale) {
        for (StarfieldPosition pos : this.visibleChunks) {
            int bx = pos.x << 4;
            int bz = pos.z << 4;
            for (int i = 0; i < 256; ++i) {
                if (pos.high[i]) {
                    GuiDraw.drawRect((int)(bx + i / 16), (int)(bz + i % 16), (int)1, (int)1, (int)-1442835785);
                    continue;
                }
                if (!pos.low[i]) continue;
                GuiDraw.drawRect((int)(bx + i / 16), (int)(bz + i % 16), (int)1, (int)1, (int)1996490298);
            }
        }
    }

    @Override
    public void updateVisibleArea(int dimensionID, int[] visibleBounds) {
        this.visibleChunks = ASClientCache.instance.getStarfieldsInBounds(dimensionID, visibleBounds);
    }
}

