/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.map;

import hellfall.visualores.VOConfig;
import hellfall.visualores.map.DrawUtils;
import hellfall.visualores.map.layers.Layers;
import hellfall.visualores.map.layers.RenderLayer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GenericMapRenderer {
    private static final int VISIBLE_AREA_PADDING = 20;
    protected int dimensionID;
    protected GuiScreen gui;
    protected int[] visibleBounds = new int[4];
    protected List<RenderLayer> layers = new ArrayList<RenderLayer>();
    private double oldMouseX;
    private double oldMouseY;
    private long timeLastClick;

    public GenericMapRenderer() {
        Layers.addLayersTo(this.layers);
    }

    public GenericMapRenderer(GuiScreen gui) {
        this();
        this.gui = gui;
    }

    public void updateVisibleArea(int dim, int x, int y, int w, int h) {
        if (this.dimensionID != dim || this.visibleBounds[0] != (x -= 20) || this.visibleBounds[1] != (y -= 20) || this.visibleBounds[2] != (w += 40) || this.visibleBounds[3] != (h += 40)) {
            this.dimensionID = dim;
            this.visibleBounds[0] = x;
            this.visibleBounds[1] = y;
            this.visibleBounds[2] = w;
            this.visibleBounds[3] = h;
            for (RenderLayer layer : this.layers) {
                layer.updateVisibleArea(this.dimensionID, this.visibleBounds);
            }
        }
    }

    public void updateHovered(double mouseX, double mouseY, double cameraX, double cameraZ, double scale) {
        ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
        for (RenderLayer layer : this.layers) {
            if (!layer.isEnabled()) continue;
            layer.updateHovered(mouseX * (double)res.func_78325_e(), mouseY * (double)res.func_78325_e(), cameraX, cameraZ, scale);
        }
    }

    public void render(double cameraX, double cameraZ, double scale) {
        for (RenderLayer layer : this.layers) {
            if (!layer.isEnabled()) continue;
            layer.render(cameraX, cameraZ, scale);
        }
    }

    public void renderTooltip(double mouseX, double mouseY) {
        ArrayList<String> tooltip = new ArrayList<String>();
        for (RenderLayer layer : this.layers) {
            List<String> layerTooltip;
            if (!layer.isEnabled() || (layerTooltip = layer.getTooltip()) == null || layerTooltip.isEmpty()) continue;
            if (!tooltip.isEmpty() && VOConfig.client.stackTooltips) {
                tooltip.add(0, "---");
                tooltip.addAll(0, layerTooltip);
                continue;
            }
            tooltip = new ArrayList<String>(layerTooltip);
        }
        this.renderTooltipInternal(tooltip, mouseX, mouseY);
    }

    public boolean onActionKey() {
        for (RenderLayer layer : this.layers) {
            if (!layer.isEnabled() || !layer.onActionKey()) continue;
            return true;
        }
        return false;
    }

    public boolean onClick(double mouseX, double mouseY) {
        long timestamp = System.currentTimeMillis();
        boolean isDoubleClick = mouseX == this.oldMouseX && mouseY == this.oldMouseY && timestamp - this.timeLastClick < 500L;
        this.oldMouseX = mouseX;
        this.oldMouseY = mouseY;
        this.timeLastClick = isDoubleClick ? 0L : timestamp;
        for (RenderLayer layer : this.layers) {
            if (!layer.isEnabled() || (!isDoubleClick || !layer.onDoubleClick()) && (isDoubleClick || !layer.onClick())) continue;
            return true;
        }
        return false;
    }

    protected void renderTooltipInternal(List<String> tooltip, double mouseX, double mouseY) {
        DrawUtils.drawSimpleTooltip(tooltip, mouseX, mouseY, this.gui.field_146294_l, this.gui.field_146295_m, -1, -2046820352);
    }
}

