/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.lib.io.xol.enklume;

import hellfall.visualores.lib.io.xol.enklume.MinecraftRegion;
import hellfall.visualores.lib.io.xol.enklume.nbt.NBTFile;
import hellfall.visualores.lib.io.xol.enklume.nbt.NBTString;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.DataFormatException;

public class MinecraftWorld {
    public static final int OVERWORLD_ID = 0;
    public static final int NETHER_ID = -1;
    public static final int END_ID = 1;
    private final File folder;
    private final NBTFile nbtFile;
    private final String levelName;

    public MinecraftWorld(File folder) throws IOException {
        this.folder = folder;
        File levelDat = new File(this.folder.getAbsolutePath() + "/level.dat");
        assert (levelDat.exists());
        this.nbtFile = new NBTFile(levelDat, NBTFile.CompressionScheme.GZIPPED);
        this.levelName = ((NBTString)this.nbtFile.getRoot().getTag("Data.LevelName")).getText();
    }

    public String getName() {
        return this.levelName;
    }

    public NBTFile getLevelDotDat() {
        return this.nbtFile;
    }

    public static int blockToRegionCoordinates(int blockCoordinates) {
        if (blockCoordinates >= 0) {
            return (int)Math.floor((float)blockCoordinates / 512.0f);
        }
        blockCoordinates = -blockCoordinates;
        return -((int)Math.floor((float)blockCoordinates / 512.0f)) - 1;
    }

    public MinecraftRegion getRegion(int regionCoordinateX, int regionCoordinateZ) throws DataFormatException, IOException {
        return this.getRegion(0, regionCoordinateX, regionCoordinateZ);
    }

    public MinecraftRegion getRegion(int dimensionId, int regionCoordinateX, int regionCoordinateZ) throws DataFormatException, IOException {
        String subfolder = dimensionId == 0 ? "" : "/DIM" + dimensionId;
        File regionFile = new File(this.folder.getAbsolutePath() + subfolder + "/region/r." + regionCoordinateX + "." + regionCoordinateZ + ".mca");
        if (regionFile.exists()) {
            return new MinecraftRegion(regionFile);
        }
        return null;
    }

    public File getRegionFile(int dimensionId, int regionCoordinateX, int regionCoordinateZ) throws DataFormatException, IOException {
        String subfolder = dimensionId == 0 ? "" : "/DIM" + dimensionId;
        File regionFile = new File(this.folder.getAbsolutePath() + subfolder + "/region/r." + regionCoordinateX + "." + regionCoordinateZ + ".mca");
        return regionFile.exists() ? regionFile : null;
    }

    public List<File> getSomeRegionFiles(int dimID, int startX, int startZ, int endX, int endZ) throws DataFormatException, IOException {
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 0; i < endX - startX; ++i) {
            for (int j = 0; j < endZ - startZ; ++j) {
                File file = this.getRegionFile(dimID, startX + i, startZ + j);
                if (file == null) continue;
                files.add(file);
            }
        }
        return files;
    }

    public List<File> getAllRegionFiles(int dimensionId) throws IOException {
        String subfolder = dimensionId == 0 ? "" : "/DIM" + dimensionId;
        File regionFolder = new File(this.folder.getAbsolutePath() + subfolder + "/region");
        if (regionFolder.exists()) {
            return Files.walk(regionFolder.toPath(), 1, new FileVisitOption[0]).filter(path -> path.getFileName().toString().endsWith(".mca")).map(Path::toFile).collect(Collectors.toList());
        }
        return new ArrayList<File>();
    }

    public List<Integer> getDimensionIds() throws IOException {
        List<Integer> dimensionIds = Files.walk(this.folder.toPath(), 1, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(path -> path.getFileName().toString()).filter(path -> path.startsWith("DIM")).map(path -> path.substring(3)).filter(dimensionId -> this.isInteger((String)dimensionId)).map(dimensionId -> Integer.parseInt(dimensionId)).collect(Collectors.toList());
        dimensionIds.add(0);
        return dimensionIds;
    }

    private boolean isInteger(String input) {
        try {
            Integer.parseInt(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

