/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.lib.io.xol.enklume;

import gnu.trove.list.array.TByteArrayList;
import hellfall.visualores.lib.io.xol.enklume.MinecraftChunk;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class MinecraftRegion {
    int[] locations = new int[1024];
    int[] sizes = new int[1024];
    Inflater inflater = new Inflater();
    RandomAccessFile is;
    private final List<SoftReference<MinecraftChunk>> chunks = new ArrayList<SoftReference<MinecraftChunk>>(1024);

    public MinecraftRegion(File regionFile) throws IOException, DataFormatException {
        for (int i = 0; i < 1024; ++i) {
            this.chunks.add(null);
        }
        this.is = new RandomAccessFile(regionFile, "r");
        byte[] buffer = new byte[4096];
        this.is.readFully(buffer);
        for (int i = 0; i < 1024; ++i) {
            this.locations[i] = (buffer[i * 4] & 0xFF) << 16;
            int n = i;
            this.locations[n] = this.locations[n] + ((buffer[i * 4 + 1] & 0xFF) << 8);
            int n2 = i;
            this.locations[n2] = this.locations[n2] + (buffer[i * 4 + 2] & 0xFF);
            this.sizes[i] = buffer[i * 4 + 3] & 0xFF;
        }
        this.is.seek(this.is.getFilePointer() + 4096L);
    }

    final int offset(int x, int z) {
        return (x & 0x1F) + (z & 0x1F) * 32;
    }

    public MinecraftChunk getChunk(int x, int z) {
        MinecraftChunk chunk;
        int idx = 32 * x + z;
        SoftReference<MinecraftChunk> ref = this.chunks.get(idx);
        MinecraftChunk minecraftChunk = chunk = ref == null ? null : ref.get();
        if (chunk == null) {
            try {
                chunk = this.getChunkInternal(x, z);
            }
            catch (IOException | DataFormatException e) {
                throw new RuntimeException(e);
            }
            this.chunks.set(idx, new SoftReference<MinecraftChunk>(chunk));
        }
        return chunk;
    }

    private MinecraftChunk getChunkInternal(int x, int z) throws DataFormatException, IOException {
        int l = this.offset(x, z);
        if (this.sizes[l] > 0) {
            this.is.seek((long)this.locations[l] * 4096L);
            int compressedLength = 0;
            compressedLength += this.is.read() << 24;
            compressedLength += this.is.read() << 16;
            compressedLength += this.is.read() << 8;
            compressedLength += this.is.read();
            int compression = this.is.read();
            if (compression != 2) {
                throw new DataFormatException("Fatal error : compression scheme not Zlib. (" + compression + ") at " + this.is.getFilePointer() + " l = " + l + " s= " + this.sizes[l]);
            }
            byte[] compressedData = new byte[compressedLength];
            this.is.read(compressedData);
            TByteArrayList allBytes = new TByteArrayList();
            this.inflater.reset();
            this.inflater.setInput(compressedData);
            byte[] buffer = new byte[0x100000];
            while (!this.inflater.finished()) {
                int c = this.inflater.inflate(buffer);
                allBytes.add(buffer, 0, c);
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(allBytes.toArray());
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
            return new MinecraftChunk(x, z, byteBuffer);
        }
        return new MinecraftChunk(x, z);
    }

    public void close() throws IOException {
        this.is.close();
        this.inflater.end();
    }
}

