/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.database.thaumcraft;

import hellfall.visualores.database.thaumcraft.AuraFluxPosition;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;

public class TCDimensionCache {
    private final Object2ObjectMap<ChunkPos, AuraFluxPosition> chunks = new Object2ObjectOpenHashMap();

    public void addChunk(short base, float aura, float flux) {
        ChunkPos key = new ChunkPos(Minecraft.func_71410_x().field_71439_g.func_180425_c());
        this.chunks.put((Object)key, (Object)new AuraFluxPosition(base, aura, flux, key.field_77276_a, key.field_77275_b));
    }

    public List<AuraFluxPosition> getVeinsInArea(ChunkPos topLeft, ChunkPos bottomRight) {
        ArrayList<AuraFluxPosition> result = new ArrayList<AuraFluxPosition>();
        for (int i = topLeft.field_77276_a; i <= bottomRight.field_77276_a; ++i) {
            for (int j = topLeft.field_77275_b; j <= bottomRight.field_77275_b; ++j) {
                ChunkPos pos = new ChunkPos(i, j);
                if (!this.chunks.containsKey((Object)pos)) continue;
                result.add((AuraFluxPosition)this.chunks.get((Object)pos));
            }
        }
        return result;
    }

    public void fromNBT(NBTTagCompound nbt) {
        for (String nbtKey : nbt.func_150296_c()) {
            String[] splitpos = nbtKey.split(",");
            ChunkPos key = new ChunkPos(Integer.parseInt(splitpos[0]), Integer.parseInt(splitpos[1]));
            NBTTagCompound chunkNBT = nbt.func_74775_l(nbtKey);
            this.chunks.put((Object)key, (Object)new AuraFluxPosition(chunkNBT.func_74765_d("base"), chunkNBT.func_74760_g("aura"), chunkNBT.func_74760_g("flux"), key.field_77276_a, key.field_77275_b));
        }
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound result = new NBTTagCompound();
        for (ChunkPos key : this.chunks.keySet()) {
            result.func_74782_a(key.field_77276_a + "," + key.field_77275_b, (NBTBase)((AuraFluxPosition)this.chunks.get((Object)key)).toNBT());
        }
        return result;
    }
}

