/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.database.immersiveengineering;

import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import hellfall.visualores.database.IClientCachePerDimOnly;
import hellfall.visualores.database.immersiveengineering.ExcavatorVeinPosition;
import hellfall.visualores.database.immersiveengineering.IEDimensionCache;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;

public class IEClientCache
implements IClientCachePerDimOnly {
    public static final IEClientCache instance = new IEClientCache();
    private final Int2ObjectMap<IEDimensionCache> cache = new Int2ObjectArrayMap();

    public void readCoresampleNBT(ItemStack stack) {
        NBTTagCompound nbt = ItemNBTHelper.getTag((ItemStack)stack);
        if (!nbt.func_74764_b("coords")) {
            return;
        }
        int dim = nbt.func_74759_k("coords")[0];
        if (!this.cache.containsKey(dim)) {
            this.cache.put(dim, (Object)new IEDimensionCache());
        }
        ((IEDimensionCache)this.cache.get(dim)).addVein(stack, nbt);
    }

    public List<ExcavatorVeinPosition> getVeinsInArea(int dim, int[] bounds) {
        if (this.cache.containsKey(dim)) {
            return ((IEDimensionCache)this.cache.get(dim)).getVeinsInArea(new ChunkPos(bounds[0] >> 4, bounds[1] >> 4), new ChunkPos(bounds[0] + bounds[2] >> 4, bounds[1] + bounds[3] >> 4));
        }
        return new ArrayList<ExcavatorVeinPosition>();
    }

    @Override
    public void setupCacheFiles() {
        this.addDimFiles("excavator_");
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public Collection<Integer> getExistingDimensions(String prefix) {
        return this.cache.keySet();
    }

    @Override
    public NBTTagCompound saveDimFile(String prefix, int dim) {
        if (this.cache.containsKey(dim)) {
            return ((IEDimensionCache)this.cache.get(dim)).toNBT();
        }
        return null;
    }

    @Override
    public void readDimFile(String prefix, int dim, NBTTagCompound data) {
        if (!this.cache.containsKey(dim)) {
            this.cache.put(dim, (Object)new IEDimensionCache());
        }
        ((IEDimensionCache)this.cache.get(dim)).fromNBT(data);
    }
}

