/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.database.gregtech.ore;

import gregtech.api.GregTechAPI;
import gregtech.api.network.IPacket;
import gregtech.api.unification.material.Material;
import hellfall.visualores.VOConfig;
import hellfall.visualores.database.gregtech.ore.DimensionCache;
import hellfall.visualores.database.gregtech.ore.OreVeinPosition;
import hellfall.visualores.database.gregtech.ore.ServerCacheSaveData;
import hellfall.visualores.database.gregtech.ore.WorldCache;
import hellfall.visualores.network.gregtech.OreProspectToClientPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class ServerCache
extends WorldCache {
    public static final ServerCache instance = new ServerCache();
    private final Map<Integer, ServerCacheSaveData> saveData = new HashMap<Integer, ServerCacheSaveData>();

    public void maybeInitWorld(World world) {
        int dim = world.field_73011_w.getDimension();
        if (!this.cache.containsKey(dim)) {
            this.cache.put(dim, new DimensionCache());
        }
        if (!this.saveData.containsKey(dim)) {
            this.saveData.put(dim, ServerCacheSaveData.init(world, (DimensionCache)this.cache.get(dim)));
        }
    }

    public void invalidateWorld(World world) {
        int dim = world.field_73011_w.getDimension();
        this.cache.remove(dim);
        this.saveData.remove(dim);
    }

    @Override
    public boolean addVein(int dim, int x, int z, int gridX, int gridZ, String name) {
        boolean added = super.addVein(dim, x, z, gridX, gridZ, name);
        if (added && this.saveData.containsKey(dim)) {
            this.saveData.get(dim).func_76185_a();
        }
        return added;
    }

    @Override
    public void clear() {
        super.clear();
        this.saveData.clear();
    }

    public void prospectSurfaceRockMaterial(int dim, Material material, BlockPos pos, EntityPlayerMP player) {
        this.prospectBySurfaceRockMaterial(dim, material, pos, player, VOConfig.server.gregtech.surfaceRockProspectRange);
    }

    public void prospectBySurfaceRockMaterial(int dim, Material material, BlockPos pos, EntityPlayerMP player, int radius) {
        if (radius < 0) {
            return;
        }
        List<OreVeinPosition> nearbyVeins = this.getNearbyVeins(dim, pos, radius);
        ArrayList<OreVeinPosition> foundVeins = new ArrayList<OreVeinPosition>();
        for (OreVeinPosition nearbyVein : nearbyVeins) {
            if (!material.equals(nearbyVein.veinInfo.surfaceRockMaterial)) continue;
            foundVeins.add(nearbyVein);
        }
        GregTechAPI.networkHandler.sendTo((IPacket)new OreProspectToClientPacket(dim, foundVeins), player);
    }

    @Deprecated
    public void prospectOreBlock(int dim, String materialString, BlockPos pos, EntityPlayerMP player) {
        if (VOConfig.server.gregtech.oreBlockProspectRange < 0) {
            return;
        }
        List<OreVeinPosition> nearbyVeins = this.getNearbyVeins(dim, pos, VOConfig.server.gregtech.oreBlockProspectRange);
        ArrayList<OreVeinPosition> foundVeins = new ArrayList<OreVeinPosition>();
        for (OreVeinPosition nearbyVein : nearbyVeins) {
            if (!nearbyVein.veinInfo.oreMaterialStrings.contains(materialString)) continue;
            foundVeins.add(nearbyVein);
        }
        GregTechAPI.networkHandler.sendTo((IPacket)new OreProspectToClientPacket(dim, foundVeins), player);
    }

    public void prospectByOreMaterial(int dim, Material material, BlockPos origin, EntityPlayerMP player, int radius) {
        if (radius < 0) {
            return;
        }
        String materialString = material.getResourceLocation().toString();
        List<OreVeinPosition> nearbyVeins = this.getNearbyVeins(dim, origin, radius);
        ArrayList<OreVeinPosition> foundVeins = new ArrayList<OreVeinPosition>();
        for (OreVeinPosition nearbyVein : nearbyVeins) {
            if (!nearbyVein.veinInfo.oreMaterialStrings.contains(materialString)) continue;
            foundVeins.add(nearbyVein);
        }
        GregTechAPI.networkHandler.sendTo((IPacket)new OreProspectToClientPacket(dim, foundVeins), player);
    }

    public void prospectByDepositName(int dim, String depositName, BlockPos origin, EntityPlayerMP player, int radius) {
        if (radius < 0) {
            return;
        }
        List<OreVeinPosition> nearbyVeins = this.getNearbyVeins(dim, origin, radius);
        ArrayList<OreVeinPosition> foundVeins = new ArrayList<OreVeinPosition>();
        for (OreVeinPosition nearbyVein : nearbyVeins) {
            if (!nearbyVein.depositname.equals(depositName)) continue;
            foundVeins.add(nearbyVein);
        }
        GregTechAPI.networkHandler.sendTo((IPacket)new OreProspectToClientPacket(dim, foundVeins), player);
    }

    public void prospectAllInChunk(int dim, ChunkPos pos, EntityPlayerMP player) {
        if (this.cache.containsKey(dim)) {
            GregTechAPI.networkHandler.sendTo((IPacket)new OreProspectToClientPacket(dim, ((DimensionCache)this.cache.get(dim)).getVeinsInChunk(pos)), player);
        }
    }

    public void removeAllInChunk(int dim, ChunkPos pos) {
        if (this.cache.containsKey(dim)) {
            ((DimensionCache)this.cache.get(dim)).removeAllInChunk(pos);
        }
    }
}

