/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.database.gregtech.ore;

import hellfall.visualores.database.gregtech.ore.GridPos;
import hellfall.visualores.database.gregtech.ore.OreVeinInfo;
import hellfall.visualores.database.gregtech.ore.VeinInfoCache;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;

public class OreVeinPosition {
    public int x;
    public int z;
    public String depositname;
    public OreVeinInfo veinInfo;
    public boolean depleted;

    public OreVeinPosition(int x, int z, String depositname) {
        this.x = x;
        this.z = z;
        this.depositname = depositname;
        this.veinInfo = VeinInfoCache.getByName(depositname);
        this.depleted = false;
    }

    public NBTTagCompound toNBT(boolean saveDepleted) {
        NBTTagCompound result = new NBTTagCompound();
        result.func_74768_a("x", this.x);
        result.func_74768_a("z", this.z);
        result.func_74778_a("name", this.depositname);
        if (saveDepleted) {
            result.func_74757_a("depleted", this.depleted);
        }
        return result;
    }

    public GridPos getGridPos() {
        return new GridPos(GridPos.blockToGridCoords(this.x), GridPos.blockToGridCoords(this.z));
    }

    public List<String> getTooltipStrings() {
        if (this.depleted) {
            ArrayList<String> tooltip = new ArrayList<String>(this.veinInfo.tooltipStrings);
            tooltip.set(0, (String)tooltip.get(0) + I18n.func_135052_a((String)"visualores.gregtech.depleted", (Object[])new Object[0]));
            return tooltip;
        }
        return this.veinInfo.tooltipStrings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OreVeinPosition that = (OreVeinPosition)o;
        return this.x == that.x && this.z == that.z && this.depositname.equals(that.depositname);
    }

    public int hashCode() {
        return Objects.hash(this.x, this.z, this.depositname);
    }
}

