/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.database.gregtech.ore;

import gregtech.api.worldgen.config.OreDepositDefinition;
import gregtech.api.worldgen.config.WorldGenRegistry;
import gregtech.api.worldgen.generator.CachedGridEntry;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockOre;
import hellfall.visualores.VOConfig;
import hellfall.visualores.VisualOres;
import hellfall.visualores.database.gregtech.ore.GridPos;
import hellfall.visualores.database.gregtech.ore.OreVeinInfo;
import hellfall.visualores.database.gregtech.ore.ServerCache;
import hellfall.visualores.database.gregtech.ore.VeinInfoCache;
import hellfall.visualores.lib.io.xol.enklume.MinecraftChunk;
import hellfall.visualores.lib.io.xol.enklume.MinecraftRegion;
import hellfall.visualores.lib.io.xol.enklume.MinecraftWorld;
import it.unimi.dsi.fastutil.ints.Int2BooleanMap;
import it.unimi.dsi.fastutil.ints.Int2BooleanRBTreeMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.DataFormatException;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class OreCacheRetrogenerator {
    public static final int CHUNKS_PER_REGION = 32;
    private static final Int2BooleanMap oreBlockIDs = new Int2BooleanRBTreeMap();

    public static void doRetrogen(World world) {
        if (ConfigHolder.worldgen.generateVeinsInCenterOfChunk && ConfigHolder.worldgen.minVeinsInSection == 1 && ConfigHolder.worldgen.additionalVeinsInSection == 0 && !VOConfig.server.gregtech.forceRetrogenV1) {
            OreCacheRetrogenerator.doRetrogenV2(world);
        } else {
            OreCacheRetrogenerator.doRetrogenV1(world);
        }
    }

    public static void doRetrogenV1(World world) {
        VisualOres.LOGGER.info("Starting cache retrogen for dimension " + world.field_73011_w.getDimension());
        File worldFolder = world.func_72860_G().func_75765_b();
        Object2ObjectOpenHashMap generatedGridPositions = new Object2ObjectOpenHashMap();
        ObjectOpenHashSet emptyChunks = new ObjectOpenHashSet();
        try {
            MinecraftWorld mcWorld = new MinecraftWorld(worldFolder);
            for (File regionFile : mcWorld.getAllRegionFiles(world.field_73011_w.getDimension())) {
                String[] parts = regionFile.getName().split("\\.");
                int regionChunkX = Integer.parseInt(parts[1]) * 32;
                int regionChunkZ = Integer.parseInt(parts[2]) * 32;
                MinecraftRegion mcRegion = new MinecraftRegion(regionFile);
                for (int x = 0; x < 32; ++x) {
                    for (int z = 0; z < 32; ++z) {
                        MinecraftChunk chunk = mcRegion.getChunk(x, z);
                        if (chunk.getRootTag() == null) continue;
                        generatedGridPositions.put(GridPos.fromChunkCoords(regionChunkX + x, regionChunkZ + z), new ChunkPos(regionChunkX + x, regionChunkZ + z));
                        if (!VOConfig.server.gregtech.cullEmptyChunksRetrogen) continue;
                        boolean foundOre = false;
                        block6: for (int i = 0; i < 16; ++i) {
                            if (chunk.blocks[i] == null) continue;
                            for (int j = 0; j < chunk.blocks[i].length; ++j) {
                                int blockIDAdd = chunk.add[i] == null ? 0 : OreCacheRetrogenerator.getNibble(chunk.add[i], j);
                                int blockID = blockIDAdd << 12 | (chunk.blocks[i][j] & 0xFF) << 4 | OreCacheRetrogenerator.getNibble(chunk.mData[i], j);
                                if (!OreCacheRetrogenerator.isOreBlock(blockID)) continue;
                                foundOre = true;
                                continue block6;
                            }
                        }
                        if (foundOre) continue;
                        emptyChunks.add(new ChunkPos(regionChunkX + x, regionChunkZ + z));
                    }
                }
            }
        }
        catch (IOException mcWorld) {
        }
        catch (DataFormatException e) {
            throw new RuntimeException(e);
        }
        if (generatedGridPositions.isEmpty()) {
            VisualOres.LOGGER.info("No chunks to retrogen in dimension " + world.field_73011_w.getDimension());
            return;
        }
        VisualOres.LOGGER.info("Retrogenerating " + generatedGridPositions.size() + " grid positions...");
        for (Map.Entry entry : generatedGridPositions.entrySet()) {
            GridPos gridPos = (GridPos)entry.getKey();
            ChunkPos chunkPos = (ChunkPos)entry.getValue();
            int halfSizeX = 1;
            int halfSizeZ = 1;
            for (int gridX = -halfSizeX; gridX <= halfSizeX; ++gridX) {
                for (int gridZ = -halfSizeZ; gridZ <= halfSizeZ; ++gridZ) {
                    CachedGridEntry.getOrCreateEntry((World)world, (int)(gridPos.x + gridX), (int)(gridPos.z + gridZ), (int)chunkPos.field_77276_a, (int)chunkPos.field_77275_b);
                }
            }
        }
        VisualOres.LOGGER.info("Removing {} empty chunks", (Object)emptyChunks.size());
        for (ChunkPos chunk : emptyChunks) {
            ServerCache.instance.removeAllInChunk(world.field_73011_w.getDimension(), chunk);
        }
    }

    public static void doRetrogenV2(World world) {
        VisualOres.LOGGER.info("Starting cache retrogen for dimension " + world.field_73011_w.getDimension());
        File worldFolder = world.func_72860_G().func_75765_b();
        Object2ObjectOpenHashMap centerChunkInPos = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap anyChunkInPos = new Object2ObjectOpenHashMap();
        try {
            MinecraftWorld mcWorld = new MinecraftWorld(worldFolder);
            for (File regionFile : mcWorld.getAllRegionFiles(world.field_73011_w.getDimension())) {
                String[] parts = regionFile.getName().split("\\.");
                int regionChunkX = Integer.parseInt(parts[1]) * 32;
                int regionChunkZ = Integer.parseInt(parts[2]) * 32;
                MinecraftRegion mcRegion = new MinecraftRegion(regionFile);
                for (int x = 0; x < 32; ++x) {
                    for (int z = 0; z < 32; ++z) {
                        MinecraftChunk chunk = mcRegion.getChunk(x, z);
                        if (chunk.getRootTag() == null) continue;
                        GridPos gridPos = GridPos.fromChunkCoords(regionChunkX + x, regionChunkZ + z);
                        ChunkPos centerChunk = gridPos.getChunk(1, 1);
                        if (centerChunk.field_77276_a == regionChunkX + x && centerChunk.field_77275_b == regionChunkZ + z) {
                            centerChunkInPos.put(gridPos, chunk);
                        }
                        anyChunkInPos.put(gridPos, chunk);
                    }
                }
            }
        }
        catch (IOException mcWorld) {
        }
        catch (DataFormatException e) {
            throw new RuntimeException(e);
        }
        if (anyChunkInPos.isEmpty()) {
            VisualOres.LOGGER.info("No chunks to retrogen in dimension " + world.field_73011_w.getDimension());
            return;
        }
        VisualOres.LOGGER.info("Retrogenerating " + anyChunkInPos.size() + " chunks...");
        block6: for (GridPos pos : anyChunkInPos.keySet()) {
            MinecraftChunk chunk = centerChunkInPos.containsKey(pos) ? (MinecraftChunk)centerChunkInPos.get(pos) : (MinecraftChunk)anyChunkInPos.get(pos);
            IntArraySet foundOreIDs = new IntArraySet();
            for (int i = 0; i < 16; ++i) {
                if (chunk.blocks[i] == null) continue;
                for (int j = 0; j < chunk.blocks[i].length; ++j) {
                    int blockIDAdd = chunk.add[i] == null ? 0 : OreCacheRetrogenerator.getNibble(chunk.add[i], j);
                    int blockID = blockIDAdd << 12 | (chunk.blocks[i][j] & 0xFF) << 4 | OreCacheRetrogenerator.getNibble(chunk.mData[i], j);
                    if (!OreCacheRetrogenerator.isOreBlock(blockID)) continue;
                    foundOreIDs.add(blockID);
                }
            }
            Set oreStates = foundOreIDs.stream().map(arg_0 -> ((ObjectIntIdentityMap)Block.field_176229_d).func_148745_a(arg_0)).map(OreVeinInfo::getBaseMaterialName).collect(Collectors.toSet());
            for (OreDepositDefinition deposit : WorldGenRegistry.getOreDeposits()) {
                if (!deposit.isVein() || !deposit.getDimensionFilter().test(world.field_73011_w)) continue;
                int matches = 0;
                for (String mat : VeinInfoCache.getByName((String)deposit.getDepositName()).oreMaterialStrings) {
                    if (!oreStates.contains(mat)) continue;
                    ++matches;
                }
                if (matches <= oreStates.size() / 2) continue;
                BlockPos blockPos = pos.getBlock(24, 0, 24);
                ServerCache.instance.addVein(world.field_73011_w.getDimension(), blockPos.func_177958_n(), blockPos.func_177952_p(), pos.x, pos.z, deposit.getDepositName());
                continue block6;
            }
        }
    }

    private static boolean isOreBlock(int id) {
        IBlockState state;
        if (!oreBlockIDs.containsKey(id) && (state = (IBlockState)Block.field_176229_d.func_148745_a(id)) != null) {
            oreBlockIDs.put(id, state.func_177230_c() instanceof BlockOre);
        }
        return oreBlockIDs.get(id);
    }

    private static int getNibble(byte[] arr, int index) {
        return arr[index / 2] >> 4 * (index % 2) & 0xF;
    }
}

