/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.database.gregtech.ore;

import hellfall.visualores.database.gregtech.ore.OreVeinPosition;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class GridCache {
    private final List<OreVeinPosition> veins = new ArrayList<OreVeinPosition>();

    public boolean addVein(int x, int z, String name) {
        if (this.veins.contains(new OreVeinPosition(x, z, name))) {
            return false;
        }
        this.veins.add(new OreVeinPosition(x, z, name));
        return true;
    }

    public NBTTagList toNBT(boolean saveDepleted) {
        NBTTagList result = new NBTTagList();
        for (OreVeinPosition pos : this.veins) {
            result.func_74742_a((NBTBase)pos.toNBT(saveDepleted));
        }
        return result;
    }

    public void fromNBT(NBTTagList tag) {
        for (NBTBase veinposbase : tag.field_74747_a) {
            NBTTagCompound veinpostag = (NBTTagCompound)veinposbase;
            OreVeinPosition veinpos = new OreVeinPosition(veinpostag.func_74762_e("x"), veinpostag.func_74762_e("z"), veinpostag.func_74779_i("name"));
            if (veinpostag.func_74764_b("depleted")) {
                veinpos.depleted = veinpostag.func_74767_n("depleted");
            }
            if (this.veins.contains(veinpos)) continue;
            this.veins.add(veinpos);
        }
    }

    public List<OreVeinPosition> getVeinsMatching(Predicate<OreVeinPosition> predicate) {
        return this.veins.stream().filter(predicate).collect(Collectors.toList());
    }

    public void removeVeinsMatching(Predicate<OreVeinPosition> predicate) {
        for (int i = 0; i < this.veins.size(); ++i) {
            if (!predicate.test(this.veins.get(i))) continue;
            this.veins.remove(i);
            --i;
        }
    }
}

