/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.database.gregtech.fluid;

import gregtech.api.worldgen.bedrockFluids.BedrockFluidVeinHandler;
import gregtech.api.worldgen.bedrockFluids.ChunkPosDimension;
import hellfall.visualores.database.gregtech.fluid.UndergroundFluidPosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;

public class FluidCache {
    private final Map<ChunkPosDimension, UndergroundFluidPosition> fluidCache = new HashMap<ChunkPosDimension, UndergroundFluidPosition>();

    public void addFluid(int dim, int fieldX, int fieldZ, String fluid, int yield, double percent) {
        UndergroundFluidPosition fluidPos = new UndergroundFluidPosition(dim, fieldX, fieldZ, fluid, yield, percent);
        this.fluidCache.put(fluidPos.pos, fluidPos);
    }

    public List<UndergroundFluidPosition> getFluidsInBounds(int dim, BlockPos topLeft, BlockPos bottomRight) {
        int[] topLeftField = new int[]{BedrockFluidVeinHandler.getVeinCoord((int)(topLeft.func_177958_n() >> 4)), BedrockFluidVeinHandler.getVeinCoord((int)(topLeft.func_177952_p() >> 4))};
        int[] bottomRightField = new int[]{BedrockFluidVeinHandler.getVeinCoord((int)(bottomRight.func_177958_n() >> 4)), BedrockFluidVeinHandler.getVeinCoord((int)(bottomRight.func_177952_p() >> 4))};
        ArrayList<UndergroundFluidPosition> found = new ArrayList<UndergroundFluidPosition>();
        for (int i = topLeftField[0] - 1; i <= bottomRightField[0]; ++i) {
            for (int j = topLeftField[1] - 1; j <= bottomRightField[1]; ++j) {
                ChunkPosDimension currentPos = new ChunkPosDimension(dim, i, j);
                if (!this.fluidCache.containsKey(currentPos)) continue;
                found.add(this.fluidCache.get(currentPos));
            }
        }
        return found;
    }

    public void fromNBT(NBTTagCompound nbt) {
        NBTTagList fluidList = nbt.func_150295_c("fluids", 10);
        for (NBTBase fluidTagRaw : fluidList) {
            if (!(fluidTagRaw instanceof NBTTagCompound)) continue;
            NBTTagCompound fluidTag = (NBTTagCompound)fluidTagRaw;
            UndergroundFluidPosition fluidPos = UndergroundFluidPosition.fromNBT(fluidTag);
            this.fluidCache.put(fluidPos.pos, fluidPos);
        }
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound result = new NBTTagCompound();
        NBTTagList fluidList = new NBTTagList();
        for (UndergroundFluidPosition fluidPos : this.fluidCache.values()) {
            fluidList.func_74742_a((NBTBase)fluidPos.toNBT());
        }
        result.func_74782_a("fluids", (NBTBase)fluidList);
        return result;
    }

    public void clear() {
        this.fluidCache.clear();
    }
}

