/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.database.astralsorcery;

import hellfall.visualores.database.astralsorcery.NeromanticPosition;
import hellfall.visualores.database.astralsorcery.StarfieldPosition;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.fluids.Fluid;

public class ASDimensionCache {
    private final Object2ObjectMap<ChunkPos, StarfieldPosition> starfields = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<ChunkPos, NeromanticPosition> neromanticVeins = new Object2ObjectOpenHashMap();

    public void addStarfields() {
        ChunkPos center = new ChunkPos(Minecraft.func_71410_x().field_71439_g.func_180425_c());
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                ChunkPos current = new ChunkPos(center.field_77276_a + i, center.field_77275_b + j);
                if (this.starfields.containsKey((Object)current)) continue;
                this.starfields.put((Object)current, (Object)new StarfieldPosition(current));
            }
        }
    }

    public List<StarfieldPosition> getStarfieldsInArea(ChunkPos topLeft, ChunkPos bottomRight) {
        ArrayList<StarfieldPosition> result = new ArrayList<StarfieldPosition>();
        for (int i = topLeft.field_77276_a; i <= bottomRight.field_77276_a; ++i) {
            for (int j = topLeft.field_77275_b; j <= bottomRight.field_77275_b; ++j) {
                ChunkPos pos = new ChunkPos(i, j);
                if (!this.starfields.containsKey((Object)pos)) continue;
                result.add((StarfieldPosition)this.starfields.get((Object)pos));
            }
        }
        return result;
    }

    public void setNeromanticFluid(ChunkPos pos, Fluid fluid) {
        this.neromanticVeins.put((Object)pos, (Object)new NeromanticPosition(pos, fluid));
    }

    public List<NeromanticPosition> getNeromanticVeinsInArea(ChunkPos topLeft, ChunkPos bottomRight) {
        ArrayList<NeromanticPosition> result = new ArrayList<NeromanticPosition>();
        for (int i = topLeft.field_77276_a; i <= bottomRight.field_77276_a; ++i) {
            for (int j = topLeft.field_77275_b; j <= bottomRight.field_77275_b; ++j) {
                ChunkPos pos = new ChunkPos(i, j);
                if (!this.neromanticVeins.containsKey((Object)pos)) continue;
                result.add((NeromanticPosition)this.neromanticVeins.get((Object)pos));
            }
        }
        return result;
    }

    public NBTTagCompound toNBT(String prefix) {
        NBTTagCompound result = new NBTTagCompound();
        switch (prefix) {
            case "starfields_": {
                for (ChunkPos key : this.starfields.keySet()) {
                    result.func_74782_a(key.field_77276_a + "," + key.field_77275_b, (NBTBase)((StarfieldPosition)this.starfields.get((Object)key)).toNBT());
                }
                break;
            }
            case "neromantic_": {
                for (ChunkPos key : this.neromanticVeins.keySet()) {
                    result.func_74782_a(key.field_77276_a + "," + key.field_77275_b, (NBTBase)((NeromanticPosition)this.neromanticVeins.get((Object)key)).toNBT());
                }
                break;
            }
        }
        return result;
    }

    public void fromNBT(String prefix, NBTTagCompound nbt) {
        switch (prefix) {
            case "starfields_": {
                for (String nbtKey : nbt.func_150296_c()) {
                    String[] splitpos = nbtKey.split(",");
                    ChunkPos key = new ChunkPos(Integer.parseInt(splitpos[0]), Integer.parseInt(splitpos[1]));
                    this.starfields.put((Object)key, (Object)new StarfieldPosition(nbt.func_74775_l(nbtKey), key.field_77276_a, key.field_77275_b));
                }
                break;
            }
            case "neromantic_": {
                for (String nbtKey : nbt.func_150296_c()) {
                    String[] splitpos = nbtKey.split(",");
                    ChunkPos key = new ChunkPos(Integer.parseInt(splitpos[0]), Integer.parseInt(splitpos[1]));
                    this.neromanticVeins.put((Object)key, (Object)new NeromanticPosition(nbt.func_74779_i(nbtKey), key.field_77276_a, key.field_77275_b));
                }
                break;
            }
        }
    }
}

