/*
 * Decompiled with CFR 0.152.
 */
package hellfall.visualores.database;

import hellfall.visualores.database.IClientCache;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.io.FileUtils;

public class ClientCacheManager {
    public static final File clientCacheDir = new File(Minecraft.func_71410_x().field_71412_D, "visualores");
    private static File worldFolder;
    private static final Reference2ObjectMap<IClientCache, ClientCacheInfo> caches;
    private static boolean shouldInit;

    public static void init(String worldid) {
        if (shouldInit) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            worldFolder = new File(clientCacheDir, player.getDisplayNameString() + "_" + player.func_110124_au() + File.separator + worldid);
            worldFolder.mkdirs();
            ClientCacheManager.clearCaches();
            ClientCacheManager.loadCaches();
            shouldInit = false;
        }
    }

    private static void loadCaches() {
        for (IClientCache cache : caches.keySet()) {
            cache.setupCacheFiles();
            ClientCacheInfo cacheInfo = (ClientCacheInfo)caches.get((Object)cache);
            cacheInfo.cacheFolder = new File(worldFolder, cacheInfo.key);
            cacheInfo.cacheFolder.mkdirs();
            for (String dimFilePrefix : cacheInfo.dimFilePrefixes) {
                for (File dimFile : ClientCacheManager.getDimFiles(cacheInfo.cacheFolder, dimFilePrefix)) {
                    int dimid = Integer.parseInt(dimFile.getName().substring(dimFilePrefix.length() + 3));
                    try {
                        cache.readDimFile(dimFilePrefix, dimid, CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(dimFile)));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            for (String singleFileName : cacheInfo.singleFiles) {
                File singleFile = new File(cacheInfo.cacheFolder, singleFileName);
                if (!singleFile.exists()) continue;
                try {
                    cache.readSingleFile(singleFileName, CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(singleFile)));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static void clearCaches() {
        for (IClientCache cache : caches.keySet()) {
            cache.clear();
        }
    }

    public static void saveCaches() {
        for (IClientCache cache : caches.keySet()) {
            ClientCacheInfo cacheInfo = (ClientCacheInfo)caches.get((Object)cache);
            for (String dimFilePrefix : cacheInfo.dimFilePrefixes) {
                for (int dim : cache.getExistingDimensions(dimFilePrefix)) {
                    NBTTagCompound data = cache.saveDimFile(dimFilePrefix, dim);
                    if (data == null) continue;
                    File dimFile = new File(cacheInfo.cacheFolder, dimFilePrefix + "DIM" + dim);
                    try {
                        CompressedStreamTools.func_74799_a((NBTTagCompound)data, (OutputStream)new FileOutputStream(dimFile));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            for (String singleFileName : cacheInfo.singleFiles) {
                NBTTagCompound data = cache.saveSingleFile(singleFileName);
                if (data == null) continue;
                File singleFile = new File(cacheInfo.cacheFolder, singleFileName);
                try {
                    CompressedStreamTools.func_74799_a((NBTTagCompound)data, (OutputStream)new FileOutputStream(singleFile));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static void resetCaches() {
        ClientCacheManager.clearCaches();
        for (ClientCacheInfo cacheInfo : caches.values()) {
            FileUtils.deleteQuietly((File)cacheInfo.cacheFolder);
            cacheInfo.cacheFolder.mkdirs();
        }
    }

    public static void registerClientCache(IClientCache cache, String key) {
        caches.put((Object)cache, (Object)new ClientCacheInfo(key));
    }

    public static void addDimFiles(IClientCache cache, String prefix) {
        ((ClientCacheInfo)ClientCacheManager.caches.get((Object)cache)).dimFilePrefixes.add(prefix);
    }

    public static void addSingleFile(IClientCache cache, String prefix) {
        ((ClientCacheInfo)ClientCacheManager.caches.get((Object)cache)).singleFiles.add(prefix);
    }

    public static List<ProspectionInfo> getProspectionShareData() {
        ArrayList<ProspectionInfo> result = new ArrayList<ProspectionInfo>();
        for (IClientCache cache : caches.keySet()) {
            ClientCacheInfo cacheInfo = (ClientCacheInfo)caches.get((Object)cache);
            for (String dimPrefix : cacheInfo.dimFilePrefixes) {
                for (int dim : cache.getExistingDimensions(dimPrefix)) {
                    NBTTagCompound data = cache.saveDimFile(dimPrefix, dim);
                    if (data == null) continue;
                    result.add(new ProspectionInfo(cacheInfo.key, dimPrefix, true, dim, data));
                }
            }
            for (String singleFileName : cacheInfo.singleFiles) {
                NBTTagCompound data = cache.saveSingleFile(singleFileName);
                if (data == null) continue;
                result.add(new ProspectionInfo(cacheInfo.key, singleFileName, false, 0, data));
            }
        }
        return result;
    }

    public static void processProspectionShare(String cacheName, String key, boolean isDimCache, int dim, NBTTagCompound data) {
        for (IClientCache cache : caches.keySet()) {
            ClientCacheInfo cacheInfo = (ClientCacheInfo)caches.get((Object)cache);
            if (!cacheInfo.key.equals(cacheName)) continue;
            if (isDimCache) {
                cache.readDimFile(key, dim, data);
                break;
            }
            cache.readSingleFile(key, data);
            break;
        }
    }

    public static File getWorldFolder() {
        return worldFolder;
    }

    public static void allowReinit() {
        shouldInit = true;
    }

    private static List<File> getDimFiles(File parent, String prefix) {
        List<File> list;
        block8: {
            Stream<Path> stream = Files.walk(parent.toPath(), 1, new FileVisitOption[0]);
            try {
                list = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().startsWith(prefix + "DIM")).map(Path::toFile).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return list;
    }

    static {
        caches = new Reference2ObjectArrayMap();
        shouldInit = true;
    }

    private static class ClientCacheInfo {
        public String key;
        public File cacheFolder;
        public Set<String> dimFilePrefixes;
        public Set<String> singleFiles;

        public ClientCacheInfo(String key) {
            this.key = key;
            this.dimFilePrefixes = new HashSet<String>();
            this.singleFiles = new HashSet<String>();
        }
    }

    public static class ProspectionInfo {
        public String cacheName;
        public String key;
        public boolean isDimCache;
        public int dim;
        public NBTTagCompound data;

        public ProspectionInfo(String cacheName, String key, boolean isDimCache, int dim, NBTTagCompound data) {
            this.cacheName = cacheName;
            this.key = key;
            this.isDimCache = isDimCache;
            this.dim = dim;
            this.data = data;
        }
    }
}

