/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.sync.common.packet;

import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import java.util.List;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import me.ichun.mods.sync.api.SyncStartEvent;
import me.ichun.mods.sync.common.Sync;
import me.ichun.mods.sync.common.packet.PacketPlayerDeath;
import me.ichun.mods.sync.common.packet.PacketZoomCamera;
import me.ichun.mods.sync.common.shell.ShellHandler;
import me.ichun.mods.sync.common.tileentity.TileEntityDualVertical;
import me.ichun.mods.sync.common.tileentity.TileEntityShellConstructor;
import me.ichun.mods.sync.common.tileentity.TileEntityShellStorage;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;

public class PacketSyncRequest
extends AbstractPacket {
    private static final List<String> CAP_NBT_BLACKLIST = ImmutableList.of((Object)"baubles:container");
    public BlockPos pos;
    public int dimID;
    public BlockPos shellPos;
    public int shellDimID;

    public PacketSyncRequest() {
    }

    public PacketSyncRequest(BlockPos pos, int dimID, BlockPos targetShellPos, int targetShellDimID) {
        this.pos = pos;
        this.dimID = dimID;
        this.shellPos = targetShellPos;
        this.shellDimID = targetShellDimID;
    }

    public void writeTo(ByteBuf buffer) {
        buffer.writeLong(this.pos.func_177986_g());
        buffer.writeInt(this.dimID);
        buffer.writeLong(this.shellPos.func_177986_g());
        buffer.writeInt(this.shellDimID);
    }

    public void readFrom(ByteBuf buffer) {
        this.pos = BlockPos.func_177969_a((long)buffer.readLong());
        this.dimID = buffer.readInt();
        this.shellPos = BlockPos.func_177969_a((long)buffer.readLong());
        this.shellDimID = buffer.readInt();
    }

    public void execute(Side side, EntityPlayer player) {
        boolean valid = false;
        WorldServer worldOri = DimensionManager.getWorld((int)this.dimID);
        WorldServer world = DimensionManager.getWorld((int)this.shellDimID);
        if (worldOri != null && world != null) {
            TileEntity oriTe = worldOri.func_175625_s(this.pos);
            TileEntity te = world.func_175625_s(this.shellPos);
            if (oriTe instanceof TileEntityDualVertical && te instanceof TileEntityDualVertical) {
                TileEntityDualVertical originShell = (TileEntityDualVertical)oriTe;
                TileEntityDualVertical targetShell = (TileEntityDualVertical)te;
                if (originShell.matchesPlayer(player) && targetShell.matchesPlayer(player)) {
                    TileEntityShellStorage ss;
                    if (targetShell instanceof TileEntityShellConstructor) {
                        TileEntityShellConstructor sc = (TileEntityShellConstructor)targetShell;
                        if (sc.constructionProgress < (float)Sync.config.shellConstructionPowerRequirement) {
                            ShellHandler.updatePlayerOfShells(player, null, true);
                            return;
                        }
                    }
                    if (targetShell instanceof TileEntityShellStorage) {
                        ss = (TileEntityShellStorage)targetShell;
                        if (!ss.syncing) {
                            ShellHandler.updatePlayerOfShells(player, null, true);
                            return;
                        }
                    }
                    if (originShell instanceof TileEntityShellStorage) {
                        ss = (TileEntityShellStorage)originShell;
                        ss.setPlayerName(player);
                        ss.occupied = true;
                        ss.occupationTime = 40;
                        ss.syncing = true;
                        player.func_70066_B();
                        NBTTagCompound tag = new NBTTagCompound();
                        player.func_189511_e(tag);
                        if (tag.func_150297_b("ForgeCaps", 10)) {
                            NBTTagCompound forgeCaps = tag.func_74775_l("ForgeCaps");
                            for (String blacklistedKey : CAP_NBT_BLACKLIST) {
                                if (!forgeCaps.func_74764_b(blacklistedKey)) continue;
                                forgeCaps.func_82580_o(blacklistedKey);
                            }
                        }
                        tag.func_74768_a("sync_playerGameMode", ((EntityPlayerMP)player).field_71134_c.func_73081_b().func_77148_a());
                        ss.setPlayerNBT(tag);
                        IBlockState state = worldOri.func_180495_p(ss.func_174877_v());
                        IBlockState state1 = worldOri.func_180495_p(ss.func_174877_v().func_177972_a(EnumFacing.UP));
                        worldOri.func_184138_a(ss.func_174877_v(), state, state, 3);
                        worldOri.func_184138_a(ss.func_174877_v().func_177972_a(EnumFacing.UP), state1, state1, 3);
                    }
                    Sync.channel.sendTo((AbstractPacket)new PacketZoomCamera(this.pos, this.dimID, originShell.face, false, false), player);
                    targetShell.resyncPlayer = 120;
                    originShell.canSavePlayer = -1;
                    targetShell.resyncOrigin = originShell;
                    ShellHandler.syncInProgress.put(player.func_70005_c_(), targetShell);
                    MinecraftForge.EVENT_BUS.post((Event)new SyncStartEvent(player, originShell.getPlayerNBT(), targetShell.getPlayerNBT(), targetShell.func_174877_v()));
                    Sync.channel.sendToAll((AbstractPacket)new PacketPlayerDeath(player.func_70005_c_(), false));
                    valid = true;
                }
            }
        }
        if (!valid) {
            Sync.LOGGER.warn("Request was invalid!");
            ShellHandler.updatePlayerOfShells(player, null, true);
        }
    }

    public Side receivingSide() {
        return Side.SERVER;
    }
}

