/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.sync.common.core;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import me.ichun.mods.sync.common.Sync;
import me.ichun.mods.sync.common.shell.ShellHandler;
import me.ichun.mods.sync.common.tileentity.TileEntityDualVertical;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ChunkLoadHandler
implements ForgeChunkManager.LoadingCallback {
    public static final HashMap<TileEntityDualVertical, ForgeChunkManager.Ticket> shellTickets = new HashMap();

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket ticket : tickets) {
            if (ticket == null) continue;
            TileEntity te = world.func_175625_s(new BlockPos(ticket.getModData().func_74762_e("shellX"), ticket.getModData().func_74762_e("shellY"), ticket.getModData().func_74762_e("shellZ")));
            if (te instanceof TileEntityDualVertical) {
                TileEntityDualVertical dv = (TileEntityDualVertical)te;
                ForgeChunkManager.Ticket ticket1 = shellTickets.get((Object)dv);
                if (ticket1 != null) {
                    ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket1);
                }
                shellTickets.put(dv, ticket);
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)new ChunkPos(dv.func_174877_v().func_177958_n() >> 4, dv.func_174877_v().func_177952_p() >> 4));
                continue;
            }
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        }
    }

    public static void removeShellAsChunkloader(TileEntityDualVertical dv) {
        ForgeChunkManager.Ticket ticket = shellTickets.get((Object)dv);
        if (ticket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        }
        shellTickets.remove((Object)dv);
        EntityPlayerMP player = dv.getPlayerIfAvailable();
        if (player != null) {
            ShellHandler.updatePlayerOfShellRemoval((EntityPlayer)player, dv);
        }
    }

    public static void addShellAsChunkloader(TileEntityDualVertical dv) {
        ChunkPos chunkCoordIntPair;
        if (dv != null && !ChunkLoadHandler.isAlreadyChunkLoaded(chunkCoordIntPair = new ChunkPos(dv.func_174877_v().func_177958_n() >> 4, dv.func_174877_v().func_177952_p() >> 4), dv.func_145831_w().field_73011_w.getDimension())) {
            ForgeChunkManager.Ticket ticket = shellTickets.get((Object)dv);
            if (ticket == null) {
                ticket = ForgeChunkManager.requestTicket((Object)Sync.instance, (World)dv.func_145831_w(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            }
            if (ticket != null) {
                ticket.getModData().func_74768_a("shellX", dv.func_174877_v().func_177958_n());
                ticket.getModData().func_74768_a("shellY", dv.func_174877_v().func_177956_o());
                ticket.getModData().func_74768_a("shellZ", dv.func_174877_v().func_177952_p());
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)chunkCoordIntPair);
                if (Sync.config.allowChunkLoading == 0) {
                    try {
                        LinkedHashSet requestedChunks = (LinkedHashSet)ObfuscationReflectionHelper.getPrivateValue(ForgeChunkManager.Ticket.class, (Object)ticket, (String)"requestedChunks");
                        requestedChunks.clear();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            shellTickets.put(dv, ticket);
            EntityPlayerMP player = dv.getPlayerIfAvailable();
            if (player != null) {
                ShellHandler.updatePlayerOfShells((EntityPlayer)player, null, true);
            }
        }
    }

    public static boolean isAlreadyChunkLoaded(TileEntityDualVertical dualVertical) {
        ChunkPos chunkCoordIntPair = new ChunkPos(dualVertical.func_174877_v().func_177958_n() >> 4, dualVertical.func_174877_v().func_177952_p() >> 4);
        return shellTickets.containsKey((Object)dualVertical) || ChunkLoadHandler.isAlreadyChunkLoaded(chunkCoordIntPair, dualVertical.func_145831_w().field_73011_w.getDimension());
    }

    public static boolean isAlreadyChunkLoaded(ChunkPos chunkCoordIntPair, int dimID) {
        for (Map.Entry<TileEntityDualVertical, ForgeChunkManager.Ticket> set : shellTickets.entrySet()) {
            ImmutableSet loadedChunks;
            if (set == null || set.getValue() == null || (loadedChunks = set.getValue().getChunkList()) == null || set.getValue().world.field_73011_w.getDimension() != dimID) continue;
            for (ChunkPos theChunks : loadedChunks) {
                if (!theChunks.equals((Object)chunkCoordIntPair)) continue;
                return true;
            }
        }
        return false;
    }
}

