/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.sync.client.core;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import me.ichun.mods.ichunutil.common.core.util.EntityHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SyncSkinManager {
    private static final Cache<String, ResourceLocation> skinCache = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.MINUTES).build();
    private static final Multimap<String, Consumer<ResourceLocation>> callbackMap = MultimapBuilder.hashKeys().arrayListValues().build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void get(String playerName, UUID playerUUID, Consumer<ResourceLocation> callback) {
        NetworkPlayerInfo playerInfo;
        ResourceLocation loc = (ResourceLocation)skinCache.getIfPresent((Object)playerName);
        if (loc != null) {
            callback.accept(loc);
            return;
        }
        NetHandlerPlayClient networkHandler = Minecraft.func_71410_x().func_147114_u();
        NetworkPlayerInfo networkPlayerInfo = playerInfo = networkHandler == null ? null : networkHandler.func_175104_a(playerName);
        if (playerInfo != null && (loc = playerInfo.func_178837_g()) != DefaultPlayerSkin.func_177334_a((UUID)playerInfo.func_178845_a().getId())) {
            callback.accept(loc);
            skinCache.put((Object)playerName, (Object)loc);
            return;
        }
        if (playerUUID == null) {
            return;
        }
        GameProfile profile = EntityHelper.getGameProfile((UUID)playerUUID, (String)playerName);
        Multimap<String, Consumer<ResourceLocation>> multimap = callbackMap;
        synchronized (multimap) {
            if (!callbackMap.containsKey((Object)playerName)) {
                Minecraft.func_71410_x().func_152342_ad().func_152790_a(profile, (type, location, profileTexture) -> {
                    if (type == MinecraftProfileTexture.Type.SKIN) {
                        Multimap<String, Consumer<ResourceLocation>> multimap = callbackMap;
                        synchronized (multimap) {
                            callbackMap.removeAll((Object)playerName).forEach(consumer -> consumer.accept(location));
                        }
                        skinCache.put((Object)playerName, (Object)location);
                    }
                }, true);
            }
            callbackMap.put((Object)playerName, callback);
        }
    }

    public static void invalidateCaches() {
        skinCache.invalidateAll();
        skinCache.cleanUp();
        callbackMap.clear();
    }
}

