/*
 * Decompiled with CFR 0.152.
 */
package com.theundertaker11.geneticsreborn.util;

import com.theundertaker11.geneticsreborn.api.capability.genes.EnumGenes;
import com.theundertaker11.geneticsreborn.api.capability.genes.GeneCapabilityProvider;
import com.theundertaker11.geneticsreborn.api.capability.genes.IGenes;
import com.theundertaker11.geneticsreborn.api.capability.maxhealth.IMaxHealth;
import com.theundertaker11.geneticsreborn.api.capability.maxhealth.MaxHealthCapabilityProvider;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ModUtils {
    public static final int moveSpeed = 1;
    public static final int moveSlowness = 2;
    public static final int haste = 3;
    public static final int miningFatigure = 4;
    public static final int strength = 5;
    public static final int jumpBoost = 8;
    public static final int nausea = 9;
    public static final int regeneration = 10;
    public static final int resistance = 11;
    public static final int fireResistance = 12;
    public static final int waterBreathing = 13;
    public static final int invisibility = 14;
    public static final int blindness = 15;
    public static final int nightVision = 16;
    public static final int hunger = 17;
    public static final int weakness = 18;
    public static final int poison = 19;
    public static final int wither = 20;
    public static final int absorbtion = 22;
    public static final int glowing = 24;
    public static final int levetation = 25;
    public static final int luck = 26;
    public static final int badLuck = 27;
    public static final int ATTRIBUTE_MODIFIER_OPERATION_ADD = 0;

    public static NBTTagCompound getTagCompound(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        return tag;
    }

    public static boolean isValidFuel(ItemStack stack) {
        return TileEntityFurnace.func_145952_a((ItemStack)stack) > 0;
    }

    public static void TeleportPlayer(EntityPlayer player, double x, double y, double z, int dimension) {
        if (player.field_71093_bK == dimension) {
            player.func_70634_a(x, y, z);
        } else {
            player.func_184204_a(dimension);
            player.func_70634_a(x, y, z);
        }
    }

    @Nullable
    public static IGenes getIGenes(Entity entityliving) {
        if (entityliving instanceof EntityLivingBase) {
            return (IGenes)entityliving.getCapability(GeneCapabilityProvider.GENES_CAPABILITY, null);
        }
        return null;
    }

    @Nullable
    public static IMaxHealth getIMaxHealth(EntityLivingBase entity) {
        return (IMaxHealth)entity.getCapability(MaxHealthCapabilityProvider.MAX_HEALTH_CAPABILITY, null);
    }

    public static String getGeneNameForShow(String rawname) {
        if ("GeneticsRebornBasicGene".equals(rawname)) {
            return "Basic Gene";
        }
        if ("GeneticsRebornMutatedGene".equals(rawname)) {
            return "Mutated Gene";
        }
        EnumGenes gene = EnumGenes.fromGeneName(rawname);
        if (gene == null) {
            return "This is an error. Report to Genetics Reborn Github.";
        }
        return gene.getDescription();
    }

    public static boolean isGeneEnabled(String rawname) {
        if (rawname.equals("GeneticsRebornBasicGene")) {
            return true;
        }
        if (rawname.equals("GeneticsRebornMutatedGene")) {
            return true;
        }
        EnumGenes gene = EnumGenes.fromGeneName(rawname);
        return gene == null ? false : gene.isActive();
    }

    public static List<Entity> getEntitiesInRange(Class<? extends Entity> entityType, World world, double x, double y, double z, double radius) {
        return world.func_72872_a(entityType, new AxisAlignedBB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius));
    }

    private static double getDistanceSq(BlockPos pos1, BlockPos pos2) {
        return (pos1.func_177958_n() - pos2.func_177958_n()) * (pos1.func_177958_n() - pos2.func_177958_n()) + (pos1.func_177956_o() - pos2.func_177956_o()) * (pos1.func_177956_o() - pos2.func_177956_o()) + (pos1.func_177952_p() - pos2.func_177952_p()) * (pos1.func_177952_p() - pos2.func_177952_p());
    }

    public static EntityLivingBase getNearestEntity(World w, BlockPos pos, double reach) {
        if (reach <= 0.0) {
            return null;
        }
        if (w == null || pos == null) {
            return null;
        }
        EntityLivingBase closest = null;
        double distanceSq = reach * reach;
        AxisAlignedBB aabb = new AxisAlignedBB((double)pos.func_177958_n() - reach, (double)pos.func_177956_o() - reach, (double)pos.func_177952_p() - reach, (double)pos.func_177958_n() + reach, (double)pos.func_177956_o() + reach, (double)pos.func_177952_p() + reach);
        List listEntitiesInRange = w.func_72872_a(EntityLivingBase.class, aabb);
        for (EntityLivingBase next : listEntitiesInRange) {
            if (!(ModUtils.getDistanceSq(next.func_180425_c(), pos) < distanceSq)) continue;
            closest = next;
        }
        return closest;
    }

    public static Vec3d findRandomBlockNear(World w, double dx, double dy, double dz, int range) {
        boolean blockOK = false;
        int x = 0;
        int y = 0;
        int z = 0;
        int xx = 0;
        int yy = 0;
        int zz = 0;
        while (!blockOK) {
            x = MathHelper.func_76128_c((double)dx);
            y = MathHelper.func_76128_c((double)dy);
            z = MathHelper.func_76128_c((double)dz);
            xx = w.field_73012_v.nextInt(range) - range / 2;
            zz = w.field_73012_v.nextInt(range) - range / 2;
            yy = 0;
            while (!w.func_175623_d(new BlockPos(x + xx, y + yy, z + xx))) {
                ++yy;
            }
            while (w.func_175623_d(new BlockPos(x + xx, y + yy - 1, z + xx))) {
                --yy;
            }
            Block b = w.func_180495_p(new BlockPos(x + xx, y + yy - 1, z + xx)).func_177230_c();
            blockOK = b != Blocks.field_150353_l && b != Blocks.field_150356_k;
        }
        return new Vec3d((double)(x + xx), (double)(y + yy), (double)(z + zz));
    }
}

