/*
 * Decompiled with CFR 0.152.
 */
package com.theundertaker11.geneticsreborn.event;

import com.google.common.base.Predicate;
import com.theundertaker11.geneticsreborn.GeneticsReborn;
import com.theundertaker11.geneticsreborn.api.capability.genes.EnumGenes;
import com.theundertaker11.geneticsreborn.util.ModUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class AIChangeEvents {
    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        Entity e = event.getEntity();
        if (e instanceof EntityPlayer) {
            AbstractAttributeMap map = ((EntityPlayer)e).func_110140_aT();
            if (map.func_111151_a(GeneticsReborn.CLIMBING_ATT) == null) {
                map.func_111150_b(GeneticsReborn.CLIMBING_ATT);
            }
            if (map.func_111151_a(GeneticsReborn.EFFICIENCY_ATT) == null) {
                map.func_111150_b(GeneticsReborn.EFFICIENCY_ATT);
            }
        }
        if (e instanceof EntityCreeper) {
            this.attachScareTask(event, (EntityCreature)event.getEntity(), (Predicate<? super EntityPlayer>)((Predicate)this::hasCreeperGene));
        }
        if (e instanceof EntityZombie) {
            this.attachScareTask(event, (EntityCreature)event.getEntity(), (Predicate<? super EntityPlayer>)((Predicate)this::hasZombieGene));
        }
        if (e instanceof EntitySkeleton) {
            this.attachScareTask(event, (EntityCreature)event.getEntity(), (Predicate<? super EntityPlayer>)((Predicate)this::hasSkeletonGene));
        }
        if (e instanceof EntitySpider) {
            this.attachScareTask(event, (EntityCreature)event.getEntity(), (Predicate<? super EntityPlayer>)((Predicate)this::hasSpiderGene));
        }
    }

    private boolean hasScareGene(@Nullable EntityPlayer player, EnumGenes gene) {
        return ModUtils.getIGenes((Entity)player) != null && ModUtils.getIGenes((Entity)player).hasGene(gene);
    }

    private boolean hasCreeperGene(@Nullable EntityPlayer player) {
        return this.hasScareGene(player, EnumGenes.SCARE_CREEPERS);
    }

    private boolean hasSkeletonGene(@Nullable EntityPlayer player) {
        return this.hasScareGene(player, EnumGenes.SCARE_SKELETONS);
    }

    private boolean hasZombieGene(@Nullable EntityPlayer player) {
        return this.hasScareGene(player, EnumGenes.SCARE_ZOMBIES);
    }

    private boolean hasSpiderGene(@Nullable EntityPlayer player) {
        return this.hasScareGene(player, EnumGenes.SCARE_SPIDERS);
    }

    public void attachScareTask(EntityJoinWorldEvent event, EntityCreature entity, Predicate<? super EntityPlayer> predicate) {
        if (entity instanceof EntityCreeper) {
            entity.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity(entity, EntityPlayer.class, predicate, 6.0f, 1.0, 1.2));
        }
        if (entity instanceof EntityPigZombie) {
            for (Object a : entity.field_70715_bh.field_75782_a.toArray()) {
                EntityAIBase ai = ((EntityAITasks.EntityAITaskEntry)a).field_75733_a;
                if (!(ai instanceof EntityAINearestAttackableTarget)) continue;
                entity.field_70715_bh.func_85156_a(ai);
                entity.field_70715_bh.func_75776_a(0, new AITargetAggressor<EntityPlayer>(entity, EntityPlayer.class, 10, true, false, predicate));
            }
        } else {
            for (Object a : entity.field_70715_bh.field_75782_a.toArray()) {
                EntityAIBase ai = ((EntityAITasks.EntityAITaskEntry)a).field_75733_a;
                if (!(ai instanceof EntityAINearestAttackableTarget)) continue;
                entity.field_70715_bh.func_85156_a(ai);
                entity.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget(entity, EntityPlayer.class, 10, true, false, player -> !predicate.test(player)));
            }
        }
    }

    static class AITargetAggressor<T extends EntityLivingBase>
    extends EntityAINearestAttackableTarget<T> {
        public AITargetAggressor(EntityCreature creature, Class<T> classTarget, int chance, boolean checkSight, boolean onlyNearby, Predicate<? super T> targetSelector) {
            super(creature, classTarget, chance, checkSight, onlyNearby, targetSelector);
        }

        public boolean func_75250_a() {
            return ((EntityPigZombie)this.field_75299_d).func_175457_ck() && super.func_75250_a();
        }
    }
}

