/*
 * Decompiled with CFR 0.152.
 */
package com.theundertaker11.geneticsreborn.api.capability.maxhealth;

import com.theundertaker11.geneticsreborn.api.capability.maxhealth.IMaxHealth;
import java.util.Collections;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityProperties;
import net.minecraft.world.WorldServer;

public class MaxHealth
implements IMaxHealth {
    protected static final UUID MODIFIER_ID = UUID.fromString("9a847987-fa89-4b4c-8bd7-6796789711c9");
    protected static final String MODIFIER_NAME = "Bonus Max Health";
    protected static final float MIN_AMOUNT = 2.0f;
    private final EntityLivingBase entity;
    private float bonusMaxHealth;
    private final IAttributeInstance dummyMaxHealthAttribute = new AttributeMap().func_111150_b(SharedMonsterAttributes.field_111267_a);

    public MaxHealth(@Nullable EntityLivingBase entity) {
        this.entity = entity;
    }

    public MaxHealth() {
        this(null);
    }

    @Override
    public final float getBonusMaxHealth() {
        return this.bonusMaxHealth;
    }

    @Override
    public final void setBonusMaxHealth(float bonusMaxHealth) {
        this.bonusMaxHealth = bonusMaxHealth;
        this.onBonusMaxHealthChanged();
    }

    @Override
    public final void addBonusMaxHealth(float healthToAdd) {
        this.setBonusMaxHealth(this.getBonusMaxHealth() + healthToAdd);
    }

    @Override
    public void synchronise() {
        if (this.entity != null && !this.entity.func_130014_f_().field_72995_K) {
            IAttributeInstance entityMaxHealthAttribute = this.entity.func_110148_a(SharedMonsterAttributes.field_111267_a);
            SPacketEntityProperties packet = new SPacketEntityProperties(this.entity.func_145782_y(), Collections.singleton(entityMaxHealthAttribute));
            ((WorldServer)this.entity.func_130014_f_()).func_73039_n().func_151248_b((Entity)this.entity, (Packet)packet);
        }
    }

    protected AttributeModifier createModifier() {
        return new AttributeModifier(MODIFIER_ID, MODIFIER_NAME, (double)this.getBonusMaxHealth(), 0);
    }

    protected void onBonusMaxHealthChanged() {
        float oldAmount;
        if (this.entity == null) {
            return;
        }
        IAttributeInstance entityMaxHealthAttribute = this.entity.func_110148_a(SharedMonsterAttributes.field_111267_a);
        this.dummyMaxHealthAttribute.func_111122_c().forEach(arg_0 -> ((IAttributeInstance)this.dummyMaxHealthAttribute).func_111124_b(arg_0));
        this.dummyMaxHealthAttribute.func_111128_a(entityMaxHealthAttribute.func_111125_b());
        entityMaxHealthAttribute.func_111122_c().stream().filter(modifier -> !modifier.func_111167_a().equals(MODIFIER_ID)).forEach(arg_0 -> ((IAttributeInstance)this.dummyMaxHealthAttribute).func_111121_a(arg_0));
        AttributeModifier modifier2 = this.createModifier();
        this.dummyMaxHealthAttribute.func_111121_a(modifier2);
        while (this.dummyMaxHealthAttribute.func_111126_e() < 2.0) {
            this.dummyMaxHealthAttribute.func_111124_b(modifier2);
            this.bonusMaxHealth += 0.5f;
            modifier2 = this.createModifier();
            this.dummyMaxHealthAttribute.func_111121_a(modifier2);
        }
        float newAmount = this.getBonusMaxHealth();
        AttributeModifier oldModifier = entityMaxHealthAttribute.func_111127_a(MODIFIER_ID);
        if (oldModifier != null) {
            entityMaxHealthAttribute.func_111124_b(oldModifier);
            oldAmount = (float)oldModifier.func_111164_d();
        } else {
            oldAmount = 0.0f;
        }
        entityMaxHealthAttribute.func_111121_a(modifier2);
        float amountToHeal = newAmount - oldAmount;
        if (amountToHeal > 0.0f) {
            this.entity.func_70691_i(amountToHeal);
        }
    }
}

